<?php

namespace WPPayFormPro\Integrations\Zapier;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Exception;
use WPPayForm\App\Models\Meta;
use WPPayForm\App\Models\Form;

class Client
{
    use NotifyTrait;

    protected $table = 'wpf_meta';
    protected $metaKey = 'zapier_feeds';
    protected $baseUrl = 'https://hooks.zapier.com/hooks/catch/';

    /**
     * Get Zapier Feeds
     * @return JSON Response
     */
    // public function getNotifications($formId)
    // {

    //     $hooks = Meta::where('form_id', $formId)
    //     ->where('meta_key', $this->metaKey)
    //     ->get();

    //     foreach ($hooks as $hook) {
    //         $hook->meta_value = json_decode($hook->meta_value);
    //     }

    //     return array(
    //         'data' => $hooks,
    //         'inputs' => Form::getInputShortcode($formId)
    //     );
    // }

    // protected function validate($request)
    // {
    //     $request['value']['url'] = esc_url_raw($request['value']['url']);
    //     $request['value']['name'] = sanitize_text_field($request['value']['name']);
    //     return $request;
    // }

    /**
     * Save Zapier Feed
     * @return JSON Response
     */
    // public function saveNotification($request, $formId)
    // {
    //     $data = $this->validate($request->data);

    //     if (empty($data['id'])) {
    //         $id = $this->insertNotification($data);
    //     } else {
    //         $id = $this->updateNotification($data);
    //     }

    //     return array(
    //         'id' => $id
    //     );
    // }

    // protected function insertNotification($data)
    // {
    //     return Meta::insert([
    //         'meta_key' => $this->metaKey,
    //         'meta_group' => 'integration',
    //         'form_id' => $data['form_id'],
    //         'meta_value' => json_encode($data['value']),
    //         'created_at' => current_time('mysql'),
    //         'updated_at' => current_time('mysql')
    //     ]);
    // }

    // protected function updateNotification($data)
    // {
    //     Meta::where('id', $id = intval($data['id']))
    //     ->update([
    //         'meta_value' => json_encode($data['value']),
    //         'updated_at' => current_time('mysql')
    //     ]);

    //     return $id;
    // }

    // /**
    //  * Delete Zapier Feed
    //  * @return JSON Response
    //  */
    // public function deleteNotification($request, $formId)
    // {
    //     $data = $request->all();

    //     try {
    //         Meta::where('id', $data['meta_id'])
    //         ->delete();
    //         return array(
    //             'message' => 'Deleted successfully!'
    //         );
    //     } catch (Exception $e) {
    //         wp_send_json_error($e->get_error_message());
    //     }
    // }


    public static function verifyEndpoint($formId) : array
    {

        $form = Form::getInputShortcode($formId);

        $fields = array_map(function ($f) {
            return str_replace('.*', '', $f);
        }, array_keys($form));

        $webHook = Meta::where('form_id', $formId)
            ->where('meta_key', 'zapier_feeds')
            ->first();

        $webHook = json_decode($webHook->meta_value);

        $requestData = json_encode(
            array_combine($fields, array_fill(0, count($fields), ''))
        );

        $requestHeaders['Content-Type'] = 'application/json';

        $payload = [
            'body'    => $requestData,
            'method'  => 'POST',
            'headers' => $requestHeaders
        ];

        $response = wp_remote_request($webHook->url, $payload);

        if (is_wp_error($response)) {
            return array(
                'success' => false,
                'message' => $response->get_error_message()
            );
        }

        return array(
            'success' => true,
            'message' => __('Sample sent successfully.'),
        );
    }
}
