<?php

/**
 * Plugin Name: PaymatticPro
 * Plugin URI:  https://paymattic.com/
 * Description: Create and Accept Payments in minutes with Stripe, PayPal with built-in form builder
 * Author: WPManageNinja LLC
 * Author URI:  https://paymattic.com
 * Version: 4.6.10
 * Text Domain: wp-payment-form-pro
 * Domain Path: /language
 */

if (!defined('ABSPATH')) {
    exit;
}

defined('ABSPATH') or die;

define('WPPAYFORMPRO', true);
define('WPPAYFORMPRO_VERSION', '4.6.10');
define('WPPAYFORMPRO_UPLOAD_DIR', '/wppayform');
define('WPPAYFORMPRO_DIR_URL', plugin_dir_url(__FILE__));
define('WPPAYFORMPRO_DIR_PATH', plugin_dir_path(__FILE__));
define('WPPAYFORMPRO_DIR_FILE', __FILE__);

if (!defined('WPPAYFORMHASPRO')) {
    define('WPPAYFORMHASPRO', true);
}

include WPPAYFORMPRO_DIR_PATH . 'autoload.php';
use WPPayForm\Framework\Support\Arr;

if (!class_exists('WPPayFormPro')) {
    class WPPayFormPro
    {
        protected $addOns = array(
            'WPPayFormPro\Integrations\ActiveCampaign',
            'WPPayFormPro\Integrations\Zapier',
            'WPPayFormPro\Integrations\Webhook',
            'WPPayFormPro\Integrations\UserRegistration',
            'WPPayFormPro\Integrations\SMSNotification',
            'WPPayFormPro\Integrations\Telegram',
            'WPPayFormPro\Integrations\LearnDash',
            'WPPayFormPro\Integrations\LifterLMS',
            'WPPayFormPro\Integrations\TutorLMS',
            'WPPayFormPro\Integrations\GoogleSheet'
        );

        public function boot($app)
        {
            if (defined('WPPAYFORM_VERSION') && version_compare(WPPAYFORM_VERSION, '4.6.0', '<') && version_compare(WPPAYFORMPRO_VERSION, '4.6.0', '>=')) {
                add_action('admin_notices', function () {
                    $class = 'notice notice-error fc_message';
                    $message = 'Please update the free version of Paymattic to latest to avoid any issues.';
                    printf('<div class="%1$s"><p>%2$s</p></div>', esc_attr($class), $message);
                });
            }
            $this->commonHooks();
            $this->registerAddOns();
            $this->adminDependency($app);

            add_action('init', array($this, 'translate'));
        }

        public function translate()
        {
            load_plugin_textdomain('wp-payment-form-pro', false, dirname(plugin_basename(__FILE__)) . '/language');
        }

        public function adminDependency($app)
        {
            //pro version file init
            (new WPPayFormPro())->registerRoutes($app->router);

            add_filter('wppayform/form_entry_recurring_info', array("\WPPayFormPro\Classes\RecurringInfo", 'addRecurringSubscriptions'), 10, 1);
            add_action('wppayform/after_delete_submission', array("\WPPayFormPro\Classes\RecurringInfo", 'deleteSubscriptionData'), 99, 1);
            //payment method meta data
            add_filter('wpf_form_export_meta', function ($formattedMeta, $formId) {
                $metaVal = WPPayForm\App\Models\Meta::getFormMeta($formId, '_payment_settings', []);
                $metas[] = array(
                    'wpf_meta_key' => '_payment_settings',
                    'wpf_meta_value' => $metaVal
                );
                foreach ($metas as $meta) {
                    $formattedMeta[$meta['wpf_meta_key']] = safeUnserialize($meta['wpf_meta_value']);
                }
                return $formattedMeta;
            }, 10, 2);
            // coupon actions
            $CouponController = new \WPPayFormPro\Classes\Coupons\CouponController();
            add_action('wp_ajax_wpf_coupon_apply', array($CouponController, 'validateCoupon'));
            add_action('wp_ajax_nopriv_wpf_coupon_apply', array($CouponController, 'validateCoupon'));
            add_action('wppayform/maybe_add_coupon_meta', array($CouponController, 'maybeAddCouponMeta'), 99, 3);

            // Customer Dashboard action
            $dashboard = new \WPPayFormPro\Classes\Dashboard\Render;

            add_action('wp_ajax_wpf_sync_subscription', array($dashboard, 'syncSubscriptionAjaxController'));
            // add_action('wp_ajax_nopriv_wpf_sync_subscription', array($dashboard, 'syncSubscriptionAjaxController')); //non logged in users shouldn't be able to sync

            add_action('wp_ajax_wpf_cancel_subscription', array($dashboard, 'cancelSubscription'));
            // add_action('wp_ajax_nopriv_wpf_cancel_subscription', array($dashboard, 'cancelSubscription')); //non logged in users shouldn't be able to cancel

            $licenseManager = new \WPPayFormPro\PluginManager\LicenseManager;
            $licenseManager->initUpdater();

            $licenseMessage = $licenseManager->getLicenseMessages();

            if ($licenseMessage) {
                add_action('admin_notices', function () use ($licenseMessage) {
                    $class = 'notice notice-error fc_message';
                    $message = $licenseMessage['message'];
                    printf('<div class="%1$s"><p>%2$s</p></div>', esc_attr($class), $message);
                });
            }

            // Handle Network new Site Activation
            add_action('wp_insert_site', function ($blogId) {
                switch_to_blog($blogId->blog_id);
                \WPPayForm\Database\DBMigrator::migrate();
                restore_current_blog();
            });
        }

        public function registerRoutes($router)
        {
            include WPPAYFORMPRO_DIR_PATH . 'src/Routes/api.php';
        }

        public function registerAddOns()
        {
            foreach ($this->addOns as $addOn) {
                $class = "{$addOn}\Bootstrap";
                new $class();
            }
        }

        public function commonHooks()
        {
            $scheduleSettings = new \WPPayFormPro\Classes\SchedulingSettings();
            $scheduleSettings->checkRestrictionHooks();

            $paymentHandler = new \WPPayFormPro\Classes\PaymentHandler();
            $paymentHandler->init();

            // Additional Form Info Handler
            $infoHandler = new \WPPayFormPro\Classes\FormAdditionalInfo();
            $infoHandler->register();

            $emailHandler = new \WPPayFormPro\Classes\EmailNotification\EmailHandler();
            $emailHandler->register();

            $reminderEmailScheduler = new \WPPayFormPro\Classes\EmailNotification\ReminderEmailScheduler();
            $reminderEmailScheduler->register();

            $userCreation = new \WPPayFormPro\Integrations\UserRegistration\UserCreation();
            $userCreation->register();

            // Init Pro Editor Components Here
            new \WPPayFormPro\Classes\Components\RecurringPaymentComponent();
            new \WPPayFormPro\Classes\Components\TaxItemComponent();
            new \WPPayFormPro\Classes\Components\TabularProductsComponent();
            new \WPPayFormPro\Classes\Components\FileUploadComponent();
            // moved to free version from pro
            // new \WPPayFormPro\Classes\Components\AddressFieldsComponent();
            new \WPPayFormPro\Classes\Components\MaskInputComponent();
            new \WPPayFormPro\Classes\Components\CouponComponent();
            // new \WPPayFormPro\Classes\Components\DonationComponent();
            new \WPPayFormPro\Classes\Components\CurrencySwitcherComponent();

            if(version_compare(WPPAYFORM_VERSION, '4.6.6', '>')){
                new \WPPayFormPro\Classes\Components\DynamicPaymentItemComponent();
            }
            // Custom CSS and JS
            $customCssJS = new \WPPayFormPro\Classes\CustomScripts();
            $customCssJS->registerEndpoints();

            $LearnDashRemove = new \WPPayFormPro\Integrations\LearnDash\RemoveFromCourseAction();
            $LearnDashRemove->init();

            $LifterLMSRemove = new \WPPayFormPro\Integrations\LifterLMS\RemoveFromCourseAction();
            $LifterLMSRemove->init();

            $TutorLMSRemove = new \WPPayFormPro\Integrations\TutorLMS\RemoveFromCourseAction();
            $TutorLMSRemove->init();

            // fluent-community actions
            $fluentCommunity = new \WPPayFormPro\Classes\Dashboard\FluentCommunity();
            $fluentCommunity->register();

            // Default value Parser
            $formDefaultValueRenderer = new \WPPayFormPro\Classes\DefaultValueParser\FormDefaultValueRenderer();
            $formDefaultValueRenderer->register();

            add_shortcode('payform_user_submissions', function ($args) {
                $handler = new \WPPayFormPro\Classes\ProShortCodeHandler();
                return $handler->handleUserSubmissionShortCode($args);
            });

            add_shortcode('wppayform_dashboard', function ($args) {

                $builder = new \WPPayFormPro\Classes\Dashboard\Render();

                return $builder->render();
            });

            add_shortcode('wppayform_leaderboard', function ($args) {
                $formId = Arr::get($args, 'form_id', null);
                $optionKey = 'wppayform_donation_leaderboard_settings';
                if ($formId) {
                    $optionKey = 'wppayform_donation_leaderboard_settings_' . $formId;
                }
                $arguments = get_option($optionKey, array(
                    'enable_donation_for' => 'all',
                    'template_id' => 3,
                    'enable_donation_for_specific' => [],
                    'orderby' => 'grand_total'
                ));
                
                $args = shortcode_atts(
                    array(
                        'template_id' => Arr::get($arguments, 'template_id', 3),
                        'form_id' => null,
                        'donors_per_page' => Arr::get($arguments, 'per_page', 10),
                        'show_total' => Arr::get($arguments, 'show_total', true),
                        'show_name' => Arr::get($arguments, 'show_name', true),
                        'show_avatar' => Arr::get($arguments, 'show_avatar', true),
                        'orderby' => Arr::get($arguments, 'orderBy', 'grand_total'),
                    ),
                    $args
                );
    
    
                if (!$args['template_id']) {
                    $args['template_id'] = 1;
                }
                if ($args['template_id'] > 3) {
                    $args['template_id'] = 0;
                }
                $template_id = "template_" . $args['template_id'];
                // $builder = new \WPPayForm\App\Modules\Builder\Render();
                $builder = new \WPPayForm\App\Modules\LeaderBoard\Render();
                return $builder->render(
                    $template_id,
                    $args['form_id'],
                    $args['donors_per_page'],
                    $args['show_total'],
                    $args['show_name'],
                    $args['show_avatar'],
                    $args['orderby']
                );
            });
        }
    }

    add_action('admin_init', function () {
        if (!defined('WPPAYFORM_VERSION_LITE')) {
            (new \WPPayFormPro\Classes\DependencyHandler\DependencyHandler())->injectProDependency();
        }
    });

    /**
     * Add dependency menu when free version not installed
     */
    add_action('admin_menu', function () {
        if (!defined('WPPAYFORM_VERSION_LITE')) {
            (new \WPPayFormPro\Classes\DependencyHandler\DependencyHandler())->add();
        }
    });


    // fluent pdf hooks
    // add_action('fluent_pdf_loaded', function () {
    //     if (defined('WPPAYFORM_VERSION_LITE')) {
    //         new WPPayForm\App\Modules\PDF\Manager\WPPayFormPdfBuilder();
    //     }
    // });

    add_action('wppayform_loaded', function ($app) {
        // initialize payment handler first to make sure verifyIPN registered before 'init' action triggered

        (new WPPayFormPro())->boot($app);

    });
}
