<?php
if (!defined('ABSPATH')) exit;

class WP_Plugin_Manager_Settings {
    private static $instance = null;
    private $is_pro = true;

    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        $this->is_pro = true;
    }

    public function get_help_section() {
        return [
            'docLink' => 'https://hasthemes.com/docs/wp-plugin-manager/',
            'supportLink' => 'https://hasthemes.com/contact-us/',
            'licenseLink' => admin_url('admin.php?page=wp-plugin-manager-pro'),
            'recommendedPluginsLink' => admin_url('admin.php?page=htpm_recommendations'),
            'upgradeLink' => 'https://hasthemes.com/plugins/wp-plugin-manager-pro/'
        ];
    }

    public function get_menu_settings() {
        return [
            'general' => [
                'label' => __('General', 'htpmpro'),
                'icon' => 'Grid',
                'link' => '/',
                'order' => 1,
                'visible' => true,
                'isRouter' => true
            ],
            'settings' => [
                'label' => __('Settings', 'htpmpro'),
                'icon' => 'Setting',
                'link' => '/settings',
                'order' => 2,
                'visible' => true,
                'isRouter' => true
            ],
            'recommended_plugins' => [
                'label' => __('Recommended Plugins', 'htpmpro'),
                'icon' => 'Promotion',
                'link' => '/recommended',
                'order' => 3,
                'visible' => true,
                'isRouter' => true
            ],
            'license' => [
                'label' => __('License', 'htpmpro'),
                'icon' => 'Key',
                'link' => '/license',
                'order' => 4,
                'visible' => true,
                'isRouter' => true,
            ],
            'documentation' => [
                'label' => __('Documentation', 'htpmpro'),
                'icon' => 'Document',
                'link' => $this->get_help_section()['docLink'],
                'order' => 5,
                'visible' => true,
                'target' => '_blank'
            ],
            'support' => [
                'label' => __('Support', 'htpmpro'),
                'icon' => 'Service',
                'link' => $this->get_help_section()['supportLink'],
                'order' => 6,
                'visible' => true,
                'target' => '_blank'
            ],
        ];
    }
    /**
     * Get Backend Modal Settings - Dynamic select options for pages
     */
    public function get_backend_modal_settings() {
        return [
            'status' => [
                'label' => __('Status: ', 'htpmpro'),
                'type' => 'switch',
                'description' => __('Enable or disable this configuration. When disabled, settings are saved but not applied.', 'htpmpro'),
                'default' => false,
                'pro' => false,
                'enableText' => __('Enabled', 'htpmpro'),
                'disableText' => __('Disabled', 'htpmpro'),
                'proBadge' => false
            ],
            'action_backend' => [
                'label' => __('Action: ', 'htpmpro'),
                'description' => __('Disable on Selected Pages refers to the pages where the plugin will be disabled and enabled elsewhere.', 'htpmpro'),
                'pro' => [],
                'options' => [
                    'disable_on_selected' => __('Disable on Selected Pages', 'htpmpro'),
                    'enable_on_selected' => __('Enable on Selected Pages', 'htpmpro'),
                ],
                'proBadge' => false
            ],
            'admin_scope' => [
                'label' => __('Admin Area Scope: ', 'htpmpro'),
                'description' => __('Choose which section of WordPress admin this rule should apply to.', 'htpmpro'),
                'options' => [
                    'all_admin' => __('All Admin Pages', 'htpmpro'),
                    'dashboard_only' => __('Dashboard Only', 'htpmpro'),
                    'posts_pages' => __('Posts & Pages', 'htpmpro'),
                    'media_library' => __('Media Library', 'htpmpro'),
                    'comments' => __('Comments', 'htpmpro'),
                    'appearance' => __('Appearance', 'htpmpro'),
                    'plugins' => __('Plugins', 'htpmpro'),
                    'users' => __('Users', 'htpmpro'),
                    'tools' => __('Tools', 'htpmpro'),
                    'settings' => __('Settings', 'htpmpro'),
                ],
                'pro' => [],
                'proBadge' => false
            ],
            'custom_conditions' => [
                'label' => __('Custom Page Conditions: ', 'htpmpro'),
                'description' => __("Configure conditions for WordPress admin area. E.g., use 'edit.php' for Posts page, 'post.php' for Edit Post page.", "htpmpro"),
                'options' => [
                    'admin_page_equals' => __('Admin Page Equals', 'htpmpro'),
                    'admin_page_not_equals' => __('Admin Page Not Equals', 'htpmpro'),
                    'admin_page_contains' => __('Admin Page Contains', 'htpmpro'),
                    'admin_page_not_contains' => __('Admin Page Not Contains', 'htpmpro'),
                    'screen_id_equals' => __('Screen ID Equals', 'htpmpro'),
                    'hook_name_equals' => __('Hook Name Equals', 'htpmpro'),
                ],
                'pro' => [],
                'proBadge' => false
            ]
        ];
    }

    public function get_feature_settings() {
        return [
            'status_frontend' => [
                'label' => __('Status:', 'htpmpro'),
                'type' => 'switch',
                'description' => __('Enable or disable this configuration. When disabled, settings are saved but not applied.', 'htpmpro'),
                'default' => false,
                'pro' => false,
                'enableText' => __('Enabled', 'htpmpro'),
                'disableText' => __('Disabled', 'htpmpro'),
                'proBadge' => false
            ],
            'device_types' => [
                'label' => __('Disable Plugin on: ', 'htpmpro'),
                'description' => __('Select the device(s) where this plugin should be disabled.', 'htpmpro'),
                'pro' => [],
                'options' => [
                    'all' => __('All Devices', 'htpmpro'),
                    'desktop' => __('Desktop', 'htpmpro'),
                    'tablet' => __('Tablet', 'htpmpro'),
                    'mobile' => __('Mobile', 'htpmpro'),
                    'desktop_plus_tablet' => __('Desktop + Tablet', 'htpmpro'),
                    'tablet_plus_mobile' => __('Tablet + Mobile', 'htpmpro')
                ],
                'proBadge' => false
            ],
            'action' => [
                'label' => __('Action:', 'htpmpro'),
                'description' => __('Disable on Selected Pages refers to the pages where the plugin will be disabled and enabled elsewhere.', 'htpmpro'),
                'pro' => [],
                'options' => [
                    'disable_on_selected' => __('Disable on Selected Pages', 'htpmpro'),
                    'enable_on_selected' => __('Enable on Selected Pages', 'htpmpro'),
                ],
                'proBadge' => false
            ],
            'page_types' => [
                'label' => __('Page Type:', 'htpmpro'),
                'description' => __('Choose the types of pages. "Custom" allows you to specify pages matching a particular URI pattern.', 'htpmpro'),
                'pro' => [],
                'options' => [
                    'post' => __('Posts', 'htpmpro'),
                    'page' => __('Pages', 'htpmpro'),
                    'page_post' => __('Pages & Posts', 'htpmpro'),
                    'page_post_cpt' => __('Posts, Pages & Custom Post Type', 'htpmpro'),
                    'custom' => __('Custom', 'htpmpro'),
                ],
                'toopTip' => [
                    'page_post_cpt' => [
                        'note' => __('If you wish to select custom posts, please choose the custom post types below', 'htpmpro'),
                    ]
                ],
            ],
        ];
    }

    public function get_dashboard_settings(){
        return [
            'post_typs_settings' => [
                'custom_post_types' => [
                    'label' => __('Select Post Types', 'htpmpro'),
                    'options'=>htpm_get_all_post_types(['post','page','attachment','e-floating-buttons']),
                    'isPro' => false,
                    'proBadge' => false,
                    'desc' => __('Select the custom post types where you want to disable plugins.', 'htpmpro'),
                    'type' => 'select',
                ],
                'load_posts' => [
                    'label' => __('Load Posts', 'htpmpro'),
                    'default' => 150,
                    'desc' => __('Default: 150 posts. Adjust if you have more posts to manage.', 'htpmpro'),
                    'type' => 'number',
                    'min' => 1,
                    'max' => 1000,
                    'step' => 1,
                ],
                'show_thumbnails' => [
                    'label' => __('Show Thumbnails', 'htpmpro'),
                    'default' => false,
                    'desc' => __('Default: True. Adjust if you have more posts to manage.', 'htpmpro'),
                    'type' => 'checkbox',
                    'isPro' => false,
                    'proBadge' => false,
                ],
                'items_per_page' => [
                    'label' => __('Items per Page', 'htpmpro'),
                    'default' => 10,
                    'desc' => __('Default: 10 items per page. Adjust if you have more posts to manage.', 'htpmpro'),
                    'type' => 'number',
                    'min' => 1,
                    'max' => 100,
                    'step' => 1,
                    'isPro' => false,
                    'proBadge' => false,
                ],
            ],
            'manage_plugins' => [
                'plugin_filter_options' => [
                    'label' => __('Filter Plugins', 'htpmpro'),
                    'options'=>[
                        'all' => __('All Plugins', 'htpmpro'),
                        'optimized' => __('All Optimized', 'htpmpro'),
                        'frontend_optimized' => __('Frontend Optimized', 'htpmpro'),
                        'backend_optimized' => __('Backend Optimized', 'htpmpro'),
                        'unoptimized' => __('Not Optimized Yet', 'htpmpro'),
                    ],
                    'isPro' => [],
                    'proBadge' => false,
                    'type' => 'select',
                ],
            ],
        ];
    }
    public function get_labels_texts() {
        return [
            'upgrade_to_pro' => __('Upgrade to Pro', 'htpmpro'),
            'select_pages' => __('Select Pages:', 'htpmpro'),
            'select_posts' => __('Select Posts:', 'htpmpro'),
            'page_types' => __('Page Type', 'htpmpro'),
            'select' => __('Select', 'htpmpro'),
            'uri_conditions' => __('URI Conditions:', 'htpmpro'),
            'add_condition' => __('Add Condition:', 'htpmpro'),
            'field_desc_uri' => __('E.g. You can use \'contact-us\' on URLs like https://example.com/contact-us or leave it blank for the homepage.', 'htpmpro'),
            'save_enable' => __('Save & Enable', 'htpmpro'),
            'cancel' => __('Cancel', 'htpmpro'),
            'post_types_settings' => __('Post Types Settings', 'htpmpro'),
            'display_settings' => __('Display Settings', 'htpmpro'),
            'show_thumbnails' => __('Show Plugin Thumbnails', 'htpmpro'),
            'show_thumbnails_desc' => __('Enable this option to display plugin thumbnails in the plugin list. (After enabling, you need to refresh the page to see the changes.)', 'htpmpro'),
            'items_per_page' => __('Items Per Page in Plugin List', 'htpmpro'),
            'items_per_page_desc' => __('Select how many plugins to display per page in the manage plugin list.', 'htpmpro'),
            'items' => __('items', 'htpmpro'),
            'save_settings' => __('Save Settings', 'htpmpro'),
            'select_post_types_desc' => __('Select the custom post types where you want to disable plugins.', 'htpmpro'),
            'add_post_type' => __('Add post type...', 'htpmpro'),
            'number_of_posts' => __('Number of Posts to Load', 'htpmpro'),
            'number_of_posts_desc' => __('Default: 150 posts. Adjust if you have more posts to manage.', 'htpmpro'),
            'save_settings_note' => '',
            'select_admin_pages' => __('Select Admin Pages:', 'htpmpro'),
            'backend_conditions' => __('Backend Conditions:', 'htpmpro'),
            'backendWarningNotice' => __('<strong>⚠️ Important Notice:</strong> Please carefully consider before disabling plugins in the backend. If you disable a plugin that other plugins depend on, it may cause errors or functionality issues in your WordPress admin area. Review plugin dependencies thoroughly to avoid unexpected issues.', 'htpmpro'),
            'managePluginsList' =>[
                'managePlugins' => __('Manage Plugins', 'htpmpro'),
                'serchPlaceholder'=> __('Search plugins...', 'htpmpro'),
                'noPluginFound'=> __('No Plugins Found', 'htpmpro'),
                'emptyDescription'=> __('No plugins are available at the moment', 'htpmpro'),
                'invaildSearch'=> __('Try adjusting your search or filter criteria', 'htpmpro'),
                'errorFetching'=> __('Error Fetching Plugins. Please try again', 'htpmpro'),
                'frontendOptimized'=> __('Frontend: Optimized', 'htpmpro'),
                'backendOptimized'=> __('Backend: Optimized', 'htpmpro'),
                'notOptimizedYet'=> __('Not Optimized Yet', 'htpmpro'),
                'popconfirmTitle'=> __('This plugin was optimized with specific settings. Review them before enabling to avoid potential issues', 'htpmpro'),
                'popconfirmConfirmButton'=> __('Enable Anyway', 'htpmpro'),
                'popconfirmCancelButton'=> __('Review Settings', 'htpmpro'),
            ],
            'changelog'=> [
                'title'=> __('What\'s New in Plugin Manager', 'htpmpro'),
                'version'=> __('Version', 'htpmpro'),
                'Release Date'=> __('Release Date', 'htpmpro'),
                'Changes'=> __('Changes', 'htpmpro'),
                'noChangelog'=> __('No Changelog Available', 'htpmpro'),
            ],
        ];
    }

    public function get_modal_settings_fields() {
        $feature_settings = $this->get_feature_settings();
        $backend_settings = $this->get_backend_modal_settings();
        // Merge frontend and backend settings
        return array_merge($feature_settings, $backend_settings);
    }


    public function get_modal_settings_field($field) {
        $settings = $this->get_modal_settings_fields();
        return isset($settings[$field]) ? $settings[$field] : null;
    }
    public function is_pro() {
        return $this->is_pro;
    }
    public function get_recommendations_plugins() {
        $recommendations_plugins = array();
        // Recommended Tab
        $recommendations_plugins[] = array(
            'title'  => esc_html__( 'Recommended', 'htpmpro' ),
            'active' => true,
            'plugins' => array(
                array(
                    'slug'        => 'woolentor-addons',
                    'location'    => 'woolentor_addons_elementor.php',
                    'name'        => esc_html__( 'WooLentor', 'htpmpro' ),
                    'description' => esc_html__( 'If you own a WooCommerce website, you’ll almost certainly want to use these capabilities: Woo Builder (Elementor WooCommerce Builder), WooCommerce Templates, WooCommerce Widgets,...', 'htpmpro' ),
                    'status'     => 'inactive',
                    'isLoading'  => false,
                    'icon'       => null,
                    'recommend' => is_plugin_active('woocommerce/woocommerce.php') ? true : false,

                ),
                array(
                    'slug'        => 'ht-mega-for-elementor',
                    'location'    => 'htmega_addons_elementor.php',
                    'name'        => esc_html__( 'HT Mega', 'htpmpro' ),
                    'description' => esc_html__( 'HTMega is an absolute addon for elementor that includes 80+ elements', 'htpmpro' ),
                    'status'     => 'inactive',
                    'isLoading'  => false,
                    'icon'       => null,
                    'recommend' => is_plugin_active('elementor/elementor.php') ? true : false,
                ),
                array(
                    'slug'        => 'support-genix-lite',
                    'location'    => 'support-genix-lite.php',
                    'name'        => esc_html__( 'Support Genix Lite – Support Tickets Managing System', 'htpmpro' ),
                    'description' => esc_html__( 'Support Genix is a support ticket system for WordPress and WooCommerce.', 'htpmpro' ),
                    'status'     => 'inactive',
                    'isLoading'  => false,
                    'icon'       => null
                ),
                array(
                    'slug'        => 'whols',
                    'location'    => 'whols.php',
                    'name'        => esc_html__( 'Whols – Wholesale Prices and B2B Store', 'htpmpro' ),
                    'description' => esc_html__( 'WooCommerce Wholesale plugin for B2B store management.', 'htpmpro' ),
                    'status'     => 'inactive',
                    'isLoading'  => false,
                    'icon'       => null,
                    'recommend' => is_plugin_active('woocommerce/woocommerce.php') ? true : false,
                ),
                array(
                    'slug'        => 'hashbar-wp-notification-bar',
                    'location'    => 'init.php',
                    'name'        => esc_html__( 'HashBar', 'htpmpro' ),
                    'description' => esc_html__( 'Create notification bars to notify your customers', 'htpmpro' ),
                    'status'     => 'inactive',
                    'isLoading'  => false,
                    'icon'       => null
                ),
                array(
                    'slug'        => 'pixelavo',
                    'location'    => 'pixelavo.php',
                    'name'        => esc_html__( 'Pixelavo – Facebook Pixel Conversion API', 'htpmpro' ),
                    'description' => esc_html__( 'Easy connection of Facebook pixel to your online store.', 'htpmpro' ),
                    'status'     => 'inactive',
                    'isLoading'  => false,
                    'icon'       => null
                ),
                array(
                    'slug'        => 'ht-contactform',
                    'location'    => 'contact-form-widget-elementor.php',
                    'name'        => esc_html__( 'HT Contact Form Widget For Elementor Page Builder & Gutenberg Blocks & Form Builder.', 'htpmpro' ),
                    'description' => esc_html__( 'HT Contact Form Widget For Elementor Page Builder & Gutenberg Blocks & Form Builder.', 'htpmpro' ),
                    'status'     => 'inactive',
                    'isLoading'  => false,
                    'icon'       => null
                ),
                array(
                    'slug'        => 'extensions-for-cf7',
                    'location'    => 'extensions-for-cf7.php',
                    'name'        => esc_html__( 'Extensions For CF7', 'htpmpro' ),
                    'description' => esc_html__( 'Additional features for Contact Form 7', 'htpmpro' ),
                    'status'     => 'inactive',
                    'isLoading'  => false,
                    'icon'       => null,
                    'recommend' => is_plugin_active('contact-form-7/wp-contact-form-7.php') ? true : false,
                ),
            )
        );
    
        // You May Also Like Tab
        $recommendations_plugins[] = [
            'title' => esc_html__( 'WooCommerce', 'htpmpro' ),
            'plugins' => [
                array(
                    'slug'        => 'whols',
                    'location'    => 'whols.php',
                    'name'        => esc_html__( 'Whols – Wholesale Prices and B2B Store', 'htpmpro' ),
                    'description' => esc_html__( 'WooCommerce Wholesale plugin for B2B store management.', 'htpmpro' ),
                    'status'     => 'inactive',
                    'isLoading'  => false,
                    'icon'       => null
                ),
                array(
                    'slug'        => 'woolentor-addons',
                    'location'    => 'woolentor_addons_elementor.php',
                    'name'        => esc_html__( 'WooLentor', 'htpmpro' ),
                    'description' => esc_html__( 'If you own a WooCommerce website, you’ll almost certainly want to use these capabilities: Woo Builder (Elementor WooCommerce Builder), WooCommerce Templates, WooCommerce Widgets,...', 'htpmpro' ),
                    'status'     => 'inactive',
                    'isLoading'  => false,
                    'icon'       => null
                ),
                array(
                    'slug'        => 'swatchly',
                    'location'    => 'swatchly.php',
                    'name'        => esc_html__( 'Swatchly', 'htpmpro' ),
                    'description' => esc_html__( 'Swatchly – WooCommerce Variation Swatches for Products (product attributes: Image swatch, Color swatches, Label swatches...)', 'htpmpro' ),
                    'status'     => 'inactive',
                    'isLoading'  => false,
                    'icon'       => null
                ),
                array(
                    'slug'        => 'just-tables',
                    'location'    => 'just-tables.php',
                    'name'        => esc_html__( 'JustTables – WooCommerce Product Table', 'htpmpro' ),
                    'description' => esc_html__( 'JustTables is an incredible WordPress plugin that lets you showcase all your WooCommerce products in a sortable and filterable table view. It allows your customers to easily navigate through different attributes of the products and compare them on a single page...', 'htpmpro' ),
                    'status'     => 'inactive',
                    'isLoading'  => false,
                    'icon'       => null
                ),
            ]
        ];
    
        // Others Tab
        $recommendations_plugins[] = [
            'title' => esc_html__( 'Others', 'htpmpro' ),
            'plugins' => [
                array(
                    'slug'        => 'support-genix-lite',
                    'location'    => 'support-genix-lite.php',
                    'name'        => esc_html__( 'Support Genix Lite – Support Tickets Managing System', 'htpmpro' ),
                    'description' => esc_html__( 'Support Genix is a support ticket system for WordPress and WooCommerce.', 'htpmpro' ),
                    'status'     => 'inactive',
                    'isLoading'  => false,
                    'icon'       => null
                ),
                array(
                    'slug'        => 'ht-mega-for-elementor',
                    'location'    => 'htmega_addons_elementor.php',
                    'name'        => esc_html__( 'HT Mega', 'htpmpro' ),
                    'description' => esc_html__( 'HTMega is an absolute addon for elementor that includes 80+ elements', 'htpmpro' ),
                    'status'     => 'inactive',
                    'isLoading'  => false,
                    'icon'       => null
                ),
                array(
                    'slug'        => 'pixelavo',
                    'location'    => 'pixelavo.php',
                    'name'        => esc_html__( 'Pixelavo – Facebook Pixel Conversion API', 'htpmpro' ),
                    'description' => esc_html__( 'Easy connection of Facebook pixel to your online store.', 'htpmpro' ),
                    'status'     => 'inactive',
                    'isLoading'  => false,
                    'icon'       => null
                ),
                array(
                    'slug'        => 'insert-headers-and-footers-script',
                    'location'    => 'init.php',
                    'name'        => esc_html__( 'Insert Headers and Footers Code – HT Script', 'htpmpro' ),
                    'description' => esc_html__( 'Insert Headers and Footers Code allows you to insert Google Analytics, Facebook Pixel, custom CSS, custom HTML, JavaScript code to your website header and footer without modifying your theme code', 'htpmpro' ),
                    'status'     => 'inactive',
                    'isLoading'  => false,
                    'icon'       => null
                ),
                array(
                    'slug'        => 'ht-slider-for-elementor',
                    'location'    => 'ht-slider-for-elementor.php',
                    'name'        => esc_html__( 'HT Slider For Elementor', 'htpmpro' ),
                    'description' => esc_html__( 'Create beautiful sliders for your website using Elementor', 'htpmpro' ),
                    'status'     => 'inactive',
                    'isLoading'  => false,
                    'icon'       => null
                ),
                array(
                    'slug' => 'ht-google-place-review',
                    'location' => 'ht-google-place-review.php',
                    'name' => esc_html__('Google Place Review', 'htpmpro'),
                    'link' => 'https://hasthemes.com/plugins/google-place-review-plugin-for-wordpress/',
                    'author_link' => 'https://hasthemes.com/',
                    'description' => esc_html__('Display Google Reviews on your site.', 'htpmpro'),
                    'pro' => true
                ),
            ]
        ];
    
        $recommendations_plugins[0]['plugins'] = array_values(array_filter(
            $recommendations_plugins[0]['plugins'],
            function($plugin) {
                return !isset($plugin['recommend']) || $plugin['recommend'] !== false;
            }
        ));
        return $recommendations_plugins;
    }
    
}
