<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('mobile_service_requests')) {
            Schema::create('mobile_service_requests', function (Blueprint $table) {
                $table->id();
                $table->string('service_id');
                $table->string('customer_name');
                $table->string('email');
                $table->string('mobile_no');
                $table->text('address')->nullable();
                $table->string('priority');
                $table->unsignedBigInteger('mobile_service_id');
                $table->unsignedBigInteger('device_brand');
                $table->string('mobile_model');
                $table->text('description');
                $table->text('special_requests')->nullable();
                $table->longtext('attachment')->nullable();
                $table->integer('is_approve')->nullable();
                $table->string('tracking_status');
                $table->string('tracking_status_log');
                $table->integer('is_technician_asign')->default(0);
                $table->integer('is_parts_added')->default(0);
                $table->integer('is_repair_end')->default(0);
                $table->integer('workspace_id');
                $table->integer('created_by');
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mobile_service_requests');
    }
};
