<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Rename table if old name exists
        if (Schema::hasTable('assign_technicians') && !Schema::hasTable('mobile_service_assign_technicians')) {
            Schema::rename('assign_technicians', 'mobile_service_assign_technicians');
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Rename table back
        if (Schema::hasTable('mobile_service_assign_technicians') && !Schema::hasTable('assign_technicians')) {
            Schema::rename('mobile_service_assign_technicians', 'assign_technicians');
        }
    }
};
