<?php

namespace Workdo\MobileServiceManagement\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use Workdo\LandingPage\Entities\MarketplacePageSetting;


class MarketPlaceSeederTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();
        $module = 'MobileServiceManagement';

        $data['product_main_banner']              = '';
        $data['product_main_status']              = 'on';
        $data['product_main_heading']             = 'MobileServiceManagement';
        $data['product_main_description']         = '<p>Dash SaaS presents the integration of Mobile Service Management, a solution designed to revolutionize customer service operations. This innovative integration empowers businesses to effortlessly manage customer requests, assign technicians, track mobile parts inventory, and generate bills—all from the convenience of a mobile device.</p>';
        $data['product_main_demo_link']           = '#';
        $data['product_main_demo_button_text']    = 'View Live Demo';
        $data['dedicated_theme_heading']          = '<h2>Mobile Service <b> Management </b> Integration </h2>';
        $data['dedicated_theme_description']      = '<p>Streamline customer service operations with Dash SaaS Mobile Service Management Integration, managing requests, assigning technicians, tracking parts, and generating bills—all on your mobile device.</p>';
        $data['dedicated_theme_sections']         = '[
                                                        {
                                                            "dedicated_theme_section_image": "",
                                                            "dedicated_theme_section_heading": "Efficient Customer Request Management",
                                                            "dedicated_theme_section_description": "Gone are the days of scattered customer requests. With Mobile Service Management Integration, businesses can centralize and streamline the management of customer service requests. From logging requests to prioritizing them for resolution, this integration ensures prompt and efficient service delivery.",
                                                            "dedicated_theme_section_cards": {
                                                            "1": {
                                                                "title": null,
                                                                "description": null
                                                                }
                                                            }
                                                        },
                                                        {
                                                            "dedicated_theme_section_image": "",
                                                            "dedicated_theme_section_heading": "Seamless Technician Assignment",
                                                            "dedicated_theme_section_description": "Assigning technicians to service requests becomes a breeze with Mobile Service Management Integration. Service managers can easily match technicians with tasks based on skillset, availability, and proximity to customer locations. This ensures timely response and resolution of customer issues, enhancing overall service quality.",
                                                            "dedicated_theme_section_cards": {
                                                            "1": {
                                                                "title": null,
                                                                "description": null
                                                                }
                                                            }
                                                        },
                                                        {
                                                            "dedicated_theme_section_image": "",
                                                            "dedicated_theme_section_heading": "Service Live Tracking",
                                                            "dedicated_theme_section_description": "Enhance your mobile service management with our cutting-edge Live Tracking feature. Monitor every step of the service process in real time, from request acceptance to parts integration and testing. Streamline your operations, improve efficiency, and keep clients informed with transparent, live updates. Elevate your service experience with our comprehensive tracking solution.",
                                                            "dedicated_theme_section_cards": {
                                                            "1": {
                                                                "title": null,
                                                                "description": null
                                                                }
                                                            }
                                                        },
                                                        {
                                                            "dedicated_theme_section_image": "",
                                                            "dedicated_theme_section_heading": "Automated Billing",
                                                            "dedicated_theme_section_description": "Streamlining the billing process is a key benefit of Mobile Service Management Integration. Businesses can automate the invoicing process, generating bills directly from the mobile app based on the services provided and parts used. This not only saves time but also ensures accurate billing, improving overall efficiency and customer satisfaction.",
                                                            "dedicated_theme_section_cards": {
                                                            "1": {
                                                                "title": null,
                                                                "description": null
                                                                }
                                                            }
                                                        }
                                                    ]';
        $data['dedicated_theme_sections_heading'] = '';
        $data['screenshots']                      = '[
                                                        {"screenshots":"","screenshots_heading":"MobileServiceManagement"},
                                                        {"screenshots":"","screenshots_heading":"MobileServiceManagement"},
                                                        {"screenshots":"","screenshots_heading":"MobileServiceManagement"},
                                                        {"screenshots":"","screenshots_heading":"MobileServiceManagement"},
                                                        {"screenshots":"","screenshots_heading":"MobileServiceManagement"},
                                                        {"screenshots":"","screenshots_heading":"MobileServiceManagement"},
                                                        {"screenshots":"","screenshots_heading":"MobileServiceManagement"},
                                                        {"screenshots":"","screenshots_heading":"MobileServiceManagement"},
                                                        {"screenshots":"","screenshots_heading":"MobileServiceManagement"}
                                                    ]';
        $data['addon_heading']                    = 'Why choose dedicated modulesfor Your Business?';
        $data['addon_description']                = '<p>With Dash, you can conveniently manage all your business functions from a single location.</p>';
        $data['addon_section_status']             = 'on';
        $data['whychoose_heading']                = 'Why choose dedicated modulesfor Your Business?';
        $data['whychoose_description']            = '<p>With Dash, you can conveniently manage all your business functions from a single location.</p>';
        $data['pricing_plan_heading']             = 'Empower Your Workforce with DASH';
        $data['pricing_plan_description']         = '<p>Access over Premium Add-ons for Accounting, HR, Payments, Leads, Communication, Management, and more, all in one place!</p>';
        $data['pricing_plan_demo_link']           = '#';
        $data['pricing_plan_demo_button_text']    = 'View Live Demo';
        $data['pricing_plan_text']                = '{
                                                        "1":{"title":"Pay-as-you-go"},
                                                        "2":{"title":"Unlimited installation"},
                                                        "3":{"title":"Secure cloud storage"}
                                                    }';
        $data['whychoose_sections_status']        = 'on';
        $data['dedicated_theme_section_status']   = 'on';

        foreach ($data as $key => $value) {
            if (!MarketplacePageSetting::where('name', '=', $key)->where('module', '=', $module)->exists()) {
                MarketplacePageSetting::updateOrCreate(
                    [
                        'name'   => $key,
                        'module' => $module
                    ],
                    [
                        'value' => $value
                    ]
                );
            }
        }
    }
}
