<?php

namespace Workdo\MobileServiceManagement\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\User;

class AssignTechnician extends Model
{
    use HasFactory;

    protected $table = 'mobile_service_assign_technicians';

    protected $fillable = [
        'service_id',
        'technician_id',
        'completion_date',
        'workspace_id',
        'created_by'
    ];

    public function getTechnicianDetails()
    {
        return $this->hasOne(User::class, 'id', 'technician_id');
    }
}
