<?php

namespace Workdo\MobileServiceManagement\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class MobileService extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'icon',
        'category_id',
        'expected_price',
        'expected_duration',
        'whats_included',
        'show_in_expertise',
        'show_in_footer',
        'is_active',
        'workspace',
        'created_by'
    ];

    protected $casts = [
        'whats_included'    => 'array',
        'show_in_expertise' => 'boolean',
        'show_in_footer'    => 'boolean',
        'is_active'         => 'boolean'
    ];

    public function category()
    {
        return $this->belongsTo(MobileServiceCategory::class, 'category_id');
    }
}
