<?php

namespace Workdo\MobileServiceManagement\Entities;

use App\Models\Invoice;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class MobileServiceRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'service_id',
        'customer_name',
        'mobile_no',
        'email',
        'address',
        'mobile_service_id',
        'device_brand',
        'mobile_model',
        'priority',
        'description',
        'special_requests',
        'attachment',
        'is_approve',
        'tracking_status',
        'tracking_status_log',
        'is_technician_asign',
        'is_parts_added',
        'is_repair_end',
        'workspace_id',
        'created_by'
    ];

    public function getServiceCreatedName()
    {
        return $this->hasOne(User::class, 'id', 'created_by');
    }

    public function getServiceTrackingStatus()
    {
        return $this->hasOne(MobileServiceTrackingStatus::class, 'id', 'tracking_status');
    }

    public function getAssignTechnician()
    {
        return $this->hasOne(AssignTechnician::class, 'service_id', 'service_id');
    }

    public function getInvoiceStatus()
    {
        return $this->hasOne(Invoice::class, 'user_id', 'id')->where('invoice_module', 'mobileservice')->latest();
    }

    public function service()
    {
        return $this->belongsTo(MobileService::class, 'mobile_service_id', 'id');
    }

    public function deviceBrand()
    {
        return $this->belongsTo(MobileServiceBrand::class, 'device_brand', 'id');
    }

    // public function repairParts()
    // {
    //     return $this->hasMany(MobileServiceParts::class, 'service_id', 'service_id');
    // }

    // public function payments()
    // {

    //     return $this->hasMany(MobileServiceInvoicePayment::class, 'service_id', 'service_id');
    // }

    // public function getDue()
    // {
    //     $due = 0;
    //     foreach ($this->payments as $payment) {
    //         $due += $payment->amount;
    //     }
    //     return ($this->getTotal() - $due);
    // }

    // public static function invoiceNumberFormat($number, $company_id = null, $workspace = null)
    // {
    //     if (!empty($company_id) && empty($workspace)) {
    //         $company_settings = getCompanyAllSetting($company_id);
    //     } elseif (!empty($company_id) && !empty($workspace)) {
    //         $company_settings = getCompanyAllSetting($company_id, $workspace);
    //     } else {
    //         $company_settings = getCompanyAllSetting();
    //     }
    //     $data = !empty($company_settings['repair_invoice_prefix']) ? $company_settings['repair_invoice_prefix'] : '#INVO0';
    //     return $data . sprintf("%05d", $number);
    // }

    // public static function tax($taxes)
    // {
    //     if (module_is_active('ProductService')) {
    //         $taxArr = explode(',', $taxes);
    //         $taxes  = [];
    //         foreach ($taxArr as $tax) {
    //             $taxes[] = \Workdo\ProductService\Entities\Tax::find($tax);
    //         }

    //         return $taxes;
    //     } else {
    //         return [];
    //     }
    // }

    // public static function taxRate($taxRate, $price, $quantity, $discount = 0)
    // {
    //     return ($taxRate / 100) * (($price * $quantity) - $discount);
    // }

    // public function getSubTotal()
    // {
    //     $subTotal = 0;
    //     foreach ($this->repairParts as $product) {
    //         $subTotal += ($product->price * $product->quantity);
    //     }
    //     return $subTotal;
    // }

    // public function getTotalDiscount()
    // {
    //     $totalDiscount = 0;
    //     foreach ($this->repairParts as $product) {
    //         $totalDiscount += $product->discount;
    //     }
    //     return $totalDiscount;
    // }

    // public function repairInvoice()
    // {
    //     return $this->hasOne(MobileServiceInvoice::class, 'service_id', 'service_id')->first();
    // }

    // public function getRepairCharge()
    // {
    //     $repairCharge = 0;
    //     $repairCharge = $this->repairInvoice()->repair_charge;
    //     return $repairCharge;
    // }

    // public function getTotalTax()
    // {
    //     $totalTax = 0;
    //     foreach ($this->repairParts as $product) {
    //         if (module_is_active('ProductService')) {
    //             $taxes = $this->totalTaxRate($product->tax);
    //         } else {
    //             $taxes = 0;
    //         }
    //         $totalTax += ($taxes / 100) * (($product->price * $product->quantity) - $product->discount);
    //     }
    //     return $totalTax;
    // }

    // public function getTotal()
    // {
    //     return ($this->getSubTotal() - $this->getTotalDiscount() + $this->getTotalTax() + $this->getRepairCharge());
    // }

    // public function invoiceTotalCreditNote()
    // {
    //     if (module_is_active('Account')) {
    //         return $this->hasMany(\Workdo\Account\Entities\CreditNote::class, 'invoice', 'id')->sum('amount');
    //     } else {
    //         return 0;
    //     }
    // }

    // public function invoiceTotalCustomerCreditNote()
    // {
    //     if (module_is_active('Account')) {
    //         return $this->hasMany(\Workdo\Account\Entities\CustomerCreditNotes::class, 'invoice', 'id')->sum('amount');
    //     } else {
    //         return 0;
    //     }
    // }

    // public static function totalTaxRate($taxes)
    // {
    //     if (module_is_active('ProductService')) {
    //         $taxArr  = explode(',', $taxes);
    //         $taxRate = 0;
    //         foreach ($taxArr as $tax) {
    //             $tax     = \Workdo\ProductService\Entities\Tax::find($tax);
    //             $taxRate += !empty($tax->rate) ? $tax->rate : 0;
    //         }
    //         return $taxRate;
    //     } else {
    //         return 0;
    //     }
    // }

    // public static function getAllTotalIncome($totalIncome)
    // {
    //     $amount  = 0;
    //     foreach ($totalIncome as $total) {
    //         foreach ($total->getTotalIncome as $total) {
    //             $amount += $total->amount;
    //         }
    //     }
    //     return $amount;
    // }
}
