<?php

namespace Workdo\MobileServiceManagement\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class MobileServiceReview extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'email',
        'rating',
        'review',
        'mobile_service_id',
        'service_id',
        'is_approved',
        'workspace',
        'created_by'
    ];

    public function service()
    {
        return $this->belongsTo(MobileService::class, 'mobile_service_id');
    }
}
