<?php

namespace Workdo\MobileServiceManagement\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\User;
use App\Models\WorkSpace;

class MobileServiceUtility extends Model
{
    use HasFactory;

    public static function defaultdata($company_id = null, $workspace_id = null)
    {
        // Tracking Status data
        $tracking_status = [
            [
                'icon'  => 'fas fa-inbox',
                'name'  => 'Received',
                'color' => '3498db'
            ],
            [
                'icon'  => 'fas fa-search',
                'name'  => 'Diagnosing',
                'color' => 'f1c40f'
            ],
            [
                'icon'  => 'fas fa-cog',
                'name'  => 'In Progress',
                'color' => 'e67e22'
            ],
            [
                'icon'  => 'fas fa-tools',
                'name'  => 'Awaiting Parts',
                'color' => '9b59b6'
            ],
            [
                'icon'  => 'fas fa-vial',
                'name'  => 'Testing',
                'color' => '1abc9c'
            ],
            [
                'icon'  => 'fas fa-check-circle',
                'name'  => 'Completed',
                'color' => '2ecc71'
            ],
        ];

        // Custome page Data
        $custom_pages = [
            [
                'name'           => 'Terms and Conditions',
                'title'          => 'Terms and Conditions',
                'slug'           => 'terms-and-condition',
                'contents'       => '<p>By booking our mobile service, you agree to provide accurate details and follow our service policies.</p>',
                'show_in_footer' => true
            ],
            [
                'name'           => 'Privacy Policy',
                'title'          => 'Privacy Policy',
                'description'    => 'Our privacy policy and data protection information',
                'slug'           => 'privacy-policy',
                'contents'       => '<p>Your personal data will only be used for managing service requests and will remain confidential.</p>',
                'show_in_footer' => true
            ]
        ];


        if ($company_id == Null) {
            $companys = User::where('type', 'company')->get();
            foreach ($companys as $company) {
                $WorkSpaces = WorkSpace::where('created_by', $company->id)->get();
                foreach ($WorkSpaces as $WorkSpace) {

                    foreach ($tracking_status as $status) {
                        $hasTrackingStatus = MobileServiceTrackingStatus::where('status_name', $status['name'])
                            ->where('workspace', $WorkSpace->id)
                            ->where('created_by', $company->id)
                            ->first();

                        if ($hasTrackingStatus == null) {
                            MobileServiceTrackingStatus::create([
                                'icon_name'    => $status['icon'],
                                'status_name'  => $status['name'],
                                'status_color' => $status['color'],
                                'workspace'    => $WorkSpace->id,
                                'created_by'   => $company->id,
                            ]);
                        }
                    }

                    foreach ($custom_pages as $page_data) {
                        $hasCustomPage = MobileServiceCustomPage::where('slug', $page_data['slug'])
                            ->where('workspace', $WorkSpace->id)
                            ->where('created_by', $company->id)
                            ->first();

                        if (!$hasCustomPage) {
                            MobileServiceCustomPage::create([
                                'name'           => $page_data['name'],
                                'title'          => $page_data['title'],
                                'slug'           => $page_data['slug'],
                                'contents'       => $page_data['contents'],
                                'show_in_footer' => $page_data['show_in_footer'],
                                'workspace'      => $WorkSpace->id,
                                'created_by'     => $company->id,
                            ]);
                        }
                    }
                }
            }
        } elseif ($workspace_id == Null) {
            $company    = User::where('type', 'company')->where('id', $company_id)->first();
            $WorkSpaces = WorkSpace::where('created_by', $company->id)->get();
            foreach ($WorkSpaces as $WorkSpace) {

                foreach ($tracking_status as $status) {
                    $hasTrackingStatus = MobileServiceTrackingStatus::where('status_name', $status['name'])
                        ->where('workspace', $WorkSpace->id)
                        ->where('created_by', $company->id)
                        ->first();

                    if ($hasTrackingStatus == null) {
                        MobileServiceTrackingStatus::create([
                            'icon_name'    => $status['icon'],
                            'status_name'  => $status['name'],
                            'status_color' => $status['color'],
                            'workspace'    => $WorkSpace->id,
                            'created_by'   => $company->id,
                        ]);
                    }
                }

                foreach ($custom_pages as $page_data) {
                    $hasCustomPage = MobileServiceCustomPage::where('slug', $page_data['slug'])
                        ->where('workspace', $WorkSpace->id)
                        ->where('created_by', $company->id)
                        ->first();

                    if (!$hasCustomPage) {
                        MobileServiceCustomPage::create([
                            'name'           => $page_data['name'],
                            'title'          => $page_data['title'],
                            'slug'           => $page_data['slug'],
                            'contents'       => $page_data['contents'],
                            'show_in_footer' => $page_data['show_in_footer'],
                            'workspace'      => $WorkSpace->id,
                            'created_by'     => $company->id,
                        ]);
                    }
                }
            }
        } else {
            $company   = User::where('type', 'company')->where('id', $company_id)->first();
            $WorkSpace = WorkSpace::where('created_by', $company->id)->where('id', $workspace_id)->first();

            foreach ($tracking_status as $status) {
                $hasTrackingStatus = MobileServiceTrackingStatus::where('status_name', $status['name'])
                    ->where('workspace', $WorkSpace->id)
                    ->where('created_by', $company->id)
                    ->first();

                if ($hasTrackingStatus == null) {
                    MobileServiceTrackingStatus::create([
                        'icon_name'    => $status['icon'],
                        'status_name'  => $status['name'],
                        'status_color' => $status['color'],
                        'workspace'    => $WorkSpace->id,
                        'created_by'   => $company->id,
                    ]);
                }
            }

            foreach ($custom_pages as $page) {
                $hasCustomPage = MobileServiceCustomPage::where('slug', $page['slug'])
                    ->where('workspace', $WorkSpace->id)
                    ->where('created_by', $company->id)
                    ->first();

                if (!$hasCustomPage) {
                    MobileServiceCustomPage::create([
                        'name'           => $page['name'],
                        'title'          => $page['title'],
                        'slug'           => $page['slug'],
                        'contents'       => $page['contents'],
                        'show_in_footer' => $page['show_in_footer'],
                        'workspace'      => $WorkSpace->id,
                        'created_by'     => $company->id,
                    ]);
                }
            }
        }
    }
}
