<?php

namespace Workdo\MobileServiceManagement\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;

use Workdo\MobileServiceManagement\DataTables\MobileServiceReviewDataTable;

use Workdo\MobileServiceManagement\Entities\MobileServiceReview;


class MobileServiceReviewController extends Controller
{
    public function index(MobileServiceReviewDataTable $dataTable)
    {
        if (Auth::user()->isAbleTo('mobileservice_review manage')) {
            return $dataTable->render('mobile-service-management::reviews.index');
        } else {
            return redirect()->back()->with('error', __('Permission denied.'));
        }
    }

    public function destroy($id)
    {
        if (Auth::user()->isAbleTo('mobileservice_review delete')) {
            $review = MobileServiceReview::where('id', $id)
                ->where('created_by', creatorId())
                ->where('workspace', getActiveWorkSpace())
                ->first();

            if ($review) {
                $review->delete();
                return redirect()->route('mobileservice.reviews.index')->with('success', __('The review has been deleted'));
            } else {
                return redirect()->back()->with('error', __('Review not found.'));
            }
        } else {
            return redirect()->back()->with('error', __('Permission denied.'));
        }
    }

    public function review($id)
    {
        if (Auth::user()->isAbleTo('mobileservice_review manage')) {
            $review = MobileServiceReview::where('id', $id)
                ->where('created_by', creatorId())
                ->where('workspace', getActiveWorkSpace())
                ->first();

            if ($review) {
                return view('mobile-service-management::reviews.description', compact('review'));
            } else {
                return redirect()->back()->with('error', __('Review not found.'));
            }
        } else {
            return redirect()->back()->with('error', __('Permission denied.'));
        }
    }
}
