<?php

namespace Workdo\MobileServiceManagement\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

use Workdo\ProductService\Entities\ProductService;

class PartsController extends Controller
{
    public function getPartsDetails(Request $request)
    {
        if ($request->product_id != 0) {
            $data['product']     = $product = ProductService::find($request->product_id);
            $data['unit']        = !empty($product) ? ((!empty($product->unit())) ? $product->unit()->name : '') : '';
            $data['taxRate']     = $taxRate = !empty($product) ? (!empty($product->tax_id) ? $product->taxRate($product->tax_id) : 0) : 0;
            $data['taxes']       = !empty($product) ? (!empty($product->tax_id) ? $product->tax($product->tax_id) : 0) : 0;
            $salePrice           = !empty($product) ? $product->sale_price : 0;
            $quantity            = 1;
            $taxPrice            = !empty($product) ? (($taxRate / 100) * ($salePrice * $quantity)) : 0;
            $data['totalAmount'] = !empty($product) ? ($salePrice * $quantity) : 0;
            return json_encode($data);
        }
    }
}
