<?php

namespace Workdo\MobileServiceManagement\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Routing\Router;
use Workdo\MobileServiceManagement\Providers\EventServiceProvider;
use Workdo\MobileServiceManagement\Providers\RouteServiceProvider;

class MobileServiceManagementServiceProvider extends ServiceProvider
{

    protected $moduleName = 'MobileServiceManagement';
    protected $moduleNameLower = 'mobileservicemanagement';

    public function register()
    {
        $this->app->register(RouteServiceProvider::class);
        $this->app->register(EventServiceProvider::class);
    }

    public function boot(Router $router)
    {
        $this->loadRoutesFrom(__DIR__ . '/../Routes/web.php');
        $this->loadViewsFrom(__DIR__ . '/../Resources/views', 'mobile-service-management');
        $this->loadMigrationsFrom(__DIR__ . '/../Database/Migrations');
        $this->registerTranslations();
        $router->aliasMiddleware('mobileServiceManagementSetLocale', \Workdo\MobileServiceManagement\Http\Middleware\SetLocale::class);
    }

    /**
     * Register translations.
     *
     * @return void
     */
    public function registerTranslations()
    {
        $langPath = resource_path('lang/modules/' . $this->moduleNameLower);

        if (is_dir($langPath)) {
            $this->loadTranslationsFrom($langPath, $this->moduleNameLower);
            $this->loadJsonTranslationsFrom($langPath);
        } else {
            $this->loadTranslationsFrom(__DIR__ . '/../Resources/lang', $this->moduleNameLower);
            $this->loadJsonTranslationsFrom(__DIR__ . '/../Resources/lang');
        }
    }
}
