@extends('layouts.main')

@section('page-title', __('Dashboard'))

@push('css')
    <link rel="stylesheet" href="{{ asset('packages/workdo/MobileServiceManagement/src/Resources/assets/css/dashboard/main.css') }}">
    <link rel="stylesheet" href="{{ asset('packages/workdo/MobileServiceManagement/src/Resources/assets/css/dashboard/custom.css') }}">
@endpush

@section('page-breadcrumb')
    {{ __('Mobile Service Management') }}
@endsection

@section('content')
    <div class="row row-gap mb-4">
        <div class="col-xxl-6 col-12 ">
            <div class="dashboard-card">
                <img src="{{ asset('assets/images/layer.png') }}" class="dashboard-card-layer" alt="layer">
                <div class="card-inner">
                    <div class="card-content">
                        <h2>{{ !empty($workspace) ? $workspace->name : __('WorkDo') }}</h2>
                        <p>{{ __('Easily register mobile complaints for quick issue resolution in our service portal.') }}</p>
                        <div class="btn-wrp d-flex gap-3">
                            <a href="#" class="btn btn-primary d-flex align-items-center gap-1 text-sm cp_link" tabindex="0"
                                data-link="{{ route('mobileservice.frontend.index', ['workspaceSlug' => $workspace->slug]) }}"
                                data-bs-whatever="{{ __('Service Request Link') }}" data-bs-toggle="tooltip"
                                data-bs-original-title="{{ __('Public Service Portal') }}"
                                title="{{ __('Click to copy link') }}">
                                <i class="ti ti-link text-white"></i><span>{{ __('Public Portal') }}</span>
                            </a>
                        </div>
                    </div>
                    <div class="card-icon  d-flex align-items-center justify-content-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="118" height="118" viewBox="0 0 118 118" fill="none">
                            <g clip-path="url(#clip0_554_167)">
                                <path opacity="0.6" d="M117.226 20.7611C117.223 20.7355 117.21 20.7119 117.191 20.6949C117.172 20.6779 117.147 20.6686 117.121 20.6689C117.107 20.6689 117.094 20.6717 117.081 20.677C117.068 20.6823 117.057 20.6902 117.047 20.7L109.556 28.1907C109.546 28.2004 109.534 28.2082 109.521 28.2134C109.509 28.2187 109.495 28.2214 109.481 28.2214C109.476 28.2217 109.471 28.2217 109.467 28.2214L100.558 26.9648C100.536 26.9616 100.515 26.9512 100.499 26.935C100.483 26.9189 100.472 26.898 100.469 26.8754L99.2121 17.966C99.2098 17.9498 99.2113 17.9334 99.2165 17.918C99.2217 17.9025 99.2303 17.8885 99.2418 17.877L106.734 10.3851C106.748 10.3712 106.757 10.3535 106.762 10.3343C106.766 10.315 106.765 10.2949 106.759 10.2762C106.752 10.2575 106.741 10.241 106.725 10.2287C106.71 10.2163 106.691 10.2086 106.671 10.2063L99.9484 9.43331C99.9327 9.4315 99.9168 9.43325 99.9018 9.43844C99.8869 9.44363 99.8733 9.45211 99.862 9.46327L91.2079 18.1176C91.1978 18.1277 91.1898 18.1398 91.1845 18.1531C91.1791 18.1664 91.1766 18.1807 91.177 18.195L91.419 26.2114C91.4195 26.2258 91.417 26.24 91.4117 26.2533C91.4064 26.2666 91.3985 26.2787 91.3884 26.2889L55.3313 62.3457C55.3216 62.3555 55.31 62.3633 55.2973 62.3686C55.2846 62.3739 55.2709 62.3766 55.2571 62.3766H55.2539L47.2377 62.1346H47.2345C47.2067 62.1346 47.18 62.1456 47.1603 62.1652L38.5059 70.8196C38.4948 70.8308 38.4862 70.8443 38.481 70.8592C38.4758 70.8742 38.474 70.8901 38.4758 70.9058L39.2487 77.6288C39.2517 77.6545 39.2641 77.6783 39.2834 77.6955C39.3028 77.7128 39.3279 77.7222 39.3538 77.7221C39.3676 77.7221 39.3812 77.7193 39.3938 77.714C39.4065 77.7086 39.418 77.7008 39.4276 77.691L46.9192 70.1994C46.9389 70.1798 46.9656 70.1688 46.9934 70.1687C46.9983 70.1684 47.0033 70.1684 47.0082 70.1687L55.9165 71.4255C55.9391 71.4286 55.96 71.439 55.9762 71.4551C55.9923 71.4712 56.0027 71.4921 56.0059 71.5147L57.2626 80.4232C57.2649 80.4393 57.2634 80.4557 57.2582 80.4711C57.2531 80.4865 57.2444 80.5005 57.2329 80.5119L49.7411 88.0038C49.7271 88.0178 49.7174 88.0355 49.7131 88.0547C49.7087 88.074 49.7098 88.0941 49.7163 88.1128C49.7229 88.1314 49.7345 88.1478 49.7499 88.1602C49.7653 88.1726 49.7839 88.1803 49.8035 88.1826L56.5265 88.9559H56.5383C56.5662 88.9558 56.593 88.9447 56.6127 88.925L65.267 80.2709C65.2772 80.2607 65.2851 80.2486 65.2904 80.2352C65.2957 80.2219 65.2982 80.2076 65.2977 80.1932L65.0557 72.177C65.0553 72.1627 65.0578 72.1484 65.0631 72.1351C65.0684 72.1217 65.0763 72.1096 65.0864 72.0994L101.144 36.0453C101.163 36.0256 101.19 36.0145 101.218 36.0144H101.221L109.237 36.2566H109.24C109.268 36.2566 109.295 36.2455 109.315 36.2258L117.969 27.5717C117.98 27.5605 117.989 27.5469 117.994 27.5319C117.999 27.5169 118.001 27.501 117.999 27.4852L117.226 20.7611ZM91.1028 38.9372L67.9799 62.0604C67.6341 62.4062 67.1651 62.6005 66.676 62.6005C66.187 62.6005 65.718 62.4062 65.3721 62.0604C65.0263 61.7146 64.8321 61.2456 64.8321 60.7565C64.8321 60.2675 65.0263 59.7984 65.3721 59.4526L88.4953 36.3297C88.8411 35.9839 89.3101 35.7897 89.7991 35.7897C90.2881 35.7897 90.757 35.9839 91.1028 36.3297C91.4486 36.6755 91.6429 37.1445 91.6429 37.6335C91.6429 38.1225 91.4486 38.5914 91.1028 38.9372Z" fill="#18BF6B"/>
                                <path opacity="0.6" d="M34.0633 48.2255C33.9589 48.1314 33.8786 48.0135 33.8294 47.8819C33.7801 47.7502 33.7633 47.6087 33.7803 47.4691C33.9284 46.2521 33.9284 45.0217 33.7803 43.8047C33.7633 43.6651 33.7801 43.5235 33.8294 43.3919C33.8786 43.2602 33.9589 43.1424 34.0633 43.0483L37.3723 40.0607C37.5006 39.945 37.5919 39.7942 37.6351 39.627C37.6782 39.4598 37.6712 39.2836 37.615 39.1204C37.3603 38.3847 37.0624 37.6647 36.7229 36.9641C36.6507 36.8156 36.5381 36.6903 36.3981 36.6027C36.258 36.5151 36.0962 36.4686 35.931 36.4686C35.916 36.4686 35.901 36.4686 35.8849 36.4686L31.4339 36.6959C31.4186 36.6959 31.4037 36.6959 31.3878 36.6959C31.2548 36.6959 31.1236 36.6657 31.004 36.6076C30.8845 36.5494 30.7797 36.4647 30.6977 36.3601C29.9408 35.3942 29.0699 34.5233 28.104 33.7664C27.9934 33.6797 27.9052 33.5677 27.847 33.4398C27.7887 33.3118 27.7621 33.1718 27.7694 33.0314L27.9966 28.5801C28.0055 28.4075 27.9633 28.2361 27.8754 28.0872C27.7875 27.9384 27.6578 27.8187 27.5023 27.7431C26.8017 27.4035 26.0817 27.1056 25.346 26.8509C25.1828 26.7945 25.0066 26.7875 24.8394 26.8307C24.6722 26.8739 24.5214 26.9654 24.4059 27.0938L21.4211 30.4045C21.339 30.4956 21.2386 30.5684 21.1266 30.6182C21.0145 30.6681 20.8932 30.6938 20.7705 30.6938C20.7351 30.6937 20.6997 30.6917 20.6645 30.6875C19.4475 30.5392 18.217 30.5392 17.0001 30.6875C16.9649 30.6917 16.9295 30.6937 16.894 30.6938C16.7714 30.6938 16.6501 30.6681 16.538 30.6182C16.4259 30.5684 16.3256 30.4956 16.2434 30.4045L13.2554 27.0954C13.1399 26.967 12.9892 26.8755 12.822 26.8323C12.6548 26.7891 12.4785 26.7961 12.3153 26.8525C11.5796 27.1072 10.8595 27.4051 10.1588 27.7447C10.0033 27.8202 9.87357 27.9399 9.78569 28.0888C9.69782 28.2377 9.65574 28.4091 9.6647 28.5817L9.89194 33.033C9.89924 33.1734 9.87264 33.3134 9.81439 33.4414C9.75615 33.5693 9.66797 33.6813 9.5573 33.768C8.59142 34.525 7.72047 35.3959 6.96338 36.3617C6.88142 36.4663 6.77672 36.5509 6.65721 36.6091C6.53769 36.6673 6.40651 36.6975 6.27358 36.6975C6.2586 36.6975 6.24362 36.6975 6.22749 36.6975L1.77622 36.4702C1.76124 36.4702 1.74626 36.4702 1.73012 36.4702C1.56494 36.4702 1.40307 36.5167 1.26304 36.6043C1.12301 36.6919 1.01045 36.8172 0.938233 36.9657C0.598503 37.6662 0.300599 38.3862 0.0460886 39.122C-0.0101897 39.2853 -0.017188 39.4615 0.0259656 39.6287C0.0691191 39.7959 0.160517 39.9467 0.288772 40.0623L3.59992 43.0476C3.70433 43.1417 3.78456 43.2595 3.83382 43.3912C3.88308 43.5229 3.89992 43.6644 3.88293 43.804C3.73457 45.021 3.73457 46.2514 3.88293 47.4684C3.89992 47.608 3.88308 47.7495 3.83382 47.8812C3.78456 48.0128 3.70433 48.1307 3.59992 48.2248L0.290846 51.2131C0.162591 51.3287 0.0711934 51.4795 0.0280398 51.6467C-0.0151138 51.8139 -0.00811548 51.9901 0.0481628 52.1534C0.302673 52.8891 0.600577 53.6092 0.940307 54.3097C1.01252 54.4582 1.12508 54.5835 1.26511 54.6711C1.40515 54.7587 1.56701 54.8052 1.7322 54.8052H1.77829L6.22957 54.5777H6.27566C6.40858 54.5776 6.53977 54.6079 6.65928 54.666C6.77879 54.7242 6.8835 54.8088 6.96545 54.9135C7.72271 55.8792 8.59363 56.75 9.55938 57.5072C9.67004 57.5938 9.75822 57.7059 9.81647 57.8338C9.87471 57.9617 9.90131 58.1018 9.89402 58.2421L9.66678 62.6934C9.65781 62.8661 9.69989 63.0375 9.78777 63.1864C9.87564 63.3352 10.0054 63.4549 10.1609 63.5305C10.8615 63.87 11.5816 64.1679 12.3174 64.4224C12.4095 64.4543 12.5062 64.4706 12.6036 64.4706C12.7269 64.4705 12.8488 64.4446 12.9614 64.3945C13.0741 64.3444 13.1749 64.2712 13.2575 64.1797L16.245 60.8706C16.3267 60.7794 16.4266 60.7064 16.5383 60.6561C16.65 60.6059 16.7709 60.5797 16.8934 60.5791C16.9288 60.5792 16.9642 60.5813 16.9994 60.5856C18.2163 60.7339 19.4468 60.7339 20.6638 60.5856C20.699 60.5813 20.7344 60.5792 20.7698 60.5791C20.8925 60.5791 21.0138 60.6049 21.1259 60.6547C21.238 60.7046 21.3383 60.7774 21.4205 60.8686L24.408 64.1776C24.5235 64.306 24.6743 64.3974 24.8415 64.4406C25.0087 64.4838 25.1849 64.4767 25.3481 64.4203C26.0838 64.1658 26.8038 63.868 27.5044 63.5284C27.6598 63.4528 27.7896 63.3331 27.8775 63.1843C27.9654 63.0354 28.0076 62.864 27.9987 62.6913L27.7715 58.2398C27.7642 58.0995 27.7908 57.9594 27.849 57.8315C27.9073 57.7036 27.9955 57.5915 28.1061 57.5049C29.0719 56.7478 29.9427 55.8769 30.6998 54.9112C30.7818 54.8065 30.8865 54.7219 31.0061 54.6637C31.1256 54.6055 31.2569 54.5753 31.3898 54.5754H31.4359L35.887 54.8029H35.9331C36.0983 54.8029 36.2601 54.7564 36.4002 54.6688C36.5402 54.5812 36.6527 54.4559 36.725 54.3074C37.0645 53.6068 37.3624 52.8868 37.6171 52.1511C37.6733 51.9878 37.6803 51.8116 37.6371 51.6444C37.594 51.4773 37.5026 51.3264 37.3744 51.2108L34.0633 48.2255ZM26.9139 53.7194C25.3152 55.3182 23.2784 56.407 21.0609 56.8481C18.8435 57.2892 16.545 57.0629 14.4562 56.1977C12.3673 55.3325 10.582 53.8673 9.32587 51.9875C8.06976 50.1076 7.39931 47.8975 7.39931 45.6365C7.39931 43.3756 8.06976 41.1655 9.32587 39.2856C10.582 37.4057 12.3673 35.9406 14.4562 35.0754C16.545 34.2102 18.8435 33.9839 21.0609 34.425C23.2784 34.8661 25.3152 35.9549 26.9139 37.5537C27.9797 38.6127 28.8255 39.872 29.4027 41.2592C29.9799 42.6463 30.2771 44.1339 30.2771 45.6364C30.2772 47.1388 29.9802 48.6264 29.4032 50.0137C28.8261 51.4009 27.9805 52.6603 26.9148 53.7194H26.9139Z" fill="#18BF6B"/>
                                <path opacity="0.6" d="M18.8321 37.8965C17.0415 37.8976 15.3067 38.5196 13.9232 39.6564C12.5398 40.7932 11.5933 42.3745 11.245 44.1309C10.8967 45.8873 11.1682 47.7101 12.0132 49.2888C12.8582 50.8675 14.2244 52.1043 15.8791 52.7886C17.5338 53.473 19.3745 53.5624 21.0877 53.0417C22.8009 52.521 24.2806 51.4224 25.2747 49.933C26.2687 48.4437 26.7156 46.6558 26.5392 44.8739C26.3628 43.092 25.5741 41.4264 24.3073 40.1609C23.5888 39.4414 22.7352 38.871 21.7956 38.4824C20.856 38.0938 19.8489 37.8947 18.8321 37.8965Z" fill="#18BF6B"/>
                                <path d="M44.5529 59.5579C44.9043 59.2046 45.3222 58.9245 45.7825 58.7339C46.2428 58.5432 46.7364 58.4457 47.2347 58.447H47.3038L47.3589 58.4489L53.8185 58.6441L79.8626 32.6011V12.7859C79.8626 10.5417 78.9711 8.38945 77.3842 6.80258C75.7973 5.21571 73.6451 4.32422 71.4009 4.32422H29.4729C27.2287 4.32422 25.0765 5.21571 23.4896 6.80258C21.9027 8.38945 21.0112 10.5417 21.0112 12.7859V25.3556L21.6713 24.6246C22.0999 24.1503 22.6231 23.771 23.2072 23.5113C23.7913 23.2516 24.4234 23.1171 25.0626 23.1166C25.5705 23.1166 26.0748 23.2014 26.5547 23.3676C27.4275 23.67 28.2817 24.0236 29.1129 24.4264C29.921 24.8171 30.5958 25.4376 31.0527 26.2103C31.5096 26.9829 31.7283 27.8732 31.6812 28.7696L31.5245 31.8378C31.7166 32.0144 31.9046 32.1947 32.0885 32.3787C32.2724 32.5628 32.4528 32.7509 32.6296 32.9429L35.6974 32.7862C35.7755 32.782 35.8534 32.7802 35.9313 32.7802C36.7883 32.7832 37.6274 33.0258 38.3536 33.4808C39.0799 33.9357 39.6644 34.5848 40.041 35.3545C40.4439 36.1857 40.7974 37.04 41.0998 37.9127C41.3939 38.76 41.4317 39.6753 41.2082 40.5439C40.9847 41.4125 40.51 42.196 39.8435 42.7961L37.5619 44.8551C37.5832 45.3754 37.5832 45.8957 37.5619 46.4161L39.8435 48.4751C40.51 49.0753 40.9847 49.8587 41.2082 50.7273C41.4317 51.596 41.3939 52.5112 41.0998 53.3585C40.7974 54.2313 40.4438 55.0855 40.041 55.9167C39.6643 56.6865 39.0798 57.3356 38.3535 57.7905C37.6272 58.2454 36.7881 58.4881 35.9311 58.4911C35.8534 58.4911 35.7755 58.489 35.6979 58.4851L32.6296 58.3284C32.4531 58.5204 32.2727 58.7084 32.0885 58.8923C31.9043 59.0762 31.7163 59.2565 31.5245 59.4332L31.6812 62.5017C31.7281 63.3981 31.5094 64.2884 31.0525 65.0611C30.5956 65.8337 29.9208 66.4543 29.1127 66.8451C28.2814 67.2477 27.4272 67.6012 26.5545 67.9036C25.7071 68.1967 24.7923 68.2338 23.924 68.0103C23.0557 67.7869 22.2724 67.3128 21.6718 66.6471L21.0115 65.9156V105.214C21.0115 106.326 21.2303 107.426 21.6556 108.453C22.0808 109.479 22.7041 110.412 23.4898 111.198C24.2756 111.983 25.2084 112.607 26.235 113.032C27.2616 113.457 28.3619 113.676 29.4731 113.676H71.4007C72.5119 113.676 73.6122 113.457 74.6388 113.032C75.6654 112.607 76.5982 111.983 77.384 111.198C78.1697 110.412 78.793 109.479 79.2182 108.453C79.6435 107.426 79.8623 106.326 79.8623 105.214V62.5409L68.7886 73.6144L68.984 80.0848C68.9985 80.6017 68.9077 81.116 68.717 81.5966C68.5262 82.0772 68.2397 82.5139 67.8747 82.8802L59.2232 91.5318C58.8717 91.8858 58.4534 92.1665 57.9926 92.3577C57.5318 92.5488 57.0376 92.6465 56.5387 92.6451C56.398 92.6452 56.2574 92.6375 56.1176 92.6221H56.1116H56.1056L49.3787 91.8486C48.6707 91.7664 48.0001 91.4863 47.444 91.0404C46.8878 90.5946 46.4685 90.001 46.2342 89.3278C45.9999 88.6546 45.9601 87.929 46.1193 87.2342C46.2784 86.5394 46.6302 85.9035 47.1342 85.3994L53.3621 79.1713L52.7313 74.7013L48.2628 74.0708L42.0376 80.2976C41.5335 80.8023 40.8972 81.1546 40.2019 81.314C39.5066 81.4734 38.7804 81.4335 38.1067 81.1988C37.4331 80.9641 36.8393 80.5442 36.3935 79.9873C35.9478 79.4303 35.6682 78.759 35.5868 78.0503L34.8129 71.3302C34.7458 70.7623 34.8087 70.1865 34.9968 69.6464C35.1849 69.1062 35.4932 68.6159 35.8986 68.2125L44.5529 59.5579ZM39.5485 14.4538C39.0595 14.4538 38.5906 14.2595 38.2448 13.9138C37.899 13.568 37.7048 13.099 37.7048 12.61C37.7048 12.121 37.899 11.6521 38.2448 11.3063C38.5906 10.9605 39.0595 10.7663 39.5485 10.7663H61.3253C61.8143 10.7663 62.2832 10.9605 62.629 11.3063C62.9748 11.6521 63.169 12.121 63.169 12.61C63.169 13.099 62.9748 13.568 62.629 13.9138C62.2832 14.2595 61.8143 14.4538 61.3253 14.4538H39.5485ZM47.7931 104.498H53.0803C53.5693 104.498 54.0382 104.692 54.384 105.038C54.7298 105.384 54.924 105.853 54.924 106.342C54.924 106.831 54.7298 107.3 54.384 107.645C54.0382 107.991 53.5693 108.185 53.0803 108.185H47.7931C47.3041 108.185 46.8351 107.991 46.4894 107.645C46.1436 107.3 45.9493 106.831 45.9493 106.342C45.9493 105.853 46.1436 105.384 46.4894 105.038C46.8351 104.692 47.3041 104.498 47.7931 104.498Z" fill="#0CAF60"/>
                            </g>
                            <defs>
                                <clipPath id="clip0_554_167">
                                    <rect width="118" height="118" fill="white" />
                                </clipPath>
                            </defs>
                        </svg>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-6 col-12">
            <div class="row d-flex dashboard-wrp">
                <div class="col-md-6 col-sm-6 col-12 d-flex flex-wrap">
                    <div class="dashboard-project-card">
                        <div class="card-inner  d-flex justify-content-between">
                            <div class="card-content">
                                <div class="theme-avtar bg-white">
                                    <i class="ti ti-clock text-danger"></i>
                                </div>
                                <a href="{{ route('mobileservice.pending-request.index') }}">
                                    <h3 class="mt-3 mb-0 text-danger">{{ __('Pending Request') }}</h3>
                                </a>
                            </div>
                            <h3 class="mb-0">{{ $pendingRequest }}</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-sm-6 col-12 d-flex flex-wrap">
                    <div class="dashboard-project-card">
                        <div class="card-inner  d-flex justify-content-between">
                            <div class="card-content">
                                <div class="theme-avtar bg-white">
                                    <i class="ti ti-git-pull-request"></i>
                                </div>
                                <a href="{{ route('mobileservice.service-request.index') }}"><h3 class="mt-3 mb-0">{{ __('Total Request') }}</h3></a>
                            </div>
                            <h3 class="mb-0">{{ $allRequest }}</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-sm-6 col-12 d-flex flex-wrap">
                    <div class="dashboard-project-card">
                        <div class="card-inner  d-flex justify-content-between">
                            <div class="card-content">
                                <div class="theme-avtar bg-white">
                                    <i class="ti ti-checks"></i>
                                </div>
                                <h3 class="mt-3 mb-0">{{ __('Total Completed') }}</h3>
                            </div>
                            <h3 class="mb-0">{{ $totalCompletedRequest }}</h3>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-sm-6 col-12 d-flex flex-wrap">
                    <div class="dashboard-project-card">
                        <div class="card-inner  d-flex justify-content-between">
                            <div class="card-content">
                                <div class="theme-avtar bg-white">
                                    <i class="ti ti-currency-dollar "></i>
                                </div>
                                <h3 class="mt-3 mb-0">{{ __('Total Income') }}</h3>
                            </div>
                            <h3 class="mb-0">{{ currency_format_with_sym($totalIncome) }}</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>{{ __('Recently approve request') }}</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive custom-scrollbar h-600">
                                <table class="table mb-0" id="assets">
                                    <thead>
                                        <tr>
                                            <th>{{ __('Service ID') }}</th>
                                            <th>{{ __('Customer Name') }}</th>
                                            <th>{{ __('Priority') }}</th>
                                            <th>{{ __('Tracking Status') }}</th>
                                            <th>{{ __('Technician') }}</th>
                                            <th>{{ __('Payment Status') }}</th>
                                            <th>{{ __('Created By') }}</th>
                                            <th>{{ __('Created') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse ($recentRequests as $recentRequest)
                                            <tr>
                                                <td><a class="btn btn-outline-primary"  href="{{ \Laratrust::hasPermission('mobileservice_servicerequest show') ? route('mobileservice.service-request.show', ['serviceId' => encrypt($recentRequest->service_id)]) : '#' }}">{{ $recentRequest->service_id }}</a></td>
                                                <td>{{ $recentRequest->customer_name }}</td>
                                                <td>
                                                    @php
                                                        if ($recentRequest->priority == 'priority') {
                                                            $priorityClass = "bg-warning";
                                                        } elseif ($recentRequest->priority == 'emergency') {
                                                            $priorityClass = "bg-danger";
                                                        } else {
                                                            $priorityClass = "bg-secondary";
                                                        }
                                                    @endphp
                                                    <span class="badge fix_badge {{ $priorityClass }} p-2 px-3">{{ __(ucfirst($recentRequest->priority)) }}</span>
                                                </td>
                                                <td>
                                                    @php
                                                        $statusColor = isset($data->getServiceTrackingStatus->status_color) ? '#' . $data->getServiceTrackingStatus->status_color : '#ffc107';
                                                        $statusName = isset($data->getServiceTrackingStatus->status_name) ? $data->getServiceTrackingStatus->status_name : 'pending';
                                                    @endphp
                                                    <span class="badge fix_badge p-2 px-3" style="background-color: {{ $statusColor }}; color: white;">{{ $statusName }}</span>
                                                </td>
                                                <td>
                                                    @php
                                                        if (!is_null($recentRequest->getAssignTechnician) && !is_null($recentRequest->getAssignTechnician->getTechnicianDetails) && !is_null($recentRequest->getAssignTechnician->getTechnicianDetails->name)) {
                                                            $class = 'bg-success';
                                                            $label = $recentRequest->getAssignTechnician->getTechnicianDetails->name;
                                                        } else {
                                                            $class = 'bg-warning';
                                                            $label = __('Not Assigned');
                                                        }
                                                    @endphp
                                                    <span class="badge fix_badge {{ $class }} p-2 px-3">{{ $label }}</span>
                                                </td>
                                                <td>
                                                    @php
                                                        if (isset($recentRequest->getInvoiceStatus->status)) {
                                                            if ($recentRequest->getInvoiceStatus->status == 0) {
                                                                $paymentclass = 'bg-info';
                                                            } elseif ($recentRequest->getInvoiceStatus->status == 1) {
                                                                $paymentclass = 'bg-primary';
                                                            } elseif ($recentRequest->getInvoiceStatus->status == 2) {
                                                                $paymentclass = 'bg-secondary';
                                                            } elseif ($recentRequest->getInvoiceStatus->status == 3) {
                                                                $paymentclass = 'bg-warning';
                                                            } elseif ($recentRequest->getInvoiceStatus->status == 4) {
                                                                $paymentclass = 'bg-success';
                                                            }
                                                            $paymentStatus = Invoice::$statues[$recentRequest->getInvoiceStatus->status];
                                                        } else {
                                                            $paymentclass         = 'bg-dark';
                                                            $paymentStatus =  __('No Invoice');
                                                        }
                                                    @endphp
                                                    <span class="badge fix_badge {{ $paymentclass }}  p-2 px-3">{{ $paymentStatus }}</span>
                                                </td>
                                                <td><span class="white-space text-primary">{{ $recentRequest->getServiceCreatedName->name }}</span></td>
                                                <td><span data-bs-toggle="tooltip" title="{{ $recentRequest->created_at->diffForHumans() }}" data-title="{{ $recentRequest->created_at->diffForHumans() }}">{{ company_date_formate($recentRequest->created_at) }}</span></td>
                                            </tr>
                                        @empty
                                            @include('layouts.nodatafound')
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $('.cp_link').on('click', function() {
            var value = $(this).attr('data-link');
            var $temp = $("<input>");
            $("body").append($temp);
            $temp.val(value).select();
            document.execCommand("copy");
            $temp.remove();
            toastrs('Success', '{{ __('Link Copy on Clipboard') }}', 'success')
        });
    </script>
@endpush
