@extends('mobile-service-management::frontend.layout')

@section('title',  __('About'))

@section('content')

    @include('mobile-service-management::frontend.partials.page-header', [
        'badge' => __('About'),
        'title' => __('About Us'),
        'breadcrumbs' => [__('About')],
    ])

    @php
        // Story Section
        $hasStory = (($settings['is_story_section_active'] ?? 'off') == 'on' && !empty($settings['story_title']) && !empty($settings['story_description']) && !empty($settings['story_image']) && check_file($settings['story_image']));

        // Mission Section
        $missionItems = json_decode($settings['mission_items'] ?? '[]', true);
        $hasValidMissionItems = array_filter($missionItems, function ($item) {
            return !empty($item['title']) && !empty($item['icon']);
        });
        $hasMission = (($settings['is_mission_section_active'] ?? 'off') == 'on' && !empty($settings['mission_title']) && !empty($settings['mission_description']) && !empty($hasValidMissionItems));

        // Team Section
        $teamMembers = json_decode($settings['team_members'] ?? '[]', true);
        $hasValidTeamMembers = array_filter($teamMembers, function ($member) {
            return !empty($member['user_id']) && $member['user_id'] !== null && $member['user_id'] !== '';
        });
        $hasTeam = ($settings['is_team_section_active'] ?? 'off') == 'on' && !empty($settings['team_title']) && !empty($settings['team_description']) && !empty($hasValidTeamMembers);

        // CTA Section
        $hasCTA = (($settings['is_about_cta_section_active'] ?? 'off') == 'on' && !empty($settings['about_cta_title']) && !empty($settings['about_cta_description']));

        // All Section
        $hasAnyAboutSection = $hasStory || $hasMission || $hasTeam || $hasCTA;
    @endphp

    @if ($hasAnyAboutSection)
        <!-- Our Story Section -->
        @if ($hasStory)
            <section id="our-story" class="py-10 lg:py-16 bg-white">
                <div class="md:container mx-auto px-4 w-full">
                    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 md:gap-10 lg:gap-12 items-center">
                        <div class="order-2 lg:order-1">
                            <div class="relative">
                                <div class="bg-tertiary p-3 md:p-4 rounded-2xl shadow-xl">
                                    <img src="{{ get_file($settings['story_image']) }}" alt="{{ __('Our team at work') }}"
                                        class="w-full h-auto rounded-lg object-cover shadow-md">
                                </div>
                            </div>
                        </div>

                        <div class="order-1 lg:order-2">
                            <span class="text-primary font-medium mb-2 block">{{ __('OUR STORY') }}</span>
                            <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-secondary title-font mb-4">{{ $settings['story_title'] }}</h2>
                            <div class="space-y-4 text-gray-600"><p>{!! $settings['story_description'] !!}</p></div>
                        </div>
                    </div>
                </div>
            </section>
        @endif

        <!-- Mission & Values -->
        @if ($hasMission)
            <section class="py-10 lg:py-16 bg-tertiary">
                <div class="md:container mx-auto px-4 w-full">
                    <div class="text-center mb-6 md:mb-10">
                        <span class="inline-flex items-center bg-white text-secondary px-4 py-1.5 rounded-full text-xs uppercase tracking-wider font-semibold mb-4 shadow-sm border border-gray-200 mx-auto">
                            <i class="fas fa-circle text-primary text-xxs me-2"></i>
                            {{ __('Our Mission') }}
                        </span>
                        <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-secondary title-font mb-4">{{ $settings['mission_title'] }}</h2>
                        <p class="lg:text-lg text-gray-600 max-w-3xl mx-auto">{{ $settings['mission_description'] }}</p>
                    </div>

                    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6 lg:gap-8">
                        @foreach ($hasValidMissionItems as $item)
                            <div class="bg-white p-4 lg:p-6 rounded-lg">
                                <div class="w-12 h-12 lg:w-16 lg:h-16 rounded-full bg-tertiary flex items-center justify-center mb-4">
                                    <i class="{{ $item['icon'] }} text-primary text-lg lg:text-2xl"></i>
                                </div>
                                <h3 class="text-xl font-bold text-secondary mb-3">{{ $item['title'] }}</h3>
                                <p class="text-gray-600 line-clamp-3">{{ $item['description'] ?? '' }}</p>
                            </div>
                        @endforeach
                    </div>
                </div>
            </section>
        @endif

        <!-- Team Section -->
        @if ($hasTeam)
            <section class="py-10 lg:py-16 bg-white">
                <div class="md:container mx-auto px-4 w-full">
                    <div class="text-center mb-6 md:mb-10">
                        <span class="inline-flex items-center bg-white text-secondary px-4 py-1.5 rounded-full text-xs uppercase tracking-wider font-semibold mb-4 shadow-sm border border-gray-200 mx-auto">
                            <i class="fas fa-circle text-primary text-xxs me-2"></i>
                            {{ __('Our Team') }}
                        </span>
                        <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-secondary title-font mb-4">{{ $settings['team_title'] }}</h2>
                        <p class="lg:text-lg text-gray-600 max-w-3xl mx-auto">{{ $settings['team_description'] }}</p>
                    </div>

                    <div class="{{ count($hasValidTeamMembers) > 2 ? 'team-slider swiper' : '' }}">
                        <div class="{{ count($hasValidTeamMembers) > 2 ? 'swiper-wrapper' : 'grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6 lg:gap-8' }}">
                            @foreach ($hasValidTeamMembers as $member)
                                @php
                                    $user = \App\Models\User::find($member['user_id']);
                                @endphp
                                <div class="swiper-slide p-1 h-auto">
                                    <div class="h-full team-card bg-white rounded-lg overflow-hidden border border-gray-200">
                                        <div class="relative">
                                            <img src="{{ check_file($user->avatar) ? get_file($user->avatar) : get_file('uploads/users-avatar/avatar.png') }}"
                                                alt="user-image" class="w-full h-64 object-cover">
                                            @if (isset($member['experience']))
                                                <div class="absolute top-4 end-4 bg-primary text-white text-xs font-bold px-3 py-1 rounded-full">
                                                    {{ $member['experience'] }}</div>
                                            @endif
                                        </div>
                                        <div class="card-content p-4 transition-transform duration-300">
                                            @if ($user)
                                                <h3 class="text-xl font-bold text-gray-900 mb-2">{{ $user->name }}</h3>
                                            @endif
                                            @if (isset($member['position']))
                                                <p class="text-primary font-medium mb-2">{{ $member['position'] }}</p>
                                            @endif
                                            @if (isset($member['description']))
                                                <p class="text-gray-600 text-sm">{{ $member['description'] }}</p>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        @if(count($hasValidTeamMembers) > 2)
                            <div class="swiper-button-prev"></div>
                            <div class="swiper-button-next"></div>
                        @endif
                    </div>
                </div>
            </section>
        @endif

        <!-- CTA Section -->
        @if ($hasCTA)
            <section class="pb-10 lg:pb-16 bg-white text-white relative overflow-hidden">
                <div class="md:container mx-auto px-4 w-full">
                    <div class="text-white bg-primary rounded-2xl p-4 md:p-8 lg:p-10 text-center relative overflow-hidden">
                        <div class="absolute -top-10 -end-10 w-32 h-32 rounded-full bg-white bg-opacity-10"></div>
                        <div class="absolute -bottom-10 -start-10 w-40 h-40 rounded-full bg-white bg-opacity-10"></div>

                        <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold title-font mb-4">{{ $settings['about_cta_title'] }}</h2>
                        <p class="lg:text-lg mb-6 lg:mb-8 max-w-3xl mx-auto">{{ $settings['about_cta_description'] }}</p>

                        <div class="flex flex-wrap gap-4 justify-center">
                            <a href="{{ route('mobileservice.frontend.booking', $workspaceSlug) }}" class="btn transition-all btn-white">
                                <i class="fas fa-calendar-alt group-hover:animate-pulse"></i>
                                <span>{{ __('Book Appointment') }}</span>
                            </a>
                        </div>
                    </div>
                </div>
            </section>
        @endif

    @else
        @include('mobile-service-management::frontend.partials.not-configured')
    @endif

@endsection
