@extends('mobile-service-management::frontend.layout')

@section('title', __('Book Service'))

@section('content')

    @include('mobile-service-management::frontend.partials.page-header', [
        'badge' => __('Book Service'),
        'title' => __('Schedule Your Repair Today'),
        'breadcrumbs' => [__('Book Service')],
    ])

    <!-- Booking Form Section -->
    <section class="py-10 lg:py-16 booking-form-sec bg-white">
        <div class="md:container mx-auto px-4 w-full">
            <div class="max-w-5xl mx-auto bg-white rounded-lg shadow-lg overflow-hidden">
                <!-- Progress Steps -->
                <div class="px-4 py-6 md:px-8 md:py-6 bg-tertiary border-b">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex-1 relative">
                            <div class="progress-track">
                                <div id="progress-bar" class="w-0 h-1.5 bg-primary transition-all"></div>
                            </div>
                        </div>
                    </div>
                    <div class="flex items-center justify-between">
                        <div class="flex flex-col items-center relative">
                            <div id="step-1-circle" class="step-circle step-active">
                                <span class="step-number">1</span>
                            </div>
                            <div class="mt-1 text-xs font-medium text-gray-700 text-center">{{ __('Service') }}</div>
                        </div>
                        <div class="flex flex-col items-center relative">
                            <div id="step-2-circle" class="step-circle bg-white text-gray-600">
                                <span class="step-number">2</span>
                            </div>
                            <div class="mt-1 text-xs font-medium text-gray-500 text-center">{{ __('Details') }}</div>
                        </div>
                        <div class="flex flex-col items-center relative">
                            <div id="step-3-circle" class="step-circle bg-white text-gray-600">
                                <span class="step-number">3</span>
                            </div>
                            <div class="mt-1 text-xs font-medium text-gray-500 text-center">{{ __('Confirm') }}</div>
                        </div>
                    </div>
                </div>

                <div class="px-4 py-6 md:px-8 md:py-6">
                    <!-- alerts -->
                    @include('mobile-service-management::frontend.partials.alerts')

                    <!-- Form Content -->
                    <form id="booking-form" action="{{ route('mobileservice.frontend.booking.store',$workspaceSlug) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <!-- Step 1 - Service Details -->
                        <div id="step-1-content" class="step-content active">
                            <h3 class="text-xl md:text-2xl font-bold text-secondary title-font mb-4 md:mb-6">{{ __('Tell Us About Your Device') }}</h3>
                            <div class="space-y-4 md:space-y-6">
                                <div>
                                    <label class="block text-gray-700 font-medium mb-2">{{ __('What service do you need?') }} *</label>
                                    <select id="service-type" name="mobile_service_id" class="border border-gray-300 rounded-lg w-full px-4 py-3" required>
                                        <option value="">{{ __('Select a service') }}</option>
                                        @foreach ($allServices as $service)
                                            <option value="{{ $service->id }}" data-price="{{ currency_format_with_sym($service->expected_price, $service->created_by, $service->workspace) }}" data-time="{{ $service->expected_duration }}">{{ $service->name }}</option>
                                        @endforeach
                                        <option value="0">{{ __('Other service') }}</option>
                                    </select>
                                    <span class="text-red-600 text-sm" id="error-service-type"></span>
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 md:gap-6">
                                    <div>
                                        <label class="block text-gray-700 font-medium mb-2">{{ __('Device Brand') }} *</label>
                                        <select id="device-brand" name="device_brand" class="border border-gray-300 rounded-lg w-full px-4 py-3" required>
                                            <option value="">{{ __('Select brand') }}</option>
                                            @foreach ($brands as $brand)
                                                <option value="{{ $brand->id }}">{{ $brand->name }}</option>
                                            @endforeach
                                        </select>
                                        <span class="text-red-600 text-sm" id="error-device-brand"></span>
                                    </div>
                                    <div>
                                        <label class="block text-gray-700 font-medium mb-2">{{ __('Device Model') }} *</label>
                                        <input id="device-model" name="mobile_model" type="text" placeholder="{{ __('Enter device model') }}" class="border border-gray-300 rounded-lg w-full px-4 py-3" required>
                                        <span class="text-red-600 text-sm" id="error-device-model"></span>
                                    </div>
                                </div>

                                <div>
                                    <label class="block text-gray-700 font-medium mb-3">{{ __('How soon do you need the repair?') }} *</label>
                                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 repair-list-wrp">
                                        <label class="urgency-option border rounded-lg p-4 flex items-start cursor-pointer">
                                            <input type="radio" id="priority" name="priority" value="standard" class="form-radio mt-1 me-3 text-primary" checked>
                                            <div class="form-radio-label">
                                                <h4 class="font-semibold text-gray-800">{{ __('Standard Repair') }}</h4>
                                                <p class="text-sm text-gray-600 mt-1">{{ __('2-3 business days') }}</p>
                                            </div>
                                        </label>
                                        <label class="urgency-option border rounded-lg p-4 flex items-start cursor-pointer">
                                            <input type="radio" id="priority" name="priority" value="priority" class="form-radio mt-1 me-3 text-primary">
                                            <div class="form-radio-label">
                                                <h4 class="font-semibold text-gray-800">{{ __('Priority Repair') }}</h4>
                                                <p class="text-sm text-gray-600 mt-1">{{ __('Next business day') }}</p>
                                            </div>
                                        </label>
                                        <label class="urgency-option border rounded-lg p-4 flex items-start cursor-pointer">
                                            <input type="radio" id="priority" name="priority" value="emergency" class="form-radio mt-1 me-3 text-primary">
                                            <div class="form-radio-label">
                                                <h4 class="font-semibold text-gray-800">{{ __('Emergency Repair') }}</h4>
                                                <p class="text-sm text-gray-600 mt-1">{{ __('Same day service') }}</p>
                                            </div>
                                        </label>
                                    </div>
                                    <span class="text-red-600 text-sm" id="error-device-priority"></span>
                                </div>

                                <div>
                                    <label class="block text-gray-700 font-medium mb-2">{{ __('Describe the issue') }} *</label>
                                    <textarea id="issue-description" name="description" class="border border-gray-300 rounded-lg w-full px-4 py-3" rows="4" placeholder="{{ __('Enter issue') }}" required></textarea>
                                    <span class="text-red-600 text-sm" id="error-issue-description"></span>
                                </div>

                                <div>
                                    <label class="block text-gray-700 font-medium mb-2">{{ __('Attachments') }}</label>
                                    <input id="attachments" name="attachments[]" type="file" multiple class="border border-gray-300 rounded-lg w-full px-4 py-3">
                                    <span class="text-sm text-gray-500">{{ __('You can upload multiple files') }}</span>
                                </div>
                            </div>

                            <div class="flex justify-end mt-4 md:mt-6">
                                <button type="button" onclick="nextStep(2)" class="btn transition-all">
                                    {{ __('Continue') }} <i class="fas fa-arrow-right"></i>
                                </button>
                            </div>
                        </div>

                        <!-- Step 2 - Personal Info -->
                        <div id="step-2-content" class="step-content">
                            <h3 class="text-xl md:text-2xl font-bold text-secondary title-font mb-4 md:mb-6">{{ __('Your Contact Information') }}</h3>
                            <div class="space-y-4 md:space-y-6">
                                <div>
                                    <label class="block text-gray-700 font-medium mb-2">{{ __('Name') }} *</label>
                                    <input id="name" name="customer_name" type="text" placeholder="{{ __('Enter name') }}" class="border border-gray-300 rounded-lg w-full px-4 py-3" required>
                                    <span class="text-red-600 text-sm" id="error-name"></span>
                                </div>

                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 md:gap-6">
                                    <div>
                                        <label class="block text-gray-700 font-medium mb-2">{{ __('Email Address') }} *</label>
                                        <input id="email" name="email" type="email" placeholder="{{ __('Enter email address') }}" class="border border-gray-300 rounded-lg w-full px-4 py-3" required>
                                        <span class="text-red-600 text-sm" id="error-email"></span>
                                    </div>

                                    <div>
                                        <label class="block text-gray-700 font-medium mb-2">{{ __('Phone Number') }} *</label>
                                        <input id="phone" name="mobile_no" type="tel" placeholder="{{ __('Enter phone number') }}" class="border border-gray-300 rounded-lg w-full px-4 py-3" required>
                                        <span class="text-sm text-red-600">{{ __('Please use with country code. (ex. +91)') }}</span></br>
                                        <span class="text-red-600 text-sm" id="error-phone"></span>
                                    </div>
                                </div>

                                <div>
                                    <label class="block text-gray-700 font-medium mb-2">{{ __('Address') }}</label>
                                    <textarea id="address" name="address" rows="3" placeholder="{{ __('Enter address') }}" class="border border-gray-300 rounded-lg w-full px-4 py-3"></textarea>
                                </div>
                            </div>

                            <div class="flex justify-between mt-4 md:mt-6">
                                <button type="button" onclick="prevStep(1)" class="btn btn-transparent transition-all">
                                    <i class="fas fa-arrow-left"></i> {{ __('Back') }}
                                </button>
                                <button type="button" onclick="nextStep(3)" class="btn transition-all">
                                    {{ __('Continue') }} <i class="fas fa-arrow-right"></i>
                                </button>
                            </div>
                        </div>

                        <!-- Step 3 - Confirmation -->
                        <div id="step-3-content" class="step-content">
                            <h3 class="text-xl md:text-2xl font-bold text-secondary title-font mb-4 md:mb-6">{{ __('Review Your Booking') }}</h3>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 md:gap-6">
                                <div class="md:col-span-2 space-y-6">
                                    <div class="bg-gray-50 p-4 md:px-4 md:py-6 rounded-lg">
                                        <h4 class="text-lg font-bold text-gray-800 mb-4">{{ __('Service Summary') }}</h4>
                                        <div class="space-y-4">
                                            <div id="summary-service" class="summary-item">
                                                <p class="text-sm text-gray-500">{{ __('Service Type') }}</p>
                                                <p class="font-medium"></p>
                                            </div>
                                            <div id="summary-device" class="summary-item">
                                                <p class="text-sm text-gray-500">{{ __('Device') }}</p>
                                                <p class="font-medium"></p>
                                            </div>
                                            <div id="summary-urgency" class="summary-item">
                                                <p class="text-sm text-gray-500">{{ __('Urgency') }}</p>
                                                <p class="font-medium"></p>
                                            </div>
                                            <div id="summary-issue" class="summary-item">
                                                <p class="text-sm text-gray-500">{{ __('Issue Description') }}</p>
                                                <p class="font-medium"></p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="bg-gray-50 p-4 md:px-4 md:py-6 rounded-lg">
                                        <h4 class="text-lg font-bold text-gray-800 mb-4">{{ __('Contact Information') }}</h4>
                                        <div class="space-y-4">
                                            <div id="summary-name" class="summary-item">
                                                <p class="text-sm text-gray-500">{{ __('Name') }}</p>
                                                <p class="font-medium"></p>
                                            </div>
                                            <div id="summary-email" class="summary-item">
                                                <p class="text-sm text-gray-500">{{ __('Contact') }}</p>
                                                <p class="font-medium"></p>
                                            </div>
                                            <div id="summary-address" class="summary-item">
                                                <p class="text-sm text-gray-500">{{ __('Address') }}</p>
                                                <p class="font-medium"></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Payment/Confirmation -->
                                <div class="space-y-6">
                                    <div class="bg-gray-50 p-4 md:px-4 md:py-6 rounded-lg">
                                        <h4 class="text-lg font-bold text-gray-800 mb-4">{{ __('Estimated Price & Time') }}</h4>
                                        <div id="price-time" class="space-y-3">
                                            <div class="flex flex-wrap justify-between gap-1">
                                                <p class="font-semibold">{{ __('Price') }}</p>
                                                <p id="total-price" class="font-bold text-lg text-primary"></p>
                                            </div>
                                            <div class="flex flex-wrap justify-between gap-1">
                                                <p class="font-semibold">{{ __('Time') }}</p>
                                                <p id="total-time" class="font-bold text-lg text-primary"></p>
                                            </div>
                                        </div>
                                        <div id="other-service" class="font-bold text-lg text-primary">{{ __('Price & Time will be provided after diagnosis') }}</div>
                                    </div>

                                    <div class="bg-gray-50 p-4 md:px-4 md:py-6 rounded-lg">
                                        <h4 class="text-lg font-bold text-gray-800 mb-4">{{ __('Special Requests') }}</h4>
                                        <textarea id="special-requests" name="special_requests" rows="3" placeholder="{{ __('Enter special requests') }}" class="border border-gray-300 rounded-lg w-full px-4 py-3 input-focus smooth-transition"></textarea>
                                    </div>

                                    <div class="bg-gray-50 p-4 md:px-4 md:py-6 rounded-lg">
                                        <label class="flex items-start">
                                            <input type="checkbox" id="terms-agreement" class="mt-1 me-3" required>
                                            <span class="text-sm text-gray-600 cursor-pointer">
                                                {{ __('I agree to the ') }}
                                                @php
                                                    $termsPage = \Workdo\MobileServiceManagement\Entities\MobileServiceCustomPage::getTermsPage($workspaceId);
                                                    $privacyPage = \Workdo\MobileServiceManagement\Entities\MobileServiceCustomPage::getPrivacyPage($workspaceId);
                                                @endphp
                                                @if($termsPage)
                                                    <a href="{{ route('mobileservice.frontend.custom-page', [$workspaceSlug, $termsPage->slug]) }}" class="text-primary hover:underline">{{ __('Terms and Conditions') }}</a>
                                                @else
                                                    <span class="text-primary">{{ __('Terms and Conditions') }}</span>
                                                @endif
                                                &
                                                @if($privacyPage)
                                                    <a href="{{ route('mobileservice.frontend.custom-page', [$workspaceSlug, $privacyPage->slug]) }}" class="text-primary hover:underline">{{ __('Privacy Policy') }}</a>
                                                @else
                                                    <span class="text-primary">{{ __('Privacy Policy') }}</span>
                                                @endif
                                                . {{ __('I understand that this is an estimate and final pricing may vary.') }}
                                            </span>
                                        </label>

                                        <button type="submit" class="w-full btn transition-all mt-4">
                                            {{ __('Confirm & Book Repair') }}
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <div class="flex justify-start mt-4 md:mt-6 lg:mt-8">
                                <button type="button" onclick="prevStep(2)" class="btn btn-transparent transition-all">
                                    <i class="fas fa-arrow-left"></i> {{ __('Back') }}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
@endsection
