<!-- Footer -->
<footer class="bg-secondary text-white pt-10 pb-4 md:pt-16 md:pb-8 site-footer">
    <div class="md:container mx-auto px-4 w-full">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 md:gap-10 border-b border-gray-100 pb-5">
            <div class="social-col">
                <div class="footer-logo-col mb-4">
                    <a href="{{ route('mobileservice.frontend.index', $workspaceSlug) }}" tabindex="0">
                        @if (!empty($settings['footer_logo']) && check_file($settings['footer_logo']))
                            <img src="{{ get_file($settings['footer_logo']) }}" alt="footer-logo">
                        @else
                            <img src="{{ asset('packages/workdo/MobileServiceManagement/src/Resources/assets/images/footer-logo.png') }}" alt="footer-logo">
                        @endif
                    </a>
                </div>
                @if (!empty($settings['footer_description']))
                    <p class="text-white mb-4 md:mb-8">
                        {{ $settings['footer_description'] }}
                    </p>
                @endif
                @php
                    $socialLinks = json_decode($settings['social_links'] ?? '[]', true);
                @endphp
                @if (!empty($socialLinks))
                    <div class="flex gap-3">
                        @foreach ($socialLinks as $social)
                            @if (!empty($social['link']) && !empty($social['icon']))
                                <a href="{{ $social['link'] }}" class="w-8 h-8 rounded-lg bg-primary flex items-center justify-center text-white">
                                    <i class="{{ $social['icon'] }}"></i>
                                </a>
                            @endif
                        @endforeach
                    </div>
                @endif
            </div>

            <div>
                @if (isset($footerServices) && count($footerServices) > 0)
                    <h4 class="text-lg lg:text-xl font-semibold mb-4">{{ __('Services') }}</h4>
                    <ul class="space-y-2">
                        @foreach ($footerServices as $service)
                            <li><a href="{{ route('mobileservice.frontend.service-details', [$workspaceSlug, encrypt($service->id)]) }}"
                                    class="text-white transition-all hover:ps-2">{{ $service->name }}</a></li>
                        @endforeach
                    </ul>
                @endif
            </div>

            <div>
                @if (isset($footerCustomPages) && count($footerCustomPages) > 0)
                    <h4 class="text-lg lg:text-xl font-semibold mb-4">{{ __('Quick Links') }}</h4>
                    <ul class="space-y-2">
                        @foreach ($footerCustomPages as $page)
                            <li><a href="{{ route('mobileservice.frontend.custom-page', [$workspaceSlug, $page->slug]) }}"
                                    class="text-white transition-all hover:ps-2">{{ $page->name }}</a></li>
                        @endforeach
                    </ul>
                @endif
            </div>

            <div>
                @if (!empty($settings['contact_address']) || !empty($settings['contact_phone']) || !empty($settings['contact_email']))
                    <h4 class="text-lg lg:text-xl font-semibold mb-4">{{ __('Contact Us') }}</h4>
                    <ul class="space-y-3 text-sm text-white">
                        @if (!empty($settings['contact_address']))
                            <li class="flex items-start text-sm lg:text-base">
                                <i class="fas fa-map-marker-alt text-primary mt-1 me-3"></i>
                                <p>{!! $settings['contact_address'] !!}</p>
                            </li>
                        @endif
                        @if (!empty($settings['contact_phone']))
                            <li class="flex items-center text-sm lg:text-base">
                                <i class="fas fa-phone text-primary me-3"></i>
                                <a href="tel:{{ $settings['contact_phone'] }}">{{ $settings['contact_phone'] }}</a>
                            </li>
                        @endif
                        @if (!empty($settings['contact_email']))
                            <li class="flex items-center text-sm lg:text-base">
                                <i class="fas fa-envelope text-primary me-3"></i>
                                <a href="mailto:{{ $settings['contact_email'] }}" class="break-all">{{ $settings['contact_email'] }}</a>
                            </li>
                        @endif
                    </ul>
                @endif
            </div>
        </div>

        <div class="flex flex-col md:flex-row justify-center items-center pt-5">
            <p class="text-white text-sm">
                &copy; {{ now()->year }} {{ $settings['footer_text'] ?? __('MobileRepair. All rights reserved.') }}
            </p>
        </div>
    </div>
</footer>
