<!-- Navigation -->
<header class="sticky top-0 z-50 w-full">
    <nav class="bg-white backdrop-filter backdrop-blur-lg w-full border-b border-gray-100">
        <div class="md:container mx-auto px-4 w-full">
            <div class="flex justify-between py-3 lg:py-4 items-center">
                <div class="flex items-center">
                    <h1 class="flex-shrink-0 flex items-center gap-3 logo-col">
                        <a href="{{ route('mobileservice.frontend.index', $workspaceSlug) }}">
                            @if (!empty($settings['logo']) && check_file($settings['logo']))
                                <img src="{{ get_file($settings['logo']) }}" alt="logo-image"
                                    class="size-full object-contain">
                            @else
                                <img src="{{ asset('packages/workdo/MobileServiceManagement/src/Resources/assets/images/logo.png') }}"
                                    alt="logo-image" class="size-full object-contain">
                            @endif
                        </a>
                    </h1>
                </div>

                <!-- Desktop Menu -->
                <div class="hidden md:flex items-center md:space-x-4 lg:space-x-8">
                    <a href="{{ route('mobileservice.frontend.services', $workspaceSlug) }}"
                        class="relative text-gray-900 hover:text-primary transition-colors group">{{ __('Services') }}</a>
                    @if (!empty($settings['is_faq_page_active']) && $settings['is_faq_page_active'] == 'on')
                        <a href="{{ route('mobileservice.frontend.faq', $workspaceSlug) }}"
                            class="relative text-gray-900 hover:text-primary transition-colors group">{{ __('FAQ') }}</a>
                    @endif
                    @if (!empty($settings['is_about_page_active']) && $settings['is_about_page_active'] == 'on')
                        <a href="{{ route('mobileservice.frontend.about', $workspaceSlug) }}"
                            class="relative text-gray-900 hover:text-primary transition-colors group">{{ __('About') }}</a>
                    @endif
                    @if (!empty($settings['is_contact_page_active']) && $settings['is_contact_page_active'] == 'on')
                        <a href="{{ route('mobileservice.frontend.contact', $workspaceSlug) }}"
                            class="relative text-gray-900 hover:text-primary transition-colors group">{{ __('Contact') }}</a>
                    @endif
                </div>

                <div class="menu-end-col hidden md:flex items-center gap-4">
                    <div class="relative hidden md:inline-block text-start">
                        <button data-dropdown-toggle="language" type="button"
                            class="flex items-center justify-between gap-2 language-btn">
                            <span class="w-[65px]">{{ Str::upper($currantLang) }}</span>
                            <i class="fas fa-chevron-down"></i>
                        </button>

                        <div data-dropdown-menu="language" class="absolute end-0 mt-2 py-2 w-full bg-white border rounded-lg shadow-lg hidden">
                            @foreach (languages() as $key => $language)
                                <a href="{{ route('mobileservice.frontend.lang-change', [$workspaceSlug, $key]) }}"
                                    class="block px-4 py-2 {{ $key == $currantLang ? 'text-primary' : 'text-gray-900' }} hover:text-dark-900 hover:bg-gray-100">
                                    <span>{{ Str::ucfirst($language) }}</span>
                                </a>
                            @endforeach
                        </div>
                    </div>

                    <a href="{{ route('mobileservice.frontend.booking', $workspaceSlug) }}" class="btn transition-all">
                        {{ __('Book Service') }}
                    </a>
                </div>

                <!-- Mobile Menu Button -->
                <div class="md:hidden flex items-center">
                    <button id="mobileMenuBtn"
                        class="text-gray-600 hover:text-primary focus:outline-none transition-colors">
                        <i class="fas fa-bars text-2xl"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Mobile Menu -->
        <div id="mobileMenu" class="md:hidden hidden">
            <div class="px-4 py-4">
                <div class="mobilemenu-btn-wrp flex items-center gap-4">
                    <div class="relative flex-1 inline-block text-start text-sm">
                        <button data-dropdown-toggle="mob-language" type="button"
                            class="w-full flex items-center justify-between gap-2 language-btn border border-dark-900 rounded-md">
                            <span>{{ Str::upper($currantLang) }}</span>
                            <i class="fas fa-chevron-down text-sm"></i>
                        </button>

                        <div data-dropdown-menu="mob-language" class="w-full absolute end-0 mt-2 py-2 min-w-28 bg-white border rounded-lg shadow-lg hidden">
                            @foreach (languages() as $key => $language)
                                <a href="{{ route('mobileservice.frontend.lang-change', [$workspaceSlug, $key]) }}"
                                    class="block px-4 py-2 {{ $key == $currantLang ? 'text-primary' : 'text-gray-900' }} hover:text-dark-900 hover:bg-gray-100">
                                    <span>{{ Str::ucfirst($language) }}</span>
                                </a>
                            @endforeach
                        </div>
                    </div>

                    <a href="{{ route('mobileservice.frontend.booking', $workspaceSlug) }}" class="flex-1 btn transition-all">
                        {{ __('Book Service') }}
                    </a>
                </div>

                <a href="{{ route('mobileservice.frontend.services', $workspaceSlug) }}"
                    class="block px-0 py-3 text-secondary transition-all border-b border-gray-300">{{ __('Services') }}</a>
                @if (!empty($settings['is_faq_page_active']) && $settings['is_faq_page_active'] == 'on')
                    <a href="{{ route('mobileservice.frontend.faq', $workspaceSlug) }}"
                        class="block px-0 py-3 text-secondary transition-all border-b border-gray-300">{{ __('FAQ') }}</a>
                @endif
                @if (!empty($settings['is_about_page_active']) && $settings['is_about_page_active'] == 'on')
                    <a href="{{ route('mobileservice.frontend.about', $workspaceSlug) }}"
                        class="block px-0 py-3 text-secondary transition-all border-b border-gray-300">{{ __('About') }}</a>
                @endif
                @if (!empty($settings['is_contact_page_active']) && $settings['is_contact_page_active'] == 'on')
                    <a href="{{ route('mobileservice.frontend.contact', $workspaceSlug) }}"
                        class="block px-0 py-3 text-secondary transition-all border-b border-gray-300">{{ __('Contact') }}</a>
                @endif
            </div>
        </div>
    </nav>
</header>
