@extends('mobile-service-management::frontend.layout')

@section('title', __('Service Details'))

@section('content')

    @include('mobile-service-management::frontend.partials.page-header', [
        'badge' => __('Service Details'),
        'title' => __('Service Overview'),
        'breadcrumbs' => [__('Service Details')],
    ])

    <!-- Service Details -->
    <section class="py-12 lg:py-16 bg-white">
        <div class="md:container mx-auto px-4 w-full">
            <div class="grid lg:grid-cols-3 gap-8 lg:gap-12">
                <div class="lg:col-span-2 space-y-5 md:space-y-10">
                    <!-- Service Overview -->
                    <div>
                        <h2 class="text-xl md:text-3xl font-bold text-secondary mb-4">{{ $service->name }}</h2>
                        <p class="text-gray-600 text-sm md:text-lg leading-relaxed mb-5 md:mb-10">{{ $service->description }}</p>

                        @if ($service->whats_included && count($service->whats_included) > 0)
                            <div class="bg-white border border-gray-200 rounded-lg p-4 md:p-8 shadow-sm">
                                <div class="flex items-center mb-3 md:mb-6">
                                    <div class="w-8 h-8 bg-primary rounded-lg flex items-center justify-center me-4">
                                        <span class="text-white font-bold text-sm"><i class="fa fa-check" ></i></span>
                                    </div>
                                    <h3 class="text-lg md:text-2xl font-bold text-secondary">{{ __('What\'s Included') }}</h3>
                                </div>

                                <div class="space-y-4">
                                    @foreach ($service->whats_included as $index => $item)
                                        <div class="flex items-start p-4 bg-gray-50 rounded-lg">
                                            <div class="w-6 h-6 bg-primary rounded-full flex items-center justify-center me-4 mt-1 flex-shrink-0">
                                                <span class="text-white text-xs font-bold">{{ $index + 1 }}</span>
                                            </div>
                                            <div>
                                                <h4 class="font-bold text-gray-800 mb-1">{{ $item['title'] ?? '' }}</h4>
                                                <p class="text-gray-600 text-sm">{{ $item['description'] ?? '' }}</p>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Sidebar -->
                <div>
                    <!-- Price Card -->
                    <div class="bg-gray-50 border border-gray-200 p-4 md:p-6 lg:p-8 rounded-lg sticky top-6">
                        <div class="text-center mb-6">
                            <div class="text-4xl font-bold text-secondary mb-2">{{ currency_format_with_sym($service->expected_price, $service->created_by, $service->workspace) }}</div>
                            <div class="text-black">{{ __('Starting Price') }}</div>
                            <div class="text-sm text-black mt-1">{{ __('*Price varies by device model') }}</div>
                        </div>

                        <div class="space-y-4 mb-6 text-sm">
                            <div class="flex justify-between">
                                <span class="text-gray-600">{{ __('Expected Repair Time') }}:</span>
                                <span class="font-semibold text-secondary">{{ $service->expected_duration }}</span>
                            </div>
                        </div>

                        <div class="flex gap-3 flex-col md:flex-row lg:flex-col">
                            <a href="{{ route('mobileservice.frontend.booking', $workspaceSlug) }}"
                                class="w-full btn block text-center transition-all duration-300 hover:transform">
                                {{ __('Book Appointment') }}
                            </a>
                            @if (!empty($settings['contact_phone']))
                                <a href="tel:{{ $settings['contact_phone'] }}"
                                    class="w-full btn btn-transparent block text-center transition-all duration-300 hover:transform ">
                                    {{ __('Call') }}: {{ $settings['contact_phone'] }}
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Services -->
    @if (!empty($similarServices) && count($similarServices) > 0)
    <section class="pb-12 lg:pb-16 bg-white">
        <div class="md:container mx-auto px-4 w-full">
            <div class="text-center mb-5 md:mb-10">
                <span class="inline-flex items-center bg-white text-secondary uppercase px-4 py-1.5 rounded-full text-xs font-semibold mb-4 shadow-sm border border-gray-200">
                    <i class="fas fa-circle text-primary text-xxs me-2"></i>
                    {{ __('Other Services') }}
                </span>
                <h2 class="text-xl md:text-3xl font-bold font-bold text-secondary title-font">{{ __('Similar Services') }}</h2>
            </div>
            <div class="{{ count($similarServices) > 2 ? 'service-slider swiper' : '' }}">
                <div class="{{ count($similarServices) > 2 ? 'swiper-wrapper' : 'grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6 lg:gap-8' }}">
                    @foreach ($similarServices as $relatedService)
                        <div class="swiper-slide h-auto">
                            <div class="bg-white p-4 sm:p-5 lg:p-6 rounded-lg border border-gray-200 hover:shadow-lg hover:border-secondary transition-all h-full flex flex-col">
                                <div class="text-center flex-1 flex flex-col">
                                    <div class="w-12 h-12 sm:w-14 sm:h-14 lg:w-16 lg:h-16 bg-secondary rounded-lg flex items-center justify-center mb-3 sm:mb-4 mx-auto">
                                        <i class="{{ $relatedService->icon }} text-white text-lg sm:text-xl lg:text-2xl"></i>
                                    </div>
                                    <h3 class="text-lg sm:text-xl lg:text-2xl font-bold text-gray-800 mb-2 sm:mb-3">{{ $relatedService->name }}</h3>
                                    <p class="text-sm sm:text-base text-gray-600 mb-4 sm:mb-5 leading-relaxed flex-1">
                                        {{ Str::limit($relatedService->description, 80) }}
                                    </p>
                                    <div class="flex flex-col sm:flex-row items-center justify-between gap-2 sm:gap-0 mt-auto">
                                        <span class="text-xl sm:text-2xl font-bold text-primary">{{ __('From') . ' ' . currency_format_with_sym($relatedService->expected_price, $relatedService->created_by, $relatedService->workspace) }}</span>
                                        <a href="{{ route('mobileservice.frontend.service-details', [$workspaceSlug, encrypt($relatedService->id)]) }}"
                                            class="text-secondary hover:text-primary font-medium transition-colors text-sm sm:text-base">
                                            {{ __('Details') }} <i class="fas fa-arrow-right ms-1"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                @if(count($similarServices) > 2)
                    <div class="swiper-button-prev"></div>
                    <div class="swiper-button-next"></div>
                @endif
            </div>
        </div>
    </section>
    @endif

    <!-- Customer Reviews Section -->
    <section class="py-12 lg:py-16 bg-gray-50" id="reviews">
        <div class="md:container mx-auto px-4 w-full">
            <!-- Two Column Layout -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                <!-- Write A Review Form -->
                <div class="bg-white p-4 md:p-6 rounded-lg border border-gray-200">
                    <div class="flex items-center mb-3 md:mb-6">
                        <i class="fas fa-edit text-secondary me-3 text-lg"></i>
                        <h3 class="text-lg font-bold text-gray-800">{{ __('Write A Review') }}</h3>
                    </div>

                    <!-- alerts -->
                    @include('mobile-service-management::frontend.partials.alerts')

                    <form class="space-y-4" method="POST" action="{{ route('mobileservice.frontend.review.store', $workspaceSlug) }}">
                        @csrf
                        <input type="hidden" name="mobile_service_id" value="{{ $service->id }}">
                        <div>
                            <label class="block text-sm font-medium text-black mb-2">{{ __('Your Name') }} *</label>
                            <input type="text" name="name" placeholder="{{ __('Enter your name') }}" required
                                class="w-full border border-gray-300 rounded-lg px-4 py-3" value="{{ old('name') }}">
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-black mb-1">{{ __('Email Address') }} *</label>
                                <input type="email" name="email" required
                                    class="w-full px-4 py-3 border border-gray-300 rounded-lg"
                                    placeholder="{{ __('Enter email address') }}" value="{{ old('email') }}">
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-black mb-2">{{ __('Rating') }} *</label>
                                <div class="flex space-x-1" id="star-rating">
                                    <i class="fas fa-star text-2xl text-gray-300 cursor-pointer hover:text-yellow-400 transition-colors" data-rating="1"></i>
                                    <i class="fas fa-star text-2xl text-gray-300 cursor-pointer hover:text-yellow-400 transition-colors" data-rating="2"></i>
                                    <i class="fas fa-star text-2xl text-gray-300 cursor-pointer hover:text-yellow-400 transition-colors" data-rating="3"></i>
                                    <i class="fas fa-star text-2xl text-gray-300 cursor-pointer hover:text-yellow-400 transition-colors" data-rating="4"></i>
                                    <i class="fas fa-star text-2xl text-gray-300 cursor-pointer hover:text-yellow-400 transition-colors" data-rating="5"></i>
                                </div>
                                <input type="hidden" name="rating" id="rating-value" value="1">
                            </div>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-black mb-2">{{ __('Your Review') }} *</label>
                            <textarea rows="2" name="review" placeholder="Write your review here" required
                                class="w-full border border-gray-300 rounded-lg px-4 py-3 resize-none">{{ old('review') }}</textarea>
                        </div>

                        <button type="submit" class="w-full btn py-3 px-6 rounded-lg transition-colors font-medium">
                            {{ __('Submit Review') }}
                        </button>
                    </form>
                </div>

                <!-- Customer Reviews List -->
                <div class="bg-white rounded-lg border border-gray-200">
                    <h3 class="text-lg font-bold text-gray-800 p-4 md:p-6 !pb-0 md:mb-5 mb-3">{{ __('Customer Reviews') }}</h3>

                    <div class="lg:space-y-6 space-y-4 max-h-96 overflow-y-auto p-4 md:p-6 !pt-0">
                        @forelse($reviews as $review)
                            <div class="border-b border-gray-100 md:pb-6 pb-4 last:border-b-0 last:pb-0">
                                <div class="flex items-start space-x-4">
                                    <div class="w-12 h-12 rounded-full bg-secondary flex items-center justify-center flex-shrink-0">
                                        <span class="text-white font-semibold text-sm">{{ strtoupper(substr($review->name, 0, 2)) }}</span>
                                    </div>
                                    <div class="flex-1">
                                        <div class="flex items-center space-x-2 mb-2">
                                            <h4 class="font-semibold text-gray-800">{{ $review->name }}</h4>
                                            <div class="flex text-yellow-400">
                                                @for($i = 1; $i <= 5; $i++)
                                                    <i class="fas fa-star text-xs {{ $i <= $review->rating ? '' : 'text-gray-300' }}"></i>
                                                @endfor
                                            </div>
                                        </div>
                                        <p class="text-gray-600 text-sm mb-2 leading-relaxed line-clamp-3">{{ $review->review }}</p>
                                        <p class="text-xs text-gray-700">{{ __('Posted on') . ' ' . $review->created_at->format('F d, Y') }}</p>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="text-center py-8">
                                <p class="text-gray-500">{{ __('No reviews yet. Be the first to review this service!') }}</p>
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection


