@extends('mobile-service-management::frontend.layout')

@section('title', __('Services'))

@section('content')

    @include('mobile-service-management::frontend.partials.page-header', [
        'badge' => __('Our Services'),
        'title' => __('Our Mobile Services'),
        'breadcrumbs' => [__('Services')],
    ])

    <!-- Services Section -->
    <section class="py-10 lg:py-16 bg-white">
        <div class="md:container mx-auto px-4 w-full">
             @if (count($categories) > 0)
                <div class="tab-wrapper mb-4">
                    <div class="tab-wrapper-inner flex gap-4">
                        <button class="service-filter bg-gray-200 text-gray-700 px-4 py-2 rounded-lg outline-none hover:bg-primary  hover:text-white transition-colors active" data-category="all">
                            {{ __('All Services') }}
                        </button>
                        @foreach ($categories as $category)
                            <button class="service-filter bg-gray-200 text-gray-700 px-4 py-2 rounded-lg outline-none hover:bg-primary  hover:text-white transition-colors" data-category="{{ $category->id }}">
                                {{ $category->category_name }}
                            </button>
                        @endforeach
                    </div>
                </div>
            @endif

            @if (count($allServices) != 0)
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8" id="services-grid">
                    @foreach ($allServices as $service)
                        <div class="h-full flex flex-col service-item bg-white rounded-lg border border-gray-200 p-4 xl:p-6 transition-all duration-300" data-category="{{ $service->category_id }}">
                            <div class="text-center h-full flex flex-col">
                                <div class="service-content-top flex-1">
                                    <div class="bg-primary w-16 h-16 xl:w-20 xl:h-20 rounded-full flex items-center justify-center mx-auto mb-4">
                                        <i class="{{ $service->icon }} text-white text-3xl"></i>
                                    </div>
                                    <h3 class="text-xl lg:text-2xl font-bold text-gray-900 mb-4">{{ $service->name }}</h3>
                                    <p class="text-gray-600 mb-4 line-clamp-2">
                                        {{ $service->description }}
                                    </p>
                                    @php
                                        $whatsIncluded = $service->whats_included;
                                        $hasValidWhatsIncluded = array_filter($whatsIncluded, function ($item) {
                                                return !empty($item['title']);
                                            });
                                    @endphp
                                    @if (!empty($hasValidWhatsIncluded))
                                        <div class="bg-gray-50 rounded-lg p-4 mb-4">
                                            <h4 class="font-semibold text-gray-900 mb-3">{{ __('What\'s Included') }}:</h4>
                                            <ul class="text-sm text-gray-600 space-y-2 text-start list-disc ps-4">
                                                @foreach ($hasValidWhatsIncluded as $item)
                                                    <li>{{ $item['title'] ?? '' }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif
                                </div>
                                <div class="flex justify-between items-center mb-4">
                                    <div class="text-start">
                                        <span class="text-sm text-gray-500">{{ __('Starting from') }}</span>
                                        <div class="text-xl lg:text-2xl font-bold text-secondary">{{ currency_format_with_sym($service->expected_price, $service->created_by, $service->workspace) }}</div>
                                    </div>
                                    <div class="text-end">
                                        <span class="text-sm text-gray-500">{{ __('Duration') }}</span>
                                        <div class="text-lg font-semibold text-gray-900">{{ $service->expected_duration }}</div>
                                    </div>
                                </div>
                                <div class="flex justify-center gap-3">
                                    <a href="{{ route('mobileservice.frontend.service-details', [$workspaceSlug, encrypt($service->id)]) }}" class="btn transition-all">
                                        {{ __('Learn More') }}
                                    </a>
                                    <a href="{{ route('mobileservice.frontend.booking', $workspaceSlug) }}" class="btn btn-transparent transition-all">
                                        {{ __('Book Now') }}
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                @include('mobile-service-management::frontend.partials.not-configured')
            @endif
        </div>
    </section>
@endsection
