@permission('mobileservice_servicerequest end')
    <div class="action-btn me-2">
        <a href="{{ route('mobileservice.service-request.end', ['serviceId' => encrypt($data->service_id)]) }}"
            class="bg-success btn btn-sm" data-toggle="tooltip" title="{{ __('End Request') }}">
            <i class="ti ti-check text-white"></i>
        </a>
    </div>
@endpermission

@permission('mobileservice_servicerequest technician assign')
    <div class="action-btn me-2">
        <a class="bg-secondary btn btn-sm" data-ajax-popup="true" data-size="md" data-title="{{ __('Assign Technician') }}"
            data-url="{{ route('mobileservice.service-request.assign-technician.create', ['serviceId' => encrypt($data->service_id)]) }}"
            data-toggle="tooltip" title="{{ __('Assign Technician') }}">
            <i class="ti ti-user-check text-white"></i>
        </a>
    </div>
@endpermission

@permission('mobileservice_servicerequest show')
    <div class="action-btn me-2">
        <a href="{{ route('mobileservice.service-request.show', ['serviceId' => encrypt($data->service_id)]) }}"
            class="bg-warning btn btn-sm" data-toggle="tooltip" title="{{ __('View') }}">
            <i class="ti ti-eye text-white"></i>
        </a>
    </div>
@endpermission

@permission('mobileservice_servicerequest edit')
    <div class="action-btn me-2">
        <a href="{{ route('mobileservice.service-request.edit', ['serviceId' => encrypt($data->service_id)]) }}"
            class="bg-info btn btn-sm" data-toggle="tooltip" title="{{ __('Edit') }}">
            <i class="ti ti-pencil text-white"></i>
        </a>
    </div>
@endpermission

@permission('mobileservice_servicerequest delete')
    <div class="action-btn">
        <form method="POST" action="{{ route('mobileservice.service-request.destroy', ['serviceId' => encrypt($data->service_id)]) }}"
            id="delete-form-{{ $data->id }}">
            @csrf
            @method('DELETE')
            <a href="#" class="bg-danger btn btn-sm show_confirm" data-bs-toggle="tooltip"
                title="{{ __('Delete') }}" data-original-title="{{ __('Delete') }}"
                data-confirm="{{ __('Are You Sure?') }}"
                data-text="{{ __('This action can not be undone. Do you want to continue?') }}"
                data-confirm-yes="delete-form-{{ $data->id }}">
                <i class="ti ti-trash text-white"></i>
            </a>
        </form>
    </div>
@endpermission
