@extends('layouts.main')

@section('page-title')
    {{ __('Edit Service Request') }}
@endsection

@section('page-breadcrumb')
    {{ __('Service Request') }},
    {{ $serviceReqData->service_id }}
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            {{ Form::open(['route' => ['mobileservice.service-request.update', 'serviceId' => encrypt($serviceReqData->service_id)], 'method' => 'post', 'enctype' => 'multipart/form-data', 'class' => 'needs-validation', 'novalidate']) }}
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">{{ __('Customer Details') }}</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="form-group col-md-4">
                            <label for="customer_name" class="form-label">{{ __('Name') }}</label> <x-required></x-required>
                            <input type="text" name="customer_name" id="customer_name" class="form-control" placeholder="{{ __('Enter name') }}" value="{{ $serviceReqData->customer_name }}" required>
                            @error('customer_name')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="form-group col-md-4">
                            <label for="email" class="form-label">{{ __('Email Address') }}</label> <x-required></x-required>
                            <input type="email" name="email" id="email" class="form-control" placeholder="{{ __('Enter email address') }}" value="{{ $serviceReqData->email }}" required>
                            @error('email')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>

                        <x-mobile divClass="col-md-4" label="{{ __('Phone Number') }}" name="mobile_no"
                            placeholder="{{ __('Enter phone number') }}" class="form-control"
                            value="{{ $serviceReqData->mobile_no }}" id="mobile_no" required></x-mobile>

                        <div class="form-group col-md-12">
                            <label for="address" class="form-label">{{ __('Address') }}</label>
                            <textarea name="address" id="address" class="form-control" rows="2" placeholder="{{ __('Enter address') }}">{{ $serviceReqData->address }}</textarea>
                            @error('address')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">{{ __('Service & Device Details') }}</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label for="mobile_service_id" class="form-label">{{ __('Service') }}</label> <x-required></x-required>
                            <select name="mobile_service_id" id="mobile_service_id" class="form-control" required>
                                <option value="">{{ __('Select a service') }}</option>
                                @if (isset($allServices))
                                    @foreach ($allServices as $service)
                                        <option value="{{ $service->id }}" {{ $serviceReqData->mobile_service_id == $service->id ? 'selected' : '' }}>{{ $service->name }}</option>
                                    @endforeach
                                @endif
                                <option value="0" {{ $serviceReqData->mobile_service_id == 0 ? 'selected' : '' }}>{{ __('Other service') }}</option>
                            </select>
                            @error('mobile_service_id')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="form-group col-md-6">
                            <label for="priority" class="form-label">{{ __('Priority') }}</label> <x-required></x-required>
                            <select class="form-control" name="priority" id="priority" required>
                                <option value="">{{ __('Select priority') }}</option>
                                <option value="standard" {{ $serviceReqData->priority == 'standard' ? 'selected' : '' }}>{{ __('Standard') }}</option>
                                <option value="priority" {{ $serviceReqData->priority == 'priority' ? 'selected' : '' }}>{{ __('Priority') }}</option>
                                <option value="emergency" {{ $serviceReqData->priority == 'emergency' ? 'selected' : '' }}>{{ __('Emergency') }}</option>
                            </select>
                            @error('priority')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="form-group col-md-6">
                            <label for="device_brand" class="form-label">{{ __('Device Brand') }}</label> <x-required></x-required>
                            <select name="device_brand" id="device_brand" class="form-control" required>
                                <option value="">{{ __('Select brand') }}</option>
                                @if (isset($brands))
                                    @foreach ($brands as $brand)
                                        <option value="{{ $brand->id }}" {{ $serviceReqData->device_brand == $brand->id ? 'selected' : '' }}>{{ $brand->name }}</option>
                                    @endforeach
                                @endif
                            </select>
                            @error('device_brand')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="form-group col-md-6">
                            <label for="mobile_model" class="form-label">{{ __('Device Model') }}</label> <x-required></x-required>
                            <input type="text" name="mobile_model" id="mobile_model" class="form-control" placeholder="{{ __('Enter device model') }}" value="{{ $serviceReqData->mobile_model }}" required>
                            @error('mobile_model')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="form-group col-md-12">
                            <label for="description" class="form-label">{{ __('Describe the issue') }}</label> <x-required></x-required>
                            <textarea name="description" id="description" class="form-control" rows="4" placeholder="{{ __('Enter issue') }}" required>{{ $serviceReqData->description }}</textarea>
                            @error('description')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>

            @permission('mobileservice_servicerequest livetracking manage')
                @if ($trackingStatus->isNotEmpty())
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">{{ __('Tracking Status') }}</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-md-4 mb-0">
                                    <select class="form-select" name="tracking_status" id="tracking_status" required>
                                        <option selected disabled>{{ __('Tracking Status') }}</option>
                                        @foreach ($trackingStatus as $status)
                                            <option value="{{ $status->id }}" {{ $serviceReqData['tracking_status'] == $status->id ? 'selected' : '' }}>{{ __($status->status_name) }}</option>
                                        @endforeach
                                    </select>
                                    @error('priority')
                                        <p class="text-danger mb-3">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            @endpermission

            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">{{ __('More Details') }}</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="form-group col-md-12">
                            <label for="special_requests" class="form-label">{{ __('Special Requests') }}</label>
                            <textarea name="special_requests" id="special_requests" class="form-control" rows="3" placeholder="{{ __('Enter special requests') }}">{{ $serviceReqData->special_requests }}</textarea>
                            @error('special_requests')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="form-group col-md-12">
                            <label for="attachments" class="form-label">{{ __('Attachments') }}</label>
                            <input type="file" class="form-control" name="attachments[]" id="attachments" multiple>
                            <small class="text-muted">{{ __('You can upload multiple files') }}</small>
                            @error('attachments')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror

                            @if (!empty($serviceReqData->attachment))
                                @php
                                    $attachments = explode(',', $serviceReqData->attachment);
                                    $attachments = array_filter($attachments, function ($file) {
                                        return !empty($file) && check_file($file);
                                    });
                                    $index = 0;
                                @endphp
                                @if (!empty($attachments))
                                    <div class="mt-3">
                                    <div class="d-flex justify-content-between align-items-center mb-3" id="attachment">
                                            <h6 class="text-muted mb-0">{{ __('Current Attachments') }}</h6>
                                            <span class="badge bg-primary px-3 py-2 file_count">{{ count($attachments) }} {{ __('Files') }}</span>
                                        </div>
                                        <div class="row g-3">
                                            @foreach ($attachments as $attachment)
                                                @php
                                                    $index = ++$index;
                                                    $fileExtension = pathinfo($attachment, PATHINFO_EXTENSION);
                                                    $imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
                                                    $isImage = in_array(strtolower($fileExtension), $imageExtensions);
                                                @endphp

                                                <div class="col-md-6 col-lg-3 attachment-card">
                                                    <div class="border rounded p-3 bg-light position-relative d-flex flex-column" style="min-height: 200px;">
                                                        <div class="dropdown position-absolute" style="top: 8px; right: 8px;">
                                                            <button class="btn btn-sm btn-light border-0" type="button" data-bs-toggle="dropdown">
                                                                <i class="ti ti-dots-vertical"></i>
                                                            </button>
                                                            <ul class="dropdown-menu">
                                                                <li><a class="dropdown-item" href="{{ get_file($attachment) }}" target="_blank"><i class="ti ti-eye me-2"></i>{{ __('View') }}</a></li>
                                                                <li><a class="dropdown-item" href="{{ get_file($attachment) }}" download><i class="ti ti-download me-2"></i>{{ __('Download') }}</a></li>
                                                                <li><hr class="dropdown-divider"></li>
                                                                <li><a class="dropdown-item text-danger" href="#attachment" onclick="deleteAttachment('{{ $serviceReqData->service_id }}', '{{ $attachment }}', this)"><i class="ti ti-trash me-2"></i>{{ __('Delete') }}</a></li>
                                                            </ul>
                                                        </div>
                                                        <div class="text-center mb-3 flex-grow-1 d-flex align-items-center justify-content-center">
                                                            @if ($isImage)
                                                                <img src="{{ get_file($attachment) }}" alt="Attachment {{ $index }}" class="img-fluid rounded" style="max-height: 120px;">
                                                            @else
                                                                <div class="bg-secondary text-white rounded d-inline-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                                                                    <i class="fas fa-file fa-lg"></i>
                                                                </div>
                                                            @endif
                                                        </div>
                                                        <div class="d-flex justify-content-between align-items-center mt-auto">
                                                            <small class="text-muted">{{ $isImage ? __('Image') : __('File') }} #{{ $index }}</small>
                                                            <span class="badge bg-success">{{ strtoupper($fileExtension) }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            <div class="float-end">
                <button type="button" id="cancel" class="btn btn-secondary me-2" onclick="window.location.href='{{ route('mobileservice.service-request.index') }}'">{{ __('Cancel') }}</button>
                <button type="submit" id="submit" class="btn  btn-primary">{{ __('Update') }}</button>
            </div>
            {{ Form::close() }}
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function deleteAttachment(serviceId, filePath, btn) {
            $.ajax({
                url: "{{ route('mobileservice.service-request.attachment-destroy', ['serviceId' => '__id__']) }}".replace('__id__', serviceId),
                type: "POST",
                data: {
                    _method: 'DELETE',
                    _token: "{{ csrf_token() }}",
                    file: filePath
                },
                success: function (response) {
                    $(btn).closest('.attachment-card').fadeOut(300, function() {
                        $(this).remove();
                        var remainingCards = $('.attachment-card').length;
                        $('.file_count').text(remainingCards + ' {{ __('Files') }}');
                    });
                    toastrs('Success', '{{ __('Attachment deleted successfully') }}', 'success');
                },
                error: function () {
                    toastrs('Error', '{{ __('Failed to delete attachment') }}', 'error');
                }
            });
        }
    </script>
@endpush
