@extends('layouts.main')

@section('page-title')
    {{ __('Manage Service Category') }}
@endsection

@section('page-breadcrumb')
    {{ __('Service Category') }}
@endsection

@section('page-action')
    <div>
        @permission('mobileservice_servicecategory create')
            <a class="btn btn-sm btn-primary" data-ajax-popup="true" data-size="md" data-title="{{ __('Create Service Category') }}"
                data-url="{{ route('mobileservice.service-category.create') }}" data-toggle="tooltip" title="{{ __('Create') }}">
                <i class="ti ti-plus"></i>
            </a>
        @endpermission
    </div>
@endsection

@section('content')
    <div class="row">
        @include('mobile-service-management::service-setup.setup')

        <div class="col-sm-9">
            <div class="card">
                <div class="card-header">
                    <h5>{{ __('Service Category') }}</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0" id="assets" data-repeater-list="stages">
                            <thead>
                                <th>#</th>
                                <th>{{ __('Name') }}</th>
                                @if (Laratrust::hasPermission('mobileservice_servicecategory edit') || Laratrust::hasPermission('mobileservice_servicecategory delete'))
                                    <th width="10%">{{ __('Action') }}</th>
                                @endif
                            </thead>
                            <tbody>
                                @forelse($categoryData as $index => $category)
                                    <tr>
                                        <th>{{ ++$index }}</th>
                                        <td>{{ $category->category_name }}</td>
                                        @if (Laratrust::hasPermission('mobileservice_servicecategory edit') || Laratrust::hasPermission('mobileservice_servicecategory delete'))
                                            <td width="10%">
                                                @permission('mobileservice_servicecategory edit')
                                                    <div class="action-btn me-2">
                                                        <a class="bg-info btn btn-sm"
                                                            data-url="{{ route('mobileservice.service-category.edit', ['categoryId' => $category->id]) }}"
                                                            data-ajax-popup="true" data-size="md"
                                                            data-title="{{ __('Edit Service Category') }}"
                                                            data-toggle="tooltip" title="{{ __('Edit') }}">
                                                            <i class="ti ti-pencil text-white"></i>
                                                        </a>
                                                    </div>
                                                @endpermission
                                                @permission('mobileservice_servicecategory delete')
                                                    <div class="action-btn">
                                                        <form method="POST" action="{{ route('mobileservice.service-category.delete', $category->id) }}"
                                                            id="delete-form-{{ $category->id }}">
                                                            @csrf
                                                            @method('DELETE')
                                                            <a href="#" class="bg-danger btn btn-sm show_confirm"
                                                                data-bs-toggle="tooltip" title="{{ __('Delete') }}"
                                                                data-original-title="{{ __('Delete') }}"
                                                                data-confirm="{{ __('Are You Sure?') }}"
                                                                data-text="{{ __('This action can not be undone. Do you want to continue?') }}"
                                                                data-confirm-yes="delete-form-{{ $category->id }}">
                                                                <i class="ti ti-trash text-white"></i>
                                                            </a>
                                                        </form>
                                                    </div>
                                                @endpermission
                                            </td>
                                        @endif
                                    </tr>
                                @empty
                                    @include('layouts.nodatafound')
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
