@extends('layouts.main')

@section('page-title')
    {{ __('Create Service') }}
@endsection

@section('page-breadcrumb')
    {{ __('Services') }}
@endsection

@section('content')
    {{ Form::open(['route' => 'mobileservice.services.store', 'method' => 'post', 'class' => 'needs-validation row', 'novalidate']) }}
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5>{{ __('Service Details') }}</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            {{ Form::label('name', __('Name'), ['class' => 'form-label']) }} <x-required></x-required>
                            {{ Form::text('name', null, ['class' => 'form-control', 'required' => 'required', 'placeholder' => __('Enter name')]) }}
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            {{ Form::label('category_id', __('Category'), ['class' => 'form-label']) }} <x-required></x-required>
                            {{ Form::select('category_id', $categories->pluck('category_name', 'id'), null, ['class' => 'form-control', 'required' => 'required', 'placeholder' => __('Select category')]) }}
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            {{ Form::label('description', __('Description'), ['class' => 'form-label']) }}
                            {{ Form::textarea('description', null, ['class' => 'form-control', 'rows' => 3, 'placeholder' => __('Enter description')]) }}
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            {{ Form::label('expected_price', __('Expected Price'), ['class' => 'form-label']) }} <x-required></x-required>
                            {{ Form::number('expected_price', null, ['class' => 'form-control', 'required' => 'required', 'step' => '0.01', 'placeholder' => __('Enter expected price')]) }}
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            {{ Form::label('expected_duration', __('Expected Duration'), ['class' => 'form-label']) }} <x-required></x-required>
                            {{ Form::text('expected_duration', null, ['class' => 'form-control', 'required' => 'required', 'placeholder' => __('Enter expected duration')]) }}
                        </div>
                    </div>
                </div>
                <div class="row align-items-center">
                    <div class="col-md-4">
                        <x-icon-picker name="icon" :value="''" label="{{ __('Icon') }}" required />
                    </div>
                    <div class="col-md-8">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="d-flex align-items-center">
                                    <span class="me-2">{{ __('Status') }}:</span>
                                    <div class="form-check form-switch custom-switch-v1">
                                        {{ Form::checkbox('is_active', 1, true, ['class' => 'form-check-input', 'id' => 'is_active']) }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="d-flex align-items-center">
                                    <span class="me-2">{{ __('Show in Expertise') }}:</span>
                                    <div class="form-check form-switch custom-switch-v1">
                                        {{ Form::checkbox('show_in_expertise', 1, false, ['class' => 'form-check-input', 'id' => 'show_in_expertise']) }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="d-flex align-items-center">
                                    <span class="me-2">{{ __('Show in Footer') }}:</span>
                                    <div class="form-check form-switch custom-switch-v1">
                                        {{ Form::checkbox('show_in_footer', 1, false, ['class' => 'form-check-input', 'id' => 'show_in_footer']) }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5>{{ __('What\'s Included') }}</h5>
            </div>
            <div class="card-body">
                <div class="repeater" id="whats-included-repeater">
                    <div data-repeater-list="whats_included">
                        <div data-repeater-item class="item-row border rounded p-3 mb-3">
                            <div class="row g-3">
                                <div class="col-md-5">
                                    <div class="form-group">
                                        <label class="form-label">{{ __('Title') }}</label>
                                        <input type="text" name="title" class="form-control" placeholder="{{ __('Enter title') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label">{{ __('Description') }}</label>
                                        <textarea name="description" class="form-control" placeholder="{{ __('Enter description') }}" rows="3"></textarea>
                                    </div>
                                </div>
                                <div class="col-md-1 d-flex align-items-center justify-content-center">
                                    <button type="button" data-repeater-delete class="btn btn-danger btn-sm">
                                        <i class="ti ti-trash"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="d-flex justify-content-center mt-3">
                        <button type="button" data-repeater-create class="btn btn-primary">
                            <i class="ti ti-plus"></i> {{ __('Add') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="float-end">
            <button type="button" class="btn btn-secondary me-2" onclick="window.location.href='{{ route('mobileservice.services.index') }}'">{{ __('Cancel') }}</button>
            <button type="submit" id="submit" class="btn btn-primary">{{ __('Create') }}</button>
        </div>
    </div>
    {{ Form::close() }}
@endsection

@push('scripts')
    <script src="{{ asset('js/jquery.repeater.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('#whats-included-repeater').repeater({
                initEmpty: false,
                defaultValues: {
                    'title': '',
                    'description': ''
                },
                show: function() {
                    $(this).slideDown();
                },
                hide: function(deleteElement) {
                    $(this).slideUp(deleteElement);
                }
            });
        });
    </script>
@endpush
