{{ Form::open(['route' => 'mobileservice.about-setup.mission.store', 'method' => 'post', 'class' => 'needs-validation', 'novalidate']) }}
<div class="row">
    <div class="col-md-12">
        <div class="form-group">
            {{ Form::label('mission_title', __('Title'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::text('mission_title', $settings['mission_title'] ?? '', ['class' => 'form-control', 'placeholder' => __('Enter title'), 'required']) }}
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="form-group">
            {{ Form::label('mission_description', __('Description'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::textarea('mission_description', $settings['mission_description'] ?? '', ['class' => 'form-control', 'rows' => 3, 'placeholder' => __('Enter description'), 'required']) }}
        </div>
    </div>
</div>

<div class="border rounded p-3 mb-4">
    <h5 class="mb-3">{{ __('Mission') }}</h5>
    @for ($i = 1; $i <= 3; $i++)
        @php
            $mission_items = json_decode($settings['mission_items'] ?? '[]', true);
            $item = $mission_items[$i - 1] ?? [];
        @endphp
        <div class="card border mb-3">
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col-md-4">
                        <x-icon-picker name="mission_items[{{ $i }}][icon]" :value="$item['icon'] ?? ''" label="{{ __('Icon') }}" />
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            {{ Form::label('mission_items[' . $i . '][title]', __('Title'), ['class' => 'form-label']) }}<x-required></x-required>
                            {{ Form::text('mission_items[' . $i . '][title]', $item['title'] ?? '', ['class' => 'form-control', 'placeholder' => __('Enter title'), 'required']) }}
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            {{ Form::label('mission_items[' . $i . '][description]', __('Description'), ['class' => 'form-label']) }}<x-required></x-required>
                            {{ Form::textarea('mission_items[' . $i . '][description]', $item['description'] ?? '', ['class' => 'form-control', 'rows' => 1, 'placeholder' => __('Enter description'), 'required']) }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endfor
</div>

<div class="row">
    <div class="col-12">
        <div class="text-end">
            <input class="btn btn-primary" type="submit" value="{{ __('Save Changes') }}">
        </div>
    </div>
</div>
{{ Form::close() }}
