{{ Form::open(['route' => 'mobileservice.about-setup.story.store', 'method' => 'post', 'enctype' => 'multipart/form-data', 'class' => 'needs-validation', 'novalidate']) }}
<div class="row">
    <div class="col-md-12">
        <div class="form-group">
            {{ Form::label('story_title', __('Title'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::text('story_title', $settings['story_title'] ?? '', ['class' => 'form-control', 'placeholder' => __('Enter title'), 'required']) }}
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="form-group">
            {{ Form::label('story_description', __('Description'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::textarea('story_description', $settings['story_description'] ?? '', ['class' => 'form-control', 'rows' => 4, 'placeholder' => __('Enter description'), 'required']) }}
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            <label class="form-label">{{ __('Image') }}</label>@if (empty($settings['story_image']))<x-required></x-required>@endif
            <input type="file" name="story_image" class="form-control mb-2" accept="image/*"
                onchange="previewImage(this)" @if (empty($settings['story_image'])) required @endif>
            @php
                $story_image = $settings['story_image'] ?? '';
                if (isset($story_image) && $story_image != '' && check_file($story_image)) {
                    $story_image_path = get_file($story_image);
                } else {
                    $story_image_path = asset('packages/workdo/MobileServiceManagement/src/Resources/assets/images/defualt.png');
                }
            @endphp
            <div class="image-preview" @if (isset($settings['story_image']) && $settings['story_image']) style="display:block;" @else style="display:none;" @endif>
                <img src="{{ $story_image_path }}" alt="{{ __('Preview') }}"
                    style="max-width:100px;max-height:100px;border:1px solid #ddd;border-radius:4px;">
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-12">
        <div class="text-end">
            <input class="btn btn-primary" type="submit" value="{{ __('Save Changes') }}">
        </div>
    </div>
</div>
{{ Form::close() }}
