@extends('layouts.main')

@section('page-title')
    {{ __('Theme Setup') }}
@endsection

@section('page-breadcrumb')
    {{ __('System Setup') }}, {{ __('Theme Setup') }}
@endsection

@section('content')
    <div class="row">
        <div class="col-sm-12">
            @include('mobile-service-management::theme-setup.sections')

            <div class="card mt-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5>{{ __('Contact Us Page') }}</h5>
                    <div class="d-flex align-items-center">
                        <span class="me-2">{{ __('On/Off') }}:</span>
                        <div class="form-check form-switch custom-switch-v1">
                            <input type="hidden" name="is_contact_page_active" value="off">
                            <input type="checkbox" class="form-check-input input-primary section-toggle"
                                name="is_contact_page_active" id="is_contact_page_active"
                                {{ !empty($settings['is_contact_page_active']) && $settings['is_contact_page_active'] == 'on' ? 'checked="checked"' : '' }}>
                        </div>
                    </div>
                </div>
            </div>
            
            @include('mobile-service-management::theme-setup.contact-setup.info')
            @include('mobile-service-management::theme-setup.contact-setup.social')
            @include('mobile-service-management::theme-setup.contact-setup.map')
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        // Section toggle functionality
        $(document).ready(function() {
            $('.section-toggle').on('change', function() {
                var checkbox = $(this);
                var checkboxName = checkbox.attr('name');
                var checkboxStatus = checkbox.is(':checked') ? 'on' : 'off';

                $.ajax({
                    url: '{{ route('mobileservice.theme-setup.toggle') }}',
                    method: 'POST',
                    data: {
                        [checkboxName]: checkboxStatus,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        toastrs('success', response.success, 'success');
                    },
                    error: function(xhr) {
                        let message = xhr.responseJSON?.error || 'Something went wrong!';
                        toastrs('Error', message, 'error');
                    }
                });
            });
        });
    </script>
@endpush
