{{ Form::open(['route' => 'mobileservice.home-setup.about.store', 'method' => 'post', 'enctype' => 'multipart/form-data', 'class' => 'needs-validation', 'novalidate']) }}
<div class="row">
    <div class="col-md-12">
        <div class="form-group">
            {{ Form::label('about_title', __('Title'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::text('about_title', $settings['about_title'] ?? '', ['class' => 'form-control', 'placeholder' => __('Enter title'), 'required']) }}
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="form-group">
            {{ Form::label('about_description', __('Description'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::textarea('about_description', $settings['about_description'] ?? '', ['class' => 'form-control', 'rows' => 3, 'placeholder' => __('Enter description'), 'required']) }}
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            <label class="form-label">{{ __('Image') }}</label>@if (empty($settings['about_image']))<x-required></x-required>@endif
            <input type="file" name="about_image" class="form-control mb-2" accept="image/*"
                onchange="previewImage(this)" @if (empty($settings['about_image'])) required @endif>
             @php
                $about_image = $settings['about_image'] ?? '';
                if (isset($about_image) && $about_image != '' && check_file($about_image)) {
                    $about_image_path = get_file($about_image);
                } else{
                    $about_image_path = asset('packages/workdo/MobileServiceManagement/src/Resources/assets/images/defualt.png');
                }
            @endphp
            <div class="image-preview" @if (isset($settings['about_image']) && $settings['about_image']) style="display:block;" @else style="display:none;" @endif>
                <img src="{{ $about_image_path }}" alt="{{ __('Preview') }}"
                    style="max-width:100px;max-height:100px;border:1px solid #ddd;border-radius:4px;">
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            {{ Form::label('about_image_text', __('Image Text'), ['class' => 'form-label']) }}
            {{ Form::text('about_image_text', $settings['about_image_text'] ?? '', ['class' => 'form-control', 'placeholder' => __('Enter image text')]) }}
        </div>
    </div>
</div>

<div class="border rounded p-3 mb-4">
    <div class="repeater feature-repeater" id="facility-repeater">
        <div class="d-flex gap-2 justify-content-between align-items-center mb-3">
            <h5 class="mb-0">{{ __('Facility & Features') }}</h5>
            <button type="button" data-repeater-create class="btn btn-primary btn-sm">
                <i class="ti ti-plus"></i>
            </button>
        </div>
        <div data-repeater-list="facility_features">
            <div data-repeater-item class="card border mb-3">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-11">
                            <div class="form-group">
                                <label class="form-label">{{ __('Title') }}</label>
                                <input type="text" name="feature" class="form-control" placeholder="{{ __('Enter title') }}" required>
                            </div>
                        </div>
                        <div class="col-md-1 text-center">
                            <button type="button" class="btn btn-danger btn-sm" data-repeater-delete>
                                <i class="ti ti-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="text-end">
            <input class="btn btn-primary" type="submit" value="{{ __('Save Changes') }}">
        </div>
    </div>
</div>
{{ Form::close() }}

@push('scripts')
    <script src="{{ asset('js/jquery.repeater.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            var repeater = $('.feature-repeater').repeater({
                initEmpty: true,
                defaultValues: {
                    'feature': ''
                },
                show: function() {
                    $(this).slideDown();
                },
                hide: function(deleteElement) {
                    $(this).slideUp(deleteElement);
                }
            });

            var facilityData = {!! json_encode(json_decode($settings['facility_features'] ?? '[]', true) ?: []) !!};

            if (!facilityData || facilityData.length === 0) {
                repeater.setList([{
                    feature: ''
                }]);
            } else {
                repeater.setList(facilityData);
            }
        });
    </script>
@endpush
