<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Route;
use Workdo\MobileServiceManagement\Http\Controllers\MobileServiceBrandController;
use Workdo\MobileServiceManagement\Http\Controllers\MobileServiceCategoryController;
use Workdo\MobileServiceManagement\Http\Controllers\MobileServiceContactController;
use Workdo\MobileServiceManagement\Http\Controllers\MobileServiceContractController;
use Workdo\MobileServiceManagement\Http\Controllers\MobileServiceController;
use Workdo\MobileServiceManagement\Http\Controllers\MobileServiceDashboardController;
use Workdo\MobileServiceManagement\Http\Controllers\MobileServiceFrontendController;
use Workdo\MobileServiceManagement\Http\Controllers\MobileServiceHistoryController;
use Workdo\MobileServiceManagement\Http\Controllers\MobileServicePendingRequestController;
use Workdo\MobileServiceManagement\Http\Controllers\MobileServicePolicyController;
use Workdo\MobileServiceManagement\Http\Controllers\MobileServiceRequestController;
use Workdo\MobileServiceManagement\Http\Controllers\MobileServiceReviewController;
use Workdo\MobileServiceManagement\Http\Controllers\MobileServiceThemeSettingController;
use Workdo\MobileServiceManagement\Http\Controllers\MobileServiceTrackingStatusController;
use Workdo\MobileServiceManagement\Http\Controllers\PartsController;

Route::group(['middleware' => ['web', 'auth', 'verified', 'PlanModuleCheck:MobileServiceManagement']], function () {

    Route::get('dashboard/mobile-service', [MobileServiceDashboardController::class, 'index'])->name('mobileservice.dashboard');

    Route::prefix('mobile-service')->group(function () {

        // THEME SETUP ROUTES
        Route::prefix('theme-setup')->group(function () {
            // toggle for all sections & page on/off
            Route::post('toggle', [MobileServiceThemeSettingController::class, 'toggle'])->name('mobileservice.theme-setup.toggle');

            // SITE SETTINGS
            Route::prefix('site-settings')->group(function () {
                Route::get('/', [MobileServiceThemeSettingController::class, 'siteSettingsIndex'])->name('mobileservice.site-setup.index');
                Route::post('/', [MobileServiceThemeSettingController::class, 'siteSettingsStore'])->name('mobileservice.site-setup.store');
            });

            // HOME PAGE SETUP
            Route::prefix('home-setup')->group(function () {
                Route::get('/', [MobileServiceThemeSettingController::class, 'homeSetupIndex'])->name('mobileservice.home-setup.index');
                Route::post('banner', [MobileServiceThemeSettingController::class, 'bannerStore'])->name('mobileservice.home-setup.banner.store');
                Route::post('tracking', [MobileServiceThemeSettingController::class, 'trackingStore'])->name('mobileservice.home-setup.tracking.store');
                Route::post('expertise', [MobileServiceThemeSettingController::class, 'expertiseStore'])->name('mobileservice.home-setup.expertise.store');
                Route::post('about', [MobileServiceThemeSettingController::class, 'aboutStore'])->name('mobileservice.home-setup.about.store');
                Route::post('testimonials', [MobileServiceThemeSettingController::class, 'testimonialsStore'])->name('mobileservice.home-setup.testimonials.store');
                Route::post('cta', [MobileServiceThemeSettingController::class, 'ctaStore'])->name('mobileservice.home-setup.cta.store');
            });

            // ABOUT PAGE SETUP
            Route::prefix('about-setup')->group(function () {
                Route::get('/', [MobileServiceThemeSettingController::class, 'aboutSetupIndex'])->name('mobileservice.about-setup.index');
                Route::post('story', [MobileServiceThemeSettingController::class, 'aboutStoryStore'])->name('mobileservice.about-setup.story.store');
                Route::post('mission', [MobileServiceThemeSettingController::class, 'aboutMissionStore'])->name('mobileservice.about-setup.mission.store');
                Route::post('team', [MobileServiceThemeSettingController::class, 'aboutTeamStore'])->name('mobileservice.about-setup.team.store');
                Route::post('cta', [MobileServiceThemeSettingController::class, 'aboutCtaStore'])->name('mobileservice.about-setup.cta.store');
            });

            // CONTACT PAGE SETUP
            Route::prefix('contact-setup')->group(function () {
                Route::get('/', [MobileServiceThemeSettingController::class, 'contactSetupIndex'])->name('mobileservice.contact-setup.index');
                Route::post('info', [MobileServiceThemeSettingController::class, 'contactInfoStore'])->name('mobileservice.contact-setup.info.store');
                Route::post('social', [MobileServiceThemeSettingController::class, 'contactSocialStore'])->name('mobileservice.contact-setup.social.store');
                Route::post('map', [MobileServiceThemeSettingController::class, 'contactMapStore'])->name('mobileservice.contact-setup.map.store');
            });

            // FAQ & CUSTOM PAGES SETUP
            Route::prefix('faq-custom-setup')->group(function () {
                Route::get('/', [MobileServiceThemeSettingController::class, 'faqCustomSetupIndex'])->name('mobileservice.faq-custom-setup.index');
                Route::post('FAQ', [MobileServiceThemeSettingController::class, 'faqStore'])->name('mobileservice.faq-custom-setup.faq.store');
                Route::get('create', [MobileServiceThemeSettingController::class, 'customPageCreate'])->name('mobileservice.faq-custom-setup.custom-pages.create');
                Route::post('store', [MobileServiceThemeSettingController::class, 'customPageStore'])->name('mobileservice.faq-custom-setup.custom-pages.store');
                Route::get('edit/{id}', [MobileServiceThemeSettingController::class, 'customPageEdit'])->name('mobileservice.faq-custom-setup.custom-pages.edit');
                Route::put('update/{id}', [MobileServiceThemeSettingController::class, 'customPageUpdate'])->name('mobileservice.faq-custom-setup.custom-pages.update');
                Route::delete('delete/{id}', [MobileServiceThemeSettingController::class, 'customPageDestroy'])->name('mobileservice.faq-custom-setup.custom-pages.destroy');
            });
        });

        // SERVICE SETUP ROUTES
        Route::prefix('service-setup')->group(function () {
            // Service Category
            Route::prefix('service-category')->group(function () {
                Route::get('/', [MobileServiceCategoryController::class, 'index'])->name('mobileservice.service-category.index');
                Route::get('create', [MobileServiceCategoryController::class, 'create'])->name('mobileservice.service-category.create');
                Route::post('store', [MobileServiceCategoryController::class, 'store'])->name('mobileservice.service-category.store');
                Route::get('edit/{categoryId}', [MobileServiceCategoryController::class, 'edit'])->name('mobileservice.service-category.edit');
                Route::post('update/{categoryId}', [MobileServiceCategoryController::class, 'update'])->name('mobileservice.service-category.update');
                Route::delete('delete/{categoryId}', [MobileServiceCategoryController::class, 'destroy'])->name('mobileservice.service-category.delete');
            });

            // Device Brand
            Route::prefix('device-brand')->group(function () {
                Route::get('/', [MobileServiceBrandController::class, 'index'])->name('mobileservice.brands.index');
                Route::get('create', [MobileServiceBrandController::class, 'create'])->name('mobileservice.brands.create');
                Route::post('store', [MobileServiceBrandController::class, 'store'])->name('mobileservice.brands.store');
                Route::get('edit/{id}', [MobileServiceBrandController::class, 'edit'])->name('mobileservice.brands.edit');
                Route::post('update/{id}', [MobileServiceBrandController::class, 'update'])->name('mobileservice.brands.update');
                Route::delete('delete/{id}', [MobileServiceBrandController::class, 'destroy'])->name('mobileservice.brands.delete');
            });

            // Tracking Status
            Route::prefix('tracking-status')->group(function () {
                Route::get('/', [MobileServiceTrackingStatusController::class, 'index'])->name('mobileservice.tracking-status.index');
                Route::get('create', [MobileServiceTrackingStatusController::class, 'create'])->name('mobileservice.tracking-status.create');
                Route::post('store', [MobileServiceTrackingStatusController::class, 'store'])->name('mobileservice.tracking-status.store');
                Route::get('edit/{trackingStatusId}', [MobileServiceTrackingStatusController::class, 'edit'])->name('mobileservice.tracking-status.edit');
                Route::post('update/{trackingStatusId}', [MobileServiceTrackingStatusController::class, 'update'])->name('mobileservice.tracking-status.update');
                Route::delete('delete/{trackingStatusId}', [MobileServiceTrackingStatusController::class, 'destroy'])->name('mobileservice.tracking-status.delete');
                Route::post('order-update', [MobileServiceTrackingStatusController::class, 'orderUpdate'])->name('mobileservice.tracking-status.order-update');
            });
        });

        // Pending Requests
        Route::prefix('pending-request')->group(function () {
            Route::get('/', [MobileServicePendingRequestController::class, 'index'])->name('mobileservice.pending-request.index');
            Route::get('show/{serviceId}', [MobileServicePendingRequestController::class, 'show'])->name('mobileservice.pending-request.show');
            Route::delete('delete/{serviceId}', [MobileServicePendingRequestController::class, 'destroy'])->name('mobileservice.pending-request.destroy');
            Route::get('accept/{serviceId}', [MobileServicePendingRequestController::class, 'acceptPendingRequest'])->name('mobileservice.pending-request.accept');
            Route::get('reject/{serviceId}', [MobileServicePendingRequestController::class, 'rejectPendingRequest'])->name('mobileservice.pending-request.reject');
        });

        // Service Request
        Route::prefix('service-request')->group(function () {
            Route::get('/', [MobileServiceRequestController::class, 'index'])->name('mobileservice.service-request.index');
            Route::get('create', [MobileServiceRequestController::class, 'create'])->name('mobileservice.service-request.create');
            Route::post('store', [MobileServiceRequestController::class, 'store'])->name('mobileservice.service-request.store');
            Route::get('show/{serviceId}', [MobileServiceRequestController::class, 'show'])->name('mobileservice.service-request.show');
            Route::get('edit/{serviceId}', [MobileServiceRequestController::class, 'edit'])->name('mobileservice.service-request.edit');
            Route::post('update/{serviceId}', [MobileServiceRequestController::class, 'update'])->name('mobileservice.service-request.update');
            Route::delete('delete/{serviceId}', [MobileServiceRequestController::class, 'destroy'])->name('mobileservice.service-request.destroy');
            Route::delete('attachment-delete/{serviceId}', [MobileServiceRequestController::class, 'destroyAttachment'])->name('mobileservice.service-request.attachment-destroy');
            Route::post('trackingStatus-update/{serviceId}', [MobileServiceRequestController::class, 'updateTrackingStatus'])->name('mobileservice.service-request.trackingStatus-update');
            Route::get('end/{serviceId}', [MobileServiceRequestController::class, 'endRequest'])->name('mobileservice.service-request.end');
            Route::get('technician/{serviceId}', [MobileServiceRequestController::class, 'assignTechnicianCreate'])->name('mobileservice.service-request.assign-technician.create');
            Route::post('technician/{serviceId}', [MobileServiceRequestController::class, 'assignTechnicianStore'])->name('mobileservice.service-request.assign-technician.store');
        });

        // Service History
        Route::get('service-history', [MobileServiceHistoryController::class, 'index'])->name('mobileservice.service-history.index');

        // Parts
        Route::any('parts/details', [PartsController::class, 'getPartsDetails'])->name('mobileservice.parts.details');

        // Mobile Services
        Route::prefix('services')->group(function () {
            Route::get('/', [MobileServiceController::class, 'index'])->name('mobileservice.services.index');
            Route::get('create', [MobileServiceController::class, 'create'])->name('mobileservice.services.create');
            Route::post('store', [MobileServiceController::class, 'store'])->name('mobileservice.services.store');
            Route::get('{id}', [MobileServiceController::class, 'show'])->name('mobileservice.services.show');
            Route::get('edit/{id}', [MobileServiceController::class, 'edit'])->name('mobileservice.services.edit');
            Route::post('update/{id}', [MobileServiceController::class, 'update'])->name('mobileservice.services.update');
            Route::delete('delete/{id}', [MobileServiceController::class, 'destroy'])->name('mobileservice.services.destroy');
        });

        // Contact Messages
        Route::prefix('contacts')->group(function () {
            Route::get('/', [MobileServiceContactController::class, 'index'])->name('mobileservice.contacts.index');
            Route::get('{id}/description', [MobileServiceContactController::class, 'description'])->name('mobileservice.contacts.description');
            Route::delete('{id}', [MobileServiceContactController::class, 'destroy'])->name('mobileservice.contacts.destroy');
        });

        // Customer Reviews
        Route::prefix('reviews')->group(function () {
            Route::get('/', [MobileServiceReviewController::class, 'index'])->name('mobileservice.reviews.index');
            Route::get('{id}/review', [MobileServiceReviewController::class, 'review'])->name('mobileservice.reviews.review');
            Route::delete('delete/{id}', [MobileServiceReviewController::class, 'destroy'])->name('mobileservice.reviews.destroy');
        });
    });

    // Service contract
    Route::resource('mobileservice-contract', MobileServiceContractController::class)->except('show');
    Route::get('mobileservice-contract/{id}/description', [MobileServiceContractController::class, 'viewcontract'])->name('mobileservice-contract.description');

    // SLA policy
    Route::resource('mobileservice-policy', MobileServicePolicyController::class);
    Route::get('mobileservice-policy/{id}/description', [MobileServicePolicyController::class, 'viewpolicy'])->name('mobileservice-policy.description');
});

// Frontend Routes
Route::middleware(['web', 'mobileServiceManagementSetLocale'])->group(function () {
    Route::prefix('{workspaceSlug}/mobile-service')->group(function () {
        Route::get('/', [MobileServiceFrontendController::class, 'index'])->name('mobileservice.frontend.index');
        Route::get('lang-change/{key}', [MobileServiceFrontendController::class, 'langChange'])->name('mobileservice.frontend.lang-change');
        Route::get('services', [MobileServiceFrontendController::class, 'services'])->name('mobileservice.frontend.services');
        Route::get('service/{id}', [MobileServiceFrontendController::class, 'serviceDetails'])->name('mobileservice.frontend.service-details');
        Route::post('review', [MobileServiceFrontendController::class, 'reviewStore'])->name('mobileservice.frontend.review.store');
        Route::get('about', [MobileServiceFrontendController::class, 'about'])->name('mobileservice.frontend.about');
        Route::get('contact', [MobileServiceFrontendController::class, 'contact'])->name('mobileservice.frontend.contact');
        Route::post('contact', [MobileServiceFrontendController::class, 'contactStore'])->name('mobileservice.frontend.contact.store');
        Route::get('faq', [MobileServiceFrontendController::class, 'faq'])->name('mobileservice.frontend.faq');
        Route::get('page/{slug}', [MobileServiceFrontendController::class, 'customPage'])->name('mobileservice.frontend.custom-page');
        Route::get('booking', [MobileServiceFrontendController::class, 'booking'])->name('mobileservice.frontend.booking');
        Route::post('booking', [MobileServiceFrontendController::class, 'bookingStore'])->name('mobileservice.frontend.booking.store');
        Route::any('track/booking-request', [MobileServiceFrontendController::class, 'trackBookingRequest'])->name('mobileservice.frontend.track.booking-request');
    });
});
