<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasTable('mobile_service_requests') && !Schema::hasColumn('mobile_service_requests', 'is_approve')) {
            Schema::table('mobile_service_requests', function (Blueprint $table) {
                $table->integer('is_approve')->nullable()->after('attachment');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasTable('mobile_service_requests') && Schema::hasColumn('mobile_service_requests', 'is_approve')) {
            Schema::table('mobile_service_requests', function (Blueprint $table) {
                $table->dropColumn('is_approve');
            });
        }
    }
};
