<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('mobile_service_policies')) {
            Schema::create('mobile_service_policies', function (Blueprint $table) {
                $table->id();
                $table->string('policy_name')->nullable();
                $table->string('description')->nullable();
                $table->time('response_time')->nullable();
                $table->time('resolution_time')->nullable();
                $table->integer('workspace')->nullable();
                $table->integer('created_by')->default(0);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mobile_service_policies');
    }
};
