<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('mobile_service_theme_settings')) {
            Schema::create('mobile_service_theme_settings', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('name');
                $table->longtext('value')->nullable();
                $table->integer('workspace')->default(0);
                $table->integer('created_by')->default(0);
                $table->timestamps();

                $table->unique(['name', 'workspace', 'created_by']);
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mobile_service_theme_settings');
    }
};
