<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasTable('mobile_service_requests')) {
            // Add new columns
            if (!Schema::hasColumns('mobile_service_requests', ['mobile_service_id', 'device_brand', 'address', 'special_requests'])) {
                Schema::table('mobile_service_requests', function (Blueprint $table) {
                    $table->text('address')->nullable()->after('mobile_no');
                    $table->unsignedBigInteger('mobile_service_id')->after('priority');
                    $table->unsignedBigInteger('device_brand')->after('mobile_service_id');
                    $table->text('special_requests')->nullable()->after('description');
                });
            }

            // dropped columns
            if (Schema::hasColumns('mobile_service_requests', ['mobile_company', 'mobile_name'])) {
                Schema::table('mobile_service_requests', function (Blueprint $table) {
                    $table->dropColumn(['mobile_company', 'mobile_name']);
                });
            }

            // Make attachment nullable for existing users
            if (Schema::hasColumn('mobile_service_requests', 'attachment')) {
                Schema::table('mobile_service_requests', function (Blueprint $table) {
                    $table->longtext('attachment')->nullable()->change();
                });
            }

            // Update existing priority values
            if (Schema::hasColumn('mobile_service_requests', 'priority')) {
                DB::table('mobile_service_requests')->update([
                    'priority' => DB::raw("
                        CASE
                            WHEN priority = 'low' THEN 'standard'
                            WHEN priority = 'medium' THEN 'priority'
                            WHEN priority = 'high' THEN 'emergency'
                            ELSE priority
                        END
                    ")
                ]);
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasTable('mobile_service_requests')) {
            // droup new columen droup
            if (Schema::hasColumns('mobile_service_requests', ['mobile_service_id', 'device_brand', 'address', 'special_requests'])) {
                Schema::table('mobile_service_requests', function (Blueprint $table) {
                    $table->dropColumn(['mobile_service_id', 'device_brand', 'address', 'special_requests']);
                });
            }

            // add old column
            if (!Schema::hasColumns('mobile_service_requests', ['mobile_company', 'mobile_name'])) {
                Schema::table('mobile_service_requests', function (Blueprint $table) {
                    $table->string('mobile_company')->after('mobile_no');
                    $table->string('mobile_name')->after('mobile_company');
                });
            }
        }
    }
};
