<?php

namespace Workdo\MobileServiceManagement\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use App\Models\EmailTemplate;
use App\Models\EmailTemplateLang;

class EmailTemplateTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        $emailTemplate   = [
            'New Mobile Service Request',
            'Service Request Accept',
            'Service Request Reject',
        ];
        $defaultTemplate = [
            'New Mobile Service Request' => [
                'subject'   => 'New Mobile Service Request',
                'variables' => '{
                    "App Url": "app_url",
                    "App Name": "app_name",
                    "Company Name": "company_name",
                    "Service ID": "service_id",
                    "Tracking URL": "tracking_url"
                  }',
                'lang'      => [
                    'ar' => '<p>مرحبًا,&nbsp;<br />مرحبا بك في {app_name}</p>
                    <p><strong>معرف الخدمة</strong>: {service_id}<br /><strong>عنوان URL للتتبع</strong> : {tracking_url}</p>
                    <p>{app_url}</p>
                    <p>شكرًا,<br />{app_name}</p>',
                    'da' => '<p>Hej,&nbsp;<br />Velkommen til {app_name}</p>
                    <p><strong>Service-id</strong>: {service_id}<br /><strong>Sporings-URL</strong> : {tracking_url}</p>
                    <p>{app_url}</p>
                    <p>Tak,<br />{app_name}</p>',
                    'de' => '<p>Hallo,&nbsp;<br />Willkommen zu {app_name}</p>
                    <p><strong>Dienst-ID </strong>: {service_id}<br /><strong>Tracking-URL</strong> : {tracking_url}</p>
                    <p>{app_url}</p>
                    <p>Danke,<br />{app_name}</p>',
                    'en' => '<p>Hello,&nbsp;<br />Welcome to {app_name}</p>
                    <p><strong>Service ID </strong>: {service_id}<br /><strong>Tracking URL</strong> : {tracking_url}</p>
                    <p>{app_url}</p>
                    <p>Thanks,<br />{app_name}</p>',
                    'es' => '<p>Hola,&nbsp;<br />Bienvenido a {app_name}</p>
                    <p><strong>Identificación del servicio</strong>: {service_id}<br /><strong>URL de seguimiento</strong> : {tracking_url}</p>
                    <p>{app_url}</p>
                    <p>Gracias,<br />{app_name}</p>',
                    'fr' => '<p>Bonjour,&nbsp;<br />Bienvenue à {app_name}</p>
                    <p><strong>Numéro de service</strong>: {service_id}<br /><strong>URL de suivi</strong> : {tracking_url}</p>
                    <p>{app_url}</p>
                    <p>Merci,<br />{app_name}</p>',
                    'it' => '<p>Ciao,&nbsp;<br />Welcome to {app_name}</p>
                    <p><strong>ID servizio</strong>: {service_id}<br /><strong>URL di monitoraggio</strong> : {tracking_url}</p>
                    <p>{app_url}</p>
                    <p>Grazie,<br />{app_name}</p>',
                    'ja' => '<p>こんにちは,&nbsp;<br />Welcome to {app_name}</p>
                    <p><strong>サービスID </strong>: {service_id}<br /><strong>トラッキングURL</strong> : {tracking_url}</p>
                    <p>{app_url}</p>
                    <p>ありがとう,<br />{app_name}</p>',
                    'nl' => '<p>Hallo,&nbsp;<br />Welkom bij {app_name}</p>
                    <p><strong>Service-ID </strong>: {service_id}<br /><strong>Tracking-URL</strong> : {tracking_url}</p>
                    <p>{app_url}</p>
                    <p>Bedankt,<br />{app_name}</p>',
                    'pl' => '<p>Cześć,&nbsp;<br />Witamy w {app_name}</p>
                    <p><strong>Identyfikator usługi </strong>: {service_id}<br /><strong>Adres URL śledzenia</strong> : {tracking_url}</p>
                    <p>{app_url}</p>
                    <p>Dzięki,<br />{app_name}</p>',
                    'ru' => '<p>Привет,&nbsp;<br />Добро пожаловать в {app_name}</p>
                    <p><strong>Идентификатор услуги</strong>: {service_id}<br /><strong>URL отслеживания</strong> : {tracking_url}</p>
                    <p>{app_url}</p>
                    <p>Спасибо,<br />{app_name}</p>',
                    'pt' => '<p>Olá,&nbsp;<br />Welcome to {app_name}</p>
                    <p><strong>ID do serviço</strong>: {service_id}<br /><strong>URL de rastreamento</strong> : {tracking_url}</p>
                    <p>{app_url}</p>
                    <p>Obrigado,<br />{app_name}</p>',
                    'tr' => '<p>Merhaba,&nbsp;<br />Welcome to {app_name}</p>
                    <p><strong>Hizmet Kimliği</strong>: {service_id}<br /><strong>İzleme URLsi</strong> : {tracking_url}</p>
                    <p>{app_url}</p>
                    <p>Teşekkürler,<br />{app_name}</p>',
                ],
            ],
            'Service Request Accept'     => [
                'subject'   => 'Service Request Accept',
                'variables' => '{
                    "App Url": "app_url",
                    "App Name": "app_name",
                    "Company Name": "company_name",
                    "Service ID": "service_id",
                    "Tracking URL": "tracking_url"
                  }',
                'lang'      => [
                    'ar' => '<p>مرحبًا,&nbsp;<br />مرحبا بك في {app_name}</p>
                    <p>معرف طلب الخدمة الخاص بك<strong> {service_id} </strong> تم قبوله.</p><br/>
                    <p>يمكنك متابعة طلبك من هنا : {tracking_url} </p>
                    <p>{app_url}</p>
                    <p>شكرًا,<br />{app_name}</p>',

                    'da' => '<p>Hej,&nbsp;<br />Velkommen til {app_name}</p>
                    <p>Dit serviceanmodnings-id <strong> {service_id} </strong> Er blevet accepteret.</p><br/>
                    <p>Du kan spore din anmodning herfra : {tracking_url} </p>
                    <p>{app_url}</p>
                    <p>Tak,<br />{app_name}</p>',

                    'de' => '<p>Hallo,&nbsp;<br />Willkommen zu {app_name}</p>
                    <p>Ihre Serviceanfrage-ID <strong> {service_id} </strong> Wurde akzeptiert.</p><br/>
                    <p>Hier können Sie Ihre Anfrage verfolgen : {tracking_url} </p>
                    <p>{app_url}</p>
                    <p>Danke,<br />{app_name}</p>',

                    'en' => '<p>Hello,&nbsp;<br />Welcome to {app_name}</p>
                    <p>Your Service Request Id <strong> {service_id} </strong> Has Been Accepted.</p><br/>
                    <p>You Can Track Your Request From Here : {tracking_url} </p>
                    <p>{app_url}</p>
                    <p>Thanks,<br />{app_name}</p>',

                    'es' => '<p>Hola,&nbsp;<br />Bienvenido a {app_name}</p>
                    <p>Su ID de solicitud de servicio <strong> {service_id} </strong> Ha sido aceptado.</p><br/>
                    <p>Puede realizar un seguimiento de su solicitud desde aquí : {tracking_url} </p>
                    <p>{app_url}</p>
                    <p>Gracias,<br />{app_name}</p>',

                    'fr' => '<p>Bonjour,&nbsp;<br />Bienvenue à {app_name}</p>
                    <p>Votre identifiant de demande de service <strong> {service_id} </strong> A été accepté.</p><br/>
                    <p>Vous pouvez suivre votre demande à partir dici : {tracking_url} </p>
                    <p>{app_url}</p>
                    <p>Merci,<br />{app_name}</p>',

                    'it' => '<p>Ciao,&nbsp;<br />Welcome to {app_name}</p>
                    <p>Il tuo ID richiesta di servizio <strong> {service_id} </strong> È stato accettato.</p><br/>
                    <p>Puoi monitorare la tua richiesta da qui : {tracking_url} </p>
                    <p>{app_url}</p>
                    <p>Grazie,<br />{app_name}</p>',

                    'ja' => '<p>こんにちは,&nbsp;<br />Welcome to {app_name}</p>
                    <p>サービスリクエストID  <strong> {service_id} </strong> 受け入れられました.</p><br/>
                    <p>ここからリクエストを追跡できます : {tracking_url} </p>
                    <p>{app_url}</p>
                    <p>ありがとう,<br />{app_name}</p>',

                    'nl' => '<p>Hallo,&nbsp;<br />Welkom bij {app_name}</p>
                    <p>Uw serviceverzoek-ID <strong> {service_id} </strong> Is geaccepteerd.</p><br/>
                    <p>U kunt uw verzoek vanaf hier volgen : {tracking_url} </p>
                    <p>{app_url}</p>
                    <p>Bedankt,<br />{app_name}</p>',

                    'pl' => '<p>Cześć,&nbsp;<br />Witamy w {app_name}</p>
                    <p>Twój identyfikator zgłoszenia serwisowego <strong> {service_id} </strong> Został zaakceptowany.</p><br/>
                    <p>Tutaj możesz śledzić swoje żądanie : {tracking_url} </p>
                    <p>{app_url}</p>
                    <p>Dzięki,<br />{app_name}</p>',

                    'ru' => '<p>Привет,&nbsp;<br />Добро пожаловать в {app_name}</p>
                    <p>Ваш идентификатор запроса на обслуживание <strong> {service_id} </strong> Был принят.</p><br/>
                    <p>Вы можете отслеживать свой запрос здесь : {tracking_url} </p>
                    <p>{app_url}</p>
                    <p>Спасибо,<br />{app_name}</p>',

                    'pt' => '<p>Olá,&nbsp;<br />Welcome to {app_name}</p>
                    <p>Seu ID de solicitação de serviço <strong> {service_id} </strong> Foi aceito.</p><br/>
                    <p>Você pode acompanhar sua solicitação aqui : {tracking_url} </p>
                    <p>{app_url}</p>
                    <p>Obrigado,<br />{app_name}</p>',

                    'tr' => '<p>Merhaba,&nbsp;<br />Welcome to {app_name}</p>
                    <p>Hizmet Talebi Kimliğiniz <strong> {service_id} </strong> Kabul edildi.</p><br/>
                    <p>Talebinizi Buradan Takip Edebilirsiniz : {tracking_url} </p>
                    <p>{app_url}</p>
                    <p>Teşekkürler,<br />{app_name}</p>',
                ],
            ],
            'Service Request Reject'     => [
                'subject'   => 'Service Request Reject',
                'variables' => '{
                    "App Url": "app_url",
                    "App Name": "app_name",
                    "Company Name": "company_name",
                    "Service ID": "service_id"
                  }',
                'lang'      => [
                    'ar' => '<p>مرحبًا,&nbsp;<br />مرحبا بك في {app_name}</p>
                    <p>معرف طلب الخدمة الخاص بك<strong> {service_id} </strong> وقد رفض.</p><br/>
                    <p>{app_url}</p>
                    <p>شكرًا,<br />{app_name}</p>',

                    'da' => '<p>Hej,&nbsp;<br />Velkommen til {app_name}</p>
                    <p>Dit serviceanmodnings-id <strong> {service_id} </strong> Er blevet afvist.</p><br/>
                    <p>{app_url}</p>
                    <p>Tak,<br />{app_name}</p>',

                    'de' => '<p>Hallo,&nbsp;<br />Willkommen zu {app_name}</p>
                    <p>Ihre Serviceanfrage-ID <strong> {service_id} </strong> Wurde abgelehnt.</p><br/>
                    <p>{app_url}</p>
                    <p>Danke,<br />{app_name}</p>',

                    'en' => '<p>Hello,&nbsp;<br />Welcome to {app_name}</p>
                    <p>Your Service Request Id <strong> {service_id} </strong> Has Been Rejected.</p><br/>
                    <p>{app_url}</p>
                    <p>Thanks,<br />{app_name}</p>',

                    'es' => '<p>Hola,&nbsp;<br />Bienvenido a {app_name}</p>
                    <p>Su ID de solicitud de servicio <strong> {service_id} </strong> Ha sido rechazado.</p><br/>
                    <p>{app_url}</p>
                    <p>Gracias,<br />{app_name}</p>',

                    'fr' => '<p>Bonjour,&nbsp;<br />Bienvenue à {app_name}</p>
                    <p>Votre identifiant de demande de service <strong> {service_id} </strong> A été refusé.</p><br/>
                    <p>{app_url}</p>
                    <p>Merci,<br />{app_name}</p>',

                    'it' => '<p>Ciao,&nbsp;<br />Welcome to {app_name}</p>
                    <p>Il tuo ID richiesta di servizio <strong> {service_id} </strong> È stato respinto.</p><br/>
                    <p>{app_url}</p>
                    <p>Grazie,<br />{app_name}</p>',

                    'ja' => '<p>こんにちは,&nbsp;<br />Welcome to {app_name}</p>
                    <p>サービスリクエストID  <strong> {service_id} </strong> 拒否されました.</p><br/>
                    <p>{app_url}</p>
                    <p>ありがとう,<br />{app_name}</p>',

                    'nl' => '<p>Hallo,&nbsp;<br />Welkom bij {app_name}</p>
                    <p>Uw serviceverzoek-ID <strong> {service_id} </strong> Is afgewezen.</p><br/>
                    <p>{app_url}</p>
                    <p>Bedankt,<br />{app_name}</p>',

                    'pl' => '<p>Cześć,&nbsp;<br />Witamy w {app_name}</p>
                    <p>Twój identyfikator zgłoszenia serwisowego <strong> {service_id} </strong> Została odrzucona.</p><br/>
                    <p>{app_url}</p>
                    <p>Dzięki,<br />{app_name}</p>',

                    'ru' => '<p>Привет,&nbsp;<br />Добро пожаловать в {app_name}</p>
                    <p>Ваш идентификатор запроса на обслуживание <strong> {service_id} </strong> Была отвергнута.</p><br/>
                    <p>{app_url}</p>
                    <p>Спасибо,<br />{app_name}</p>',

                    'pt' => '<p>Olá,&nbsp;<br />Welcome to {app_name}</p>
                    <p>Seu ID de solicitação de serviço <strong> {service_id} </strong> Foi rejeitado.</p><br/>
                    <p>{app_url}</p>
                    <p>Obrigado,<br />{app_name}</p>',

                    'tr' => '<p>Merhaba,&nbsp;<br />Welcome to {app_name}</p>
                    <p>Hizmet Talebi Kimliğiniz <strong> {service_id} </strong> Reddedildi.</p><br/>
                    <p>{app_url}</p>
                    <p>Teşekkürler,<br />{app_name}</p>',
                ],
            ]
        ];
        foreach ($emailTemplate as $eTemp) {
            $table = EmailTemplate::where('name', $eTemp)->where('module_name', 'MobileServiceManagement')->exists();
            if (!$table) {
                $emailtemplate = EmailTemplate::create(
                    [
                        'name'         => $eTemp,
                        'from'         => 'MobileServiceManagement',
                        'module_name'  => 'MobileServiceManagement',
                        'created_by'   => 1,
                        'workspace_id' => 0
                    ]
                );
                foreach ($defaultTemplate[$eTemp]['lang'] as $lang => $content) {
                    EmailTemplateLang::create(
                        [
                            'parent_id' => $emailtemplate->id,
                            'lang'      => $lang,
                            'subject'   => $defaultTemplate[$eTemp]['subject'],
                            'variables' => $defaultTemplate[$eTemp]['variables'],
                            'content'   => $content,
                        ]
                    );
                }
            }
        }
    }
}
