<?php

namespace Workdo\MobileServiceManagement\Events;

use Illuminate\Queue\SerializesModels;

class UpdateMobileServiceRequest
{
    use SerializesModels;

    public $request;
    public $serviceReqData;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct($request, $serviceReqData)
    {
        $this->request = $request;
        $this->serviceReqData = $serviceReqData;
    }

    /**
     * Get the channels the event should be broadcast on.
     *
     * @return array
     */
    public function broadcastOn()
    {
        return [];
    }
}
