<?php

namespace Workdo\MobileServiceManagement\Listeners;

use App\Events\CompanyMenuEvent;

class CompanyMenuListener
{
    /**
     * Handle the event.
     */
    public function handle(CompanyMenuEvent $event): void
    {
        $module = 'MobileServiceManagement';
        $menu   = $event->menu;

        $menu->add([
            'category'   => 'General',
            'title'      => __('Mobile Service Dashboard'),
            'icon'       => '',
            'name'       => 'mobileservice-dashboard',
            'parent'     => 'dashboard',
            'order'      => 235,
            'ignore_if'  => [],
            'depend_on'  => [],
            'route'      => 'mobileservice.dashboard',
            'module'     => $module,
            'permission' => 'mobileservice dashboard manage'
        ]);

        $menu->add([
            'category'   => 'Operations',
            'title'      => __('Mobile Service'),
            'icon'       => 'menu',
            'name'       => 'mobileservice',
            'parent'     => null,
            'order'      => 711,
            'ignore_if'  => [],
            'depend_on'  => [],
            'route'      => '',
            'module'     => $module,
            'permission' => 'mobileservice manage'
        ]);

        $menu->add([
            'category'   => 'Operations',
            'title'      => __('Pending Request'),
            'icon'       => '',
            'name'       => 'pendingrequest',
            'parent'     => 'mobileservice',
            'order'      => 10,
            'ignore_if'  => [],
            'depend_on'  => [],
            'route'      => 'mobileservice.pending-request.index',
            'module'     => $module,
            'permission' => 'mobileservice_pendingrequest manage'
        ]);

        $menu->add([
            'category'   => 'Operations',
            'title'      => __('Service Request'),
            'icon'       => '',
            'name'       => 'servicerequest',
            'parent'     => 'mobileservice',
            'order'      => 20,
            'ignore_if'  => [],
            'depend_on'  => [],
            'route'      => 'mobileservice.service-request.index',
            'module'     => $module,
            'permission' => 'mobileservice_servicerequest manage'
        ]);

        $menu->add([
            'category'   => 'Operations',
            'title'      => __('Service History'),
            'icon'       => '',
            'name'       => 'mobileservicehistory',
            'parent'     => 'mobileservice',
            'order'      => 30,
            'ignore_if'  => [],
            'depend_on'  => [],
            'route'      => 'mobileservice.service-history.index',
            'module'     => $module,
            'permission' => 'mobileservice_history manage'
        ]);

        $menu->add([
            'category'   => 'Operations',
            'title'      => __('Services'),
            'icon'       => '',
            'name'       => 'mobileservices',
            'parent'     => 'mobileservice',
            'order'      => 40,
            'ignore_if'  => [],
            'depend_on'  => [],
            'route'      => 'mobileservice.services.index',
            'module'     => $module,
            'permission' => 'mobileservice_service manage'
        ]);

        $menu->add([
            'category'   => 'Operations',
            'title'      => __('Customer Reviews'),
            'icon'       => '',
            'name'       => 'mobilereviews',
            'parent'     => 'mobileservice',
            'order'      => 50,
            'ignore_if'  => [],
            'depend_on'  => [],
            'route'      => 'mobileservice.reviews.index',
            'module'     => $module,
            'permission' => 'mobileservice_review manage'
        ]);

        $menu->add([
            'category'   => 'Operations',
            'title'      => __('Contact Messages'),
            'icon'       => '',
            'name'       => 'mobilecontacts',
            'parent'     => 'mobileservice',
            'order'      => 60,
            'ignore_if'  => [],
            'depend_on'  => [],
            'route'      => 'mobileservice.contacts.index',
            'module'     => $module,
            'permission' => 'mobileservice_contact manage'
        ]);

        $menu->add([
            'category'   => 'Operations',
            'title'      => __('Service Contracts'),
            'icon'       => '',
            'name'       => 'mobileservicecontracts',
            'parent'     => 'mobileservice',
            'order'      => 70,
            'ignore_if'  => [],
            'depend_on'  => [],
            'route'      => 'mobileservice-contract.index',
            'module'     => $module,
            'permission' => 'mobileservice_contracts manage'
        ]);

        $menu->add([
            'category'   => 'Operations',
            'title'      => __('SLA Policy'),
            'icon'       => '',
            'name'       => 'mobileservicepolicy',
            'parent'     => 'mobileservice',
            'order'      => 80,
            'ignore_if'  => [],
            'depend_on'  => [],
            'route'      => 'mobileservice-policy.index',
            'module'     => $module,
            'permission' => 'mobileservice_policy manage'
        ]);

        $menu->add([
            'category'   => 'Operations',
            'title'      => __('System Setup'),
            'icon'       => '',
            'name'       => 'mobilesystemsetup',
            'parent'     => 'mobileservice',
            'order'      => 90,
            'ignore_if'  => [],
            'depend_on'  => [],
            'route'      => '',
            'module'     => $module,
            'permission' => 'mobileservice setup manage'
        ]);

        $menu->add([
            'category'   => 'Operations',
            'title'      => __('Service Setup'),
            'icon'       => '',
            'name'       => 'mobileservicesetup',
            'parent'     => 'mobilesystemsetup',
            'order'      => 10,
            'ignore_if'  => [],
            'depend_on'  => [],
            'route'      => 'mobileservice.service-category.index',
            'module'     => $module,
            'permission' => 'mobileservice service setup manage'
        ]);

        $menu->add([
            'category'   => 'Operations',
            'title'      => __('Theme Setup'),
            'icon'       => '',
            'name'       => 'mobilethemesetup',
            'parent'     => 'mobilesystemsetup',
            'order'      => 20,
            'ignore_if'  => [],
            'depend_on'  => [],
            'route'      => 'mobileservice.site-setup.index',
            'module'     => $module,
            'permission' => 'mobileservice theme setup manage'
        ]);

    }
}
