@extends('mobile-service-management::frontend.layout')

@section('title', __('Service Details'))

@section('content')

    @include('mobile-service-management::frontend.partials.page-header', [
        'badge' => __('Service Details'),
        'title' => __('Book Service Details'),
        'breadcrumbs' => [__('Service Details')],
    ])

    <section class="py-12 lg:py-16 bg-gray-50">
        <div class="md:container mx-auto w-full px-4">
            <!-- Order Info Strip -->
            <div class="flex flex-wrap items-center justify-between bg-white p-4 mb-3 md:mb-6 rounded-lg border border-gray-200">
                <div>
                    <h2 class="text-base md:text-2xl font-bold text-black mb-1">{{ __('Service ID') . ': ' . $service->service_id }}</h2>
                    <p class="text-gray-900 mb-3 md:mb-0 text-sm">{{ $service->created_at->format('F j, Y \a\t g:i A') }}</p>
                </div>
                @if(!empty($service->getServiceTrackingStatus))
                    <span class="border border-primary rounded-lg px-4 py-2 text-sm font-medium">
                        <i class="{{ $service->getServiceTrackingStatus->icon_name }} me-1"></i>{{ ucfirst($service->getServiceTrackingStatus->status_name) }}
                    </span>
                @endif
            </div>

            <!-- Main Grid Layout -->
            <div class="grid lg:grid-cols-4 gap-3 md:gap-6">
                <!-- Left Column -->
                <div class="lg:col-span-1">
                    <div class="bg-white p-4 md:p-6 rounded-lg border border-gray-200">
                        <h2 class="text-lg font-bold text-secondary mb-4 border-b-2 border-primary pb-2">{{ __('Tracking') }}</h2>
                        <div class="space-y-4">
                            @foreach($allTrackingStatus as $tracking)
                            @php
                                $isActive = $currentTrackingStatus->has($tracking->id);
                                $date = $currentTrackingStatus[$tracking->id] ?? null;
                            @endphp
                            <div class="tracking-step rounded-lg border border-gray-200 p-4 {{ $isActive ? 'active' : '' }}">
                                <div class="text-gray-900 font-semibold text-sm {{ $isActive ? 'mb-1' : '' }}">
                                    <i class="{{ $isActive ? 'fas fa-check' : $tracking->icon_name }} me-2"></i>{{ $tracking->status_name ?? '-' }}
                                </div>
                                @if ($date)
                                    <div class="text-xs text-black">{{  \Carbon\Carbon::parse($date)->format('M j, Y - g:i A') }}</div>
                                @endif
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>

                <!-- Center Column - Main Details -->
                <div class="lg:col-span-2">
                    <!-- Device Card -->
                    <div class="bg-white p-3 md:p-6 mb-3 md:mb-6 border border-gray-200 rounded-lg">
                        <div class="flex items-start gap-4">
                            <div class="w-12 h-12 rounded-lg md:w-16 md:h-16 bg-primary text-white flex items-center justify-center text-2xl">
                                <i class="{{ $service->service->icon ?? 'fas fa-mobile-alt' }}"></i>
                            </div>
                            <div class="flex-1">
                                <h3 class="text-xl font-bold text-secondary mb-2">{{ $service->deviceBrand->name ?? '' }} {{ $service->mobile_model }}</h3>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-2 text-sm">
                                    <div><span class="text-gray-600">{{ __('Priority') }}:</span> <span class="font-medium">{{ __(ucfirst($service->priority)) }}</span></div>
                                    <div><span class="text-gray-600">{{ __('Service') }}:</span> <span class="font-medium text-red-600">{{ $service->service->name ?? __('Other service') }}</span></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Service Issue -->
                    <div class="bg-white p-3 mb-3 md:mb-6 md:p-6 border border-gray-200 rounded-lg">
                        <h3 class="text-lg font-bold text-secondary mb-3">{{ __('Issue Description') }}</h3>
                        <div class="bg-gray-50 p-2 border-s-4 rounded-lg border-secondary">
                            <p class="text-sm text-gray-700">{{ $service->description }}</p>
                        </div>
                    </div>

                    <!-- Technician Details -->
                    @if($service->getAssignTechnician)
                        <div class="bg-white p-3 md:p-6 border border-gray-200 rounded-lg">
                            <h3 class="text-lg font-bold text-secondary mb-4 border-b-2 border-primary pb-2">{{ __('Technician Information') }}</h3>
                            <div class="space-y-3">
                                <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                                    <span class="text-gray-900">{{ __('Technician Name') }}</span>
                                    <span class="font-bold text-primary">{{  $service->getAssignTechnician->getTechnicianDetails->name ?? __('Not Assigned') }}</span>
                                </div>
                                <div class="flex items-center justify-between p-3 bg-gray-50 rounded-lg">
                                    <span class="text-gray-900">{{ __('Estimated Date') }}</span>
                                    <span class="font-bold text-primary">{{ $service->getAssignTechnician->completion_date }}</span>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>


                <!-- Right Column -->
                <div class="lg:col-span-1">
                    <!-- Customer Info -->
                    <div class="bg-white mb-3 md:mb-6 p-3 md:p-6 border border-gray-200 rounded-lg">
                        <h3 class="text-lg font-bold text-secondary mb-4 border-b-2 border-primary pb-2">{{ __('Customer') }}</h3>
                        <div class="space-y-3">
                            <div>
                                <div class="font-bold text-gray-800">{{ $service->customer_name }}</div>
                                @if($service->address)
                                    <div class="text-sm text-gray-600">{{ $service->address }}</div>
                                @endif
                            </div>
                            <div class="pt-2 border-t border-gray-200">
                                <div class="text-sm text-gray-600 mb-1 md:mb-3">
                                    <i class="fas fa-phone text-primary me-2"></i>{{ $service->mobile_no }}
                                </div>
                                <div class="text-sm text-gray-600">
                                    <i class="fas fa-envelope text-primary me-2"></i>{{ $service->email }}
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($service->special_requests)
                        <div class="bg-white mb-3 md:mb-6 p-3 md:p-6 border border-gray-200 rounded-lg">
                            <h3 class="ext-lg font-bold text-secondary mb-4 border-b-2 border-primary pb-2">{{ __('Special Instructions') }}</h3>
                            <p class="text-sm text-gray-700">{{ $service->special_requests }}</p>
                        </div>
                    @endif

                    <!-- Invoice Status -->
                    @if($service->getInvoiceStatus)
                        <div class="bg-white p-3 md:p-6 border border-gray-200 rounded-lg">
                            <h3 class="text-lg font-bold text-secondary mb-4 border-b-2 border-primary pb-2">{{ __('Invoice') }}</h3>
                            <div class="space-y-2">
                                <div class="text-center">
                                    <div class="text-sm text-gray-600 mb-1">{{ __('Payment Status') }}</div>
                                    <div class="text-secondary font-bold">
                                        <i class="fas fa-check-circle me-1"></i>{{ \App\Models\Invoice::$statues[$service->getInvoiceStatus->status] ?? __('Not Generated') }}
                                    </div>
                                    <a href="{{ route('pay.invoice', encrypt($service->getInvoiceStatus->id)) }}"
                                        target="_blank" rel="noopener noreferrer" class="w-full btn transition-all mt-4">
                                        <i class="ti ti-credit-card me-2"></i> {{ __('Show & Pay Invoice') }}
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </section>
@endsection
