@extends('mobile-service-management::frontend.layout')

@section('title', __('Contact'))

@section('content')
    @include('mobile-service-management::frontend.partials.page-header', [
        'badge' => __('Contact'),
        'title' => __('Contact Us'),
        'breadcrumbs' => [__('Contact')],
    ])

    @php
        // Location Section
        $hasLocation = !empty($settings['contact_address']) && !empty($settings['location_title']);

        // Service Hours Section
        $serviceHours = json_decode($settings['service_hours'] ?? '[]', true);
        $hasValidHours = false;
        if (!empty($serviceHours)) {
            foreach ($serviceHours as $hour) {
                if (!empty($hour['day']) && (($hour['status'] == 'open' && !empty($hour['start_time']) && !empty($hour['end_time'])) || $hour['status'] == 'closed')) {
                    $hasValidHours = true;
                    break;
                }
            }
        }
        $hasServiceHours = $hasValidHours && !empty($settings['hours_title']);

        // Contact Section
        $hasContact = (!empty($settings['contact_phone']) || !empty($settings['contact_email']) || !empty($settings['contact_emergency'])) && !empty($settings['contact_title']);

        // Contact Info Section
        $hasContactInfo = $hasLocation || $hasServiceHours || $hasContact;

        // Social Links Section
        $socialLinks = json_decode($settings['social_links'] ?? '[]', true);
        $hasValidSocialLinks = array_filter($socialLinks, function ($social) {
            return !empty($social['link']) && !empty($social['icon']);
        });
        $hasSocialLinks = !empty($hasValidSocialLinks);

        // Map Section
        $hasMapSection = (($settings['is_map_section_active'] ?? 'off') == 'on' && !empty($settings['map_iframe']) && !empty($settings['map_title']) && !empty($settings['map_description']));

        // All Sections
        $hasAnyContactSection = $hasContactInfo || $hasSocialLinks || $hasMapSection;
    @endphp

    @if ($hasAnyContactSection)
        <!-- Contact Section -->
        <section class="py-10 lg:py-16 bg-tertiary">
            <div class="md:container mx-auto px-4 w-full">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-10">

                    <!-- Contact Form -->
                    <div class="bg-white py-6 px-4 md:p-8 rounded-lg border border-gray-200">
                        <h3 class="text-xl md:text-2xl font-bold text-secondary title-font mb-4 md:mb-6">{{ __('Get in touch') }}</h3>

                        <!-- alerts -->
                        @include('mobile-service-management::frontend.partials.alerts')

                        <form action="{{ route('mobileservice.frontend.contact.store', $workspaceSlug) }}" method="POST" class="space-y-4">
                            @csrf
                            <div>
                                <label class="block text-sm font-medium text-black mb-1">{{ __('Your Name') }} *</label>
                                <input type="text" name="name" required
                                    class="w-full px-4 py-3 border border-gray-300 rounded-lg"
                                    placeholder="{{ __('Enter your name') }}" value="{{ old('name') }}">
                            </div>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                                <div>
                                    <label class="block text-sm font-medium text-black mb-1">{{ __('Email Address') }} *</label>
                                    <input type="email" name="email" required
                                        class="w-full px-4 py-3 border border-gray-300 rounded-lg"
                                        placeholder="{{ __('Enter email address') }}" value="{{ old('email') }}">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-black mb-1">{{ __('Phone Number') }} *</label>
                                    <input type="tel" required pattern="^\+\d{1,3}\d{9,13}$" name="phone"
                                        class="w-full px-4 py-3 border border-gray-300 rounded-lg"
                                        placeholder="{{ __('Enter phone number') }}" value="{{ old('phone') }}">
                                    <div class="mt-1 text-sm text-red-600">{{ __('Please use with country code. (ex. +91)') }}</div>
                                </div>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-black mb-1">{{ __('Subject') }} *</label>
                                <select name="subject" required class="w-full px-4 py-3 border border-gray-300 rounded-lg">
                                    <option value="">{{ __('Select a subject') }}</option>
                                    <option value="general" {{ old('subject') == 'general' ? 'selected' : '' }}>{{ __('General Inquiry') }}</option>
                                    <option value="service" {{ old('subject') == 'service' ? 'selected' : '' }}>{{ __('Service Question') }}</option>
                                    <option value="quote" {{ old('subject') == 'quote' ? 'selected' : '' }}>{{ __('Request Quote') }}</option>
                                    <option value="support" {{ old('subject') == 'support' ? 'selected' : '' }}>{{ __('Technical Support') }}</option>
                                    <option value="complaint" {{ old('subject') == 'complaint' ? 'selected' : '' }}>{{ __('Complaint') }}</option>
                                    <option value="other" {{ old('subject') == 'other' ? 'selected' : '' }}>{{ __('Other') }}</option>
                                </select>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-black mb-1">{{ __('Message') }} *</label>
                                <textarea name="message" required rows="5" class="w-full px-4 py-3 border border-gray-300 rounded-lg"
                                    placeholder="{{ __('Enter message here') }}">{{ old('message') }}</textarea>
                            </div>

                            <button type="submit" class="w-full btn transition-all">
                                <i class="fas fa-paper-plane"></i> {{ __('Send Message') }}
                            </button>
                        </form>
                    </div>

                    <!-- Contact Info -->
                    <div class="space-y-6">
                        @if ($hasContactInfo)
                            <div class="bg-white py-6 px-4 md:p-8 rounded-lg border border-gray-200 ">
                                <h3 class="text-xl md:text-2xl font-bold text-secondary title-font mb-4 md:mb-6">{{ __('Contact Information') }}</h3>

                                <div class="space-y-6">
                                    @if ($hasLocation)
                                        <div class="flex items-start">
                                            <div class="w-8 h-8 md:w-10 md:h-10 flex items-center justify-center contact-icon bg-secondary text-white me-4 rounded-lg flex-shrink-0">
                                                <i class="fas fa-map-marker-alt text-lg md:text-xl"></i>
                                            </div>
                                            <div>
                                                <h4 class="font-bold text-lg text-secondary mb-1">{{ $settings['location_title'] }}</h4>
                                                <p class="text-gray-600">{!! $settings['contact_address'] !!}</p>
                                            </div>
                                        </div>
                                    @endif

                                    @if ($hasServiceHours)
                                        @php
                                            $groupedHours = [];
                                            $currentGroup = null;
                                            $dayShort = [
                                                'Monday' => 'Mon',
                                                'Tuesday' => 'Tue',
                                                'Wednesday' => 'Wed',
                                                'Thursday' => 'Thu',
                                                'Friday' => 'Fri',
                                                'Saturday' => 'Sat',
                                                'Sunday' => 'Sun',
                                            ];

                                            foreach ($serviceHours as $hour) {
                                                if (empty($hour['day'])) {
                                                    continue;
                                                }

                                                $timeString = ($hour['status'] ?? 'open') == 'closed'
                                                        ? __('Closed')
                                                        : (!empty($hour['start_time']) && !empty($hour['end_time']) ? date('g:i A', strtotime($hour['start_time'])) . ' - ' . date('g:i A', strtotime($hour['end_time'])) : '');

                                                if ($currentGroup && $currentGroup['time'] === $timeString) {
                                                    $currentGroup['days'][] = $hour['day'];
                                                } else {
                                                    if ($currentGroup) {
                                                        $groupedHours[] = $currentGroup;
                                                    }
                                                    $currentGroup = ['days' => [$hour['day']], 'time' => $timeString];
                                                }
                                            }

                                            if ($currentGroup) {
                                                $groupedHours[] = $currentGroup;
                                            }
                                        @endphp
                                        <div class="flex items-start">
                                            <div class="w-8 h-8 md:w-10 md:h-10 flex items-center justify-center contact-icon bg-secondary text-white me-4 rounded-lg flex-shrink-0">
                                                <i class="fas fa-clock text-lg md:text-xl"></i>
                                            </div>
                                            <div>
                                                <h4 class="font-bold text-lg text-secondary mb-1">{{ $settings['hours_title'] }}</h4>
                                                <p class="text-gray-600">
                                                    @foreach ($groupedHours as $group)
                                                        @if (!empty($group['time']))
                                                            @if (count($group['days']) > 1 && $group['days'][0] == 'Monday' && end($group['days']) == 'Friday')
                                                                Mon-Fri: {{ $group['time'] }}<br>
                                                            @elseif(count($group['days']) > 1)
                                                                {{ $dayShort[$group['days'][0]] }}-{{ $dayShort[end($group['days'])] }}: {{ $group['time'] }}<br>
                                                            @else
                                                                {{ $group['days'][0] }}: {{ $group['time'] }}<br>
                                                            @endif
                                                        @endif
                                                    @endforeach
                                                </p>
                                            </div>
                                        </div>
                                    @endif

                                    @if ($hasContact)
                                        <div class="flex items-start">
                                            <div class="w-8 h-8 md:w-10 md:h-10 flex items-center justify-center contact-icon bg-secondary text-white me-4 rounded-lg flex-shrink-0">
                                                <i class="fas fa-phone text-lg md:text-xl"></i>
                                            </div>
                                            <div>
                                                <h4 class="font-bold text-lg text-secondary mb-1">{{ $settings['contact_title'] }}</h4>
                                                <p class="text-gray-600">
                                                    @if (!empty($settings['contact_phone']))
                                                        {{ __('Phone') }}: {{ $settings['contact_phone'] }}<br>
                                                    @endif
                                                    @if (!empty($settings['contact_email']))
                                                        {{ __('Email') }}: {{ $settings['contact_email'] }}<br>
                                                    @endif
                                                    @if (!empty($settings['contact_emergency']))
                                                        {{ __('Emergency') }}: {{ $settings['contact_emergency'] }}
                                                    @endif
                                                </p>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endif

                        <!-- Social Media -->
                        @if ($hasSocialLinks)
                            <div class="bg-white py-6 px-4 md:p-8 rounded-lg  border border-gray-200">
                                <h3 class="text-xl md:text-2xl font-bold text-secondary title-font mb-4 md:mb-6">{{ __('Follow Us') }}</h3>
                                <div class="flex gap-3">
                                    @foreach ($hasValidSocialLinks as $social)
                                        <a href="{{ $social['link'] }}" target="_blank"
                                            class="w-8 h-8 md:w-10 md:h-10 rounded-lg bg-secondary text-white  flex items-center justify-center text-secondary hover:bg-primary hover:text-white transition-colors">
                                            <i class="{{ $social['icon'] }}"></i>
                                        </a>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </section>

        <!-- Map Section -->
        @if ($hasMapSection)
            <section class="py-10 lg:py-16 bg-white">
                <div class="md:container mx-auto px-4 w-full">
                    <div class="text-center mb-6 md:mb-10">
                        <span class="inline-flex items-center bg-white text-secondary px-4 py-1.5 rounded-full text-xs uppercase tracking-wider font-semibold mb-4 shadow-sm border border-gray-200 mx-auto">
                            <i class="fas fa-circle text-primary text-xxs me-2"></i>
                            {{ __('Our Repair Center') }}
                        </span>
                        <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-secondary title-font mb-4">{{ $settings['map_title'] }}</h2>
                        <p class="lg:text-lg text-gray-600 max-w-3xl mx-auto">{{ $settings['map_description'] }}</p>
                    </div>

                    <div class="rounded-2xl overflow-hidden shadow-xl">
                        <div class="map-placeholder h-96 flex items-center justify-center">
                            {!! $settings['map_iframe'] !!}
                        </div>
                    </div>
                </div>
            </section>
        @endif

    @else
        @include('mobile-service-management::frontend.partials.not-configured')
    @endif
@endsection
