@extends('mobile-service-management::frontend.layout')

@section('title', __('FAQ'))

@section('content')

    @include('mobile-service-management::frontend.partials.page-header', [
        'badge' => __('FAQ'),
        'title' => __('Frequently Asked Questions'),
        'breadcrumbs' => [__('FAQ')],
    ])

    @php
        // FAQ Section
        $faqData = json_decode($settings['faq_data'] ?? '[]', true);
        $hasValidFaqs = array_filter($faqData, function ($faq) {
            return !empty($faq['question']) && !empty($faq['answer']);
        });
        $hasFAQ = (($settings['is_faq_page_active'] ?? 'off') == 'on' && !empty($hasValidFaqs));
    @endphp

    <!-- FAQ Section -->
    @if ($hasFAQ)
        <section class="py-10 lg:py-16 bg-white">
            <div class="md:container mx-auto px-4 w-full">
                <div class="max-w-3xl mx-auto space-y-4">
                    @foreach ($hasValidFaqs as $index => $faq)
                        <div class="faq-item bg-white rounded-lg overflow-hidden border border-gray-200">
                            <div class="faq-question py-4 px-4 md:px-6 cursor-pointer flex justify-between items-center">
                                <h3 class="font-medium md:text-lg text-secondary">{{ $faq['question'] }}</h3>
                                <i class="fas fa-plus text-primary ms-2 transition-transform duration-300"></i>
                            </div>
                            <div class="faq-answer py-4 px-4 md:px-6 hidden border-t-2 border-gray-100">
                                <p class="text-gray-600">{{ $faq['answer'] }}</p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @else
        @include('mobile-service-management::frontend.partials.not-configured')
    @endif
@endsection
