@extends('mobile-service-management::frontend.layout')

@section('title', __('Home'))

@section('content')
    <!-- Hero Section -->
    @if (($settings['is_banner_section_active'] ?? 'off') == 'on' && !empty($settings['banner_title']) && !empty($settings['banner_description']) && !empty($settings['banner_image']) && check_file($settings['banner_image']))
        <section class="pt-10 pb-16 md:py-24 lg:py-28 relative overflow-hidden">
            <div class="round-blob bg-secondary opacity-10 -z-10 -top-40 -end-40 rotate-animation"></div>
            <div class="round-blob bg-primary opacity-10 -z-10 bottom-0 -start-40 rotate-animation animation-delay-3000"></div>

            <div class="md:container mx-auto px-4 w-full">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 md:gap-12 lg:gap-16 items-center">
                    <div class="text-center md:text-start">
                        @if (!empty($settings['banner_subtitle']))
                            <span class="inline-flex items-center bg-white text-secondary px-4 py-1.5 rounded-full text-xs uppercase tracking-wider font-semibold mb-4 md:mb-6 shadow-sm border border-gray-200">
                                <i class="fas fa-circle text-primary text-xxs me-2"></i>
                                {{ $settings['banner_subtitle'] }}
                            </span>
                        @endif
                        <h2 class="text-3xl sm:text-4xl md:text-4xl lg:text-5xl xl:text-6xl font-bold text-secondary title-font mb-4 lg:mb-6 leading-tight">{{ $settings['banner_title'] }}</h2>
                        <p class="lg:text-lg text-gray-700 mb-4 lg:mb-8 max-w-xl mx-auto lg:mx-0">{{ $settings['banner_description'] }}</p>

                        <div class="flex flex-wrap gap-3 sm:gap-4 justify-center md:justify-start banner-btn-wrp">
                            <a href="{{ route('mobileservice.frontend.booking', $workspaceSlug) }}" class="btn transition-all">
                                <i class="fas fa-tools group-hover:animate-pulse"></i>
                                <span>{{ __('Book Repair') }}</span>
                            </a>
                            @if (!empty($settings['contact_phone']))
                                <a href="tel:{{ $settings['contact_phone'] }}" class="btn btn-transparent transition-all">
                                    <i class="fas fa-phone group-hover:animate-pulse"></i>
                                    <span>{{ $settings['contact_phone'] }}</span>
                                </a>
                            @endif
                        </div>

                        <div class="mt-6 md:mt-8 lg:mt-12 flex flex-wrap justify-center md:justify-start gap-3 lg:gap-4">
                            @if(isset($reviewStats) && $reviewStats['total_reviews'] > 0)
                                <div class="flex items-center space-x-2 bg-white px-4 py-2 rounded-lg shadow-sm border border-gray-200">
                                    <div class="w-3 h-3 bg-yellow-500 rounded-lg flex items-center justify-center">
                                        <i class="fas fa-star text-white text-[6px]"></i>
                                    </div>
                                    <span class="text-sm font-medium">{{ number_format($reviewStats['average_rating'], 1) }} ({{ $reviewStats['total_reviews'] }}+ {{ __('reviews') }})</span>
                                </div>
                            @endif
                            @if (($settings['is_expertise_section_active'] ?? 'off') == 'on' && !empty($settings['expertise_title']) && !empty($settings['expertise_description']) && !empty($expertiseServices) && count($expertiseServices) > 0)
                                <div class="flex items-center space-x-2 bg-white px-4 py-2 rounded-lg shadow-sm border border-gray-200">
                                    <div class="w-3 h-3 bg-green-600 rounded-lg flex items-center justify-center">
                                        <i class="fas fa-check text-white text-[6px]"></i>
                                    </div>
                                    <a href="#expertise-section" class="text-sm font-medium hover:text-primary transition-colors">{{ __('Our Expertise') }}</a>
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="relative flex justify-center">
                        <div class="relative w-full">
                            <div class="absolute inset-0 bg-secondary rounded-2xl -rotate-6 shadow-xl hidden md:block"></div>
                            <img src="{{ get_file($settings['banner_image']) }}" alt="{{ __('Banner Image') }}"
                                class="relative rounded-lg shadow-xl w-full h-auto border-4 border-white">
                        </div>

                        @if (!empty($settings['banner_image_text']))
                            <div class="absolute -bottom-6 start-0 bg-secondary text-white px-5 py-2 rounded-lg shadow-lg flex items-center space-x-2">
                                @if (!empty($settings['banner_image_icon']))
                                    <i class="{{ $settings['banner_image_icon'] }} text-primary"></i>
                                @endif
                                <span class="font-medium">{{ $settings['banner_image_text'] }}</span>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </section>
    @endif

    <!-- Tracking Section -->
    <section id="tracking" class="py-10 lg:py-16 bg-secondary overflow-hidden">
        <div class="md:container mx-auto px-4 w-full">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 lg:gap-12 items-center">
                <div class="max-w-2xl mx-auto lg:mx-0">
                    <div class="text-center lg:text-start mb-8">
                        <span class="inline-flex items-center bg-white text-secondary px-4 py-1.5 rounded-full text-xs uppercase font-semibold mb-4 shadow-sm border border-gray-200">
                            <i class="fas fa-circle text-primary text-xxs me-2"></i>
                            {{ __('Service Tracking') }}
                        </span>
                        <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-white title-font mb-4">{{ $settings['tracking_title'] ?? __('Track Your Repair Status') }}</h2>
                        <p class="text-gray-300">{{ $settings['tracking_description'] ?? __('Enter your tracking details to get real-time updates on your device repair') }}</p>
                    </div>

                    <div class="bg-white rounded-lg shadow-lg p-4 md:p-8">
                        <!-- alerts -->
                        @include('mobile-service-management::frontend.partials.alerts')

                        <form action="{{ route('mobileservice.frontend.track.booking-request', $workspaceSlug) }}" method="POST" class="space-y-6">
                            @csrf
                            <div class="grid grid-cols-1 gap-3 md:gap-6">
                                <div>
                                    <label class="block text-sm font-semibold text-secondary mb-2">{{ __('Service ID') }} *</label>
                                    <div class="relative">
                                        <input type="text" name="service_id" placeholder="{{ __('Enter service ID') }}" required
                                            class="w-full px-4 py-3 pe-[35px] border border-gray-300 rounded-lg transition-colors">
                                        <i class="fas fa-hashtag absolute end-3 top-1/2 transform -translate-y-1/2 text-gray-800"></i>
                                    </div>
                                </div>
                                <div>
                                    <label class="block text-sm font-semibold text-secondary mb-2">{{ __('Email Address') }} *</label>
                                    <div class="relative">
                                        <input type="email" name="email" placeholder="{{ __('Enter email address') }}" required
                                            class="w-full px-4 py-3 pe-[35px] border border-gray-300 rounded-lg transition-colors">
                                        <i class="fas fa-envelope absolute end-3 top-1/2 transform -translate-y-1/2 text-gray-800"></i>
                                    </div>
                                </div>
                            </div>

                            <button type="submit" class="btn w-full transition-all">
                                {{ __('Track My Service') }}
                            </button>
                        </form>
                    </div>
                </div>

                <div class="grid grid-cols-1 sm:grid-cols-2 gap-6 lg:gap-8">
                    <div class="text-center p-4 lg:p-6 bg-white bg-opacity-10 rounded-lg backdrop-blur-sm border border-white border-opacity-20">
                        <div class="w-12 h-12 mx-auto mb-4 bg-primary rounded-full flex items-center justify-center">
                            <i class="fas fa-mobile-alt text-white text-xl"></i>
                        </div>
                        <div class="text-3xl lg:text-4xl font-bold mb-2 text-white">
                            <span class="counter" data-target="{{ $trackingStats['completed_requests'] ?? 0 }}">0</span>+
                        </div>
                        <p class="text-sm lg:text-base text-white font-medium">{{ __('Devices Repaired') }}</p>
                    </div>
                    <div class="text-center p-4 lg:p-6 bg-white bg-opacity-10 rounded-lg backdrop-blur-sm border border-white border-opacity-20">
                        <div class="w-12 h-12 mx-auto mb-4 bg-primary rounded-full flex items-center justify-center">
                            <i class="fas fa-heart text-white text-xl"></i>
                        </div>
                        <div class="text-3xl lg:text-4xl font-bold mb-2 text-white">
                            <span class="counter" data-target="{{ $trackingStats['satisfaction_rate'] ?? 0 }}">0</span>%
                        </div>
                        <p class="text-sm lg:text-base text-white font-medium">{{ __('Satisfaction Rate') }}</p>
                    </div>
                    <div class="text-center p-4 lg:p-6 bg-white bg-opacity-10 rounded-lg backdrop-blur-sm border border-white border-opacity-20">
                        <div class="w-12 h-12 mx-auto mb-4 bg-primary rounded-full flex items-center justify-center">
                            <i class="fas fa-star text-white text-xl"></i>
                        </div>
                        <div class="text-3xl lg:text-4xl font-bold mb-2 text-white">
                            <span class="counter" data-target="{{ $trackingStats['five_star_reviews'] ?? 0 }}">0</span>+
                        </div>
                        <p class="text-sm lg:text-base text-white font-medium">{{ __('5-Star Reviews') }}</p>
                    </div>
                    <div class="text-center p-4 lg:p-6 bg-white bg-opacity-10 rounded-lg backdrop-blur-sm border border-white border-opacity-20">
                        <div class="w-12 h-12 mx-auto mb-4 bg-primary rounded-full flex items-center justify-center">
                            <i class="fas fa-cogs text-white text-xl"></i>
                        </div>
                        <div class="text-3xl lg:text-4xl font-bold mb-2 text-white">
                            <span class="counter" data-target="{{ $trackingStats['total_services'] ?? 0 }}">0</span>+
                        </div>
                        <p class="text-sm lg:text-base text-white font-medium">{{ __('Total Services') }}</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Expertise Section -->
    @if (($settings['is_expertise_section_active'] ?? 'off') == 'on' && !empty($settings['expertise_title']) && !empty($settings['expertise_description']) && !empty($expertiseServices) && count($expertiseServices) > 0)
        <section id="expertise-section" class="py-12 lg:py-16 bg-white">
            <div class="md:container mx-auto px-4 w-full">
                <div class="text-center mb-6 md:mb-12">
                    <span class="inline-flex items-center bg-white text-secondary px-4 py-1.5 rounded-full text-xs uppercase tracking-wider font-semibold mb-4 shadow-sm border border-gray-200 mx-auto">
                        <i class="fas fa-circle text-primary text-xxs me-2"></i>
                        {{ __('Our Expertise') }}
                    </span>
                    <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-secondary title-font mb-4">{{ $settings['expertise_title'] }}</h2>
                    <p class="lg:text-lg text-gray-600 max-w-3xl mx-auto">{{ $settings['expertise_description'] }}</p>
                </div>

                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
                    @foreach ($expertiseServices as $service)
                        <div class="service-card flex flex-col bg-white rounded-lg p-4 lg:p-6 border transition-all duration-300 border-t-4 border-secondary">
                            <div class="service-card-top flex-1">
                                <div class="flex items-center mb-4">
                                    <div class="w-12 h-12 lg:w-14 lg:h-14 rounded-lg bg-secondary flex items-center justify-center me-4 shadow-sm">
                                        <i class="{{ $service->icon }} text-white text-2xl"></i>
                                    </div>
                                    <h3 class="text-lg md:text-xl font-bold text-secondary">{{ $service->name }}</h3>
                                </div>
                                <p class="text-gray-600 mb-4 line-clamp-3">
                                    {{ $service->description }}
                                </p>
                            </div>
                            <div class="flex justify-between items-center">
                                <span class="md:text-lg font-bold text-primary">{{ __('From') . ' ' . currency_format_with_sym($service->expected_price, $service->created_by, $service->workspace) }}</span>
                                <a href="{{ route('mobileservice.frontend.service-details', [$workspaceSlug, encrypt($service->id)]) }}"
                                    class="group flex items-center space-x-2 text-secondary hover:text-primary font-medium transition-colors">
                                    <span>{{ __('Details') }}</span>
                                    <i class="fas fa-arrow-right"></i>
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>

                <div class="mt-6 md:mt-10 text-center">
                    <a href="{{ route('mobileservice.frontend.services', $workspaceSlug) }}" class="btn btn-secondary transition-all">
                        {{ __('View All Services') }}
                        <i class="fas fa-arrow-right group-hover:translate-x-1 transition-transform"></i>
                    </a>
                </div>
            </div>
        </section>
    @endif

    <!-- About Section -->
    @if (($settings['is_about_section_active'] ?? 'off') == 'on' && !empty($settings['about_title']) && !empty($settings['about_description']) && !empty($settings['about_image']) && check_file($settings['about_image']))
        <section class="py-12 lg:py-16 bg-tertiary">
            <div class="md:container mx-auto px-4 w-full">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8 md:gap-12 lg:gap-16 items-center">
                    <div class="relative">
                        <div class="relative rounded-2xl overflow-hidden shadow-xl">
                            <img src="{{ get_file($settings['about_image']) }}" alt="{{ __('About Image') }}" class="w-full h-auto">
                        </div>
                        @if (!empty($settings['about_image_text']))
                            <div class="absolute -bottom-6 -end-6 bg-primary text-white px-6 py-4 rounded-lg shadow-lg max-w-xs hidden md:block">
                                <p class="font-medium text-sm">{{ $settings['about_image_text'] }}</p>
                            </div>
                        @endif
                    </div>

                    <div>
                        <span class="inline-flex items-center bg-white text-secondary px-4 py-1.5 rounded-full text-xs uppercase tracking-wider font-semibold mb-4 shadow-sm border border-gray-200">
                            <i class="fas fa-circle text-primary text-xxs me-2"></i>
                            {{ __('Who We Are') }}
                        </span>
                        <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-secondary title-font mb-4">{{ $settings['about_title'] }}</h2>
                        <p class="text-gray-700 mb-4 md:mb-6">{{ $settings['about_description'] }}</p>
                        @php
                            $facilityFeatures = json_decode($settings['facility_features'] ?? '[]', true);
                        @endphp
                        @if (!empty($facilityFeatures))
                            <div class="space-y-4 mb-6 md:mb-8">
                                @foreach ($facilityFeatures as $feature)
                                    @if (!empty($feature['feature']))
                                        <div class="flex items-start gap-4">
                                            <div class="flex-shrink-0">
                                                <div class="w-5 h-5 rounded bg-primary flex items-center justify-center mt-1">
                                                    <i class="fas fa-check text-white text-xs"></i>
                                                </div>
                                            </div>
                                            <p class="text-gray-700">{{ $feature['feature'] }}</p>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        @endif
                        @if(!empty($settings['is_about_page_active']) && $settings['is_about_page_active'] == 'on')
                            <a href="{{ route('mobileservice.frontend.about', $workspaceSlug) }}"
                                class="btn btn-secondary transition-all">
                                {{ __('Learn More About') }}
                                <i class="fas fa-arrow-right group-hover:translate-x-1 transition-transform"></i>
                            </a>
                        @endif
                    </div>
                </div>
            </div>
        </section>
    @endif

    <!-- Testimonials Section -->
    @if (($settings['is_testimonials_section_active'] ?? 'off') == 'on' && !empty($settings['testimonials_title']) && !empty($settings['testimonials_description']) && !empty($approvedReviews) && count($approvedReviews) > 0)
        <section class="py-10 lg:py-16 bg-white">
            <div class="md:container mx-auto px-4 w-full">
                <div class="text-center mb-6 md:mb-10">
                    <span class="inline-flex items-center bg-white text-secondary px-4 py-1.5 rounded-full text-xs uppercase tracking-wider font-semibold mb-4 shadow-sm border border-gray-200 mx-auto">
                        <i class="fas fa-circle text-primary text-xxs me-2"></i>
                        {{ __('Client Testimonials') }}
                    </span>
                    <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-secondary title-font mb-4">{{ $settings['testimonials_title'] }}</h2>
                    <p class="lg:text-lg text-gray-600 max-w-3xl mx-auto">{{ $settings['testimonials_description'] }}</p>
                </div>

                <div class="{{ count($approvedReviews) > 2 ? 'testimonial-slider swiper' : '' }}">
                    <div class="{{ count($approvedReviews) > 2 ? 'swiper-wrapper' : 'grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6 lg:gap-8' }}">
                        @foreach($approvedReviews as $review)
                            <div class="swiper-slide p-1 h-auto">
                                <div class="testimonial-card h-full flex flex-col bg-white rounded-lg p-4 md:p-6 border border-gray-200 transition-shadow">
                                    <div class="testimonial-card-top flex-1">
                                        <div class="flex mb-4 text-yellow-500 space-x-1">
                                            @for($i = 1; $i <= 5; $i++)
                                                <i class="fas fa-star {{ $i <= $review->rating ? '' : 'text-gray-300' }}"></i>
                                            @endfor
                                        </div>
                                        <p class="text-gray-600 mb-4 relative line-clamp-4">
                                            "{{ $review->review }}"
                                        </p>
                                    </div>
                                    <div class="flex items-center">
                                        <div class="w-10 h-10 md:w-12 md:h-12 rounded-full bg-secondary flex items-center justify-center border-2 border-secondary me-4">
                                            <span class="text-white font-semibold text-sm">{{ strtoupper(substr($review->name, 0, 2)) }}</span>
                                        </div>
                                        <div>
                                            <h4 class="font-bold text-secondary">{{ $review->name }}</h4>
                                            <p class="text-gray-500 text-sm">{{ $review->service ? $review->service->name :  __('Other service') }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    @if(count($approvedReviews) > 2)
                        <div class="swiper-button-prev"></div>
                        <div class="swiper-button-next"></div>
                    @endif
                </div>
            </div>
        </section>
    @endif

    <!-- CTA Section -->
    @if (($settings['is_cta_section_active'] ?? 'off') == 'on' && !empty($settings['cta_title']) && !empty($settings['cta_description']))
        <section class="pb-10 lg:pb-16 bg-white">
            <div class="md:container mx-auto px-4 w-full">
                <div class="text-white bg-primary rounded-2xl p-4 md:p-8 lg:p-10 text-center relative overflow-hidden">
                    <div class="absolute -top-10 -end-10 w-32 h-32 rounded-full bg-white bg-opacity-10"></div>
                    <div class="absolute -bottom-10 -start-10 w-40 h-40 rounded-full bg-white bg-opacity-10"></div>
                    <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold title-font mb-4">{{ $settings['cta_title'] }}</h2>
                    <p class="lg:text-lg mb-6 lg:mb-8 max-w-3xl mx-auto">{{ $settings['cta_description'] }}</p>
                    <div class="flex gap-4 justify-center">
                        <a href="{{ route('mobileservice.frontend.booking', $workspaceSlug) }}"
                            class="btn transition-all btn-white">
                            <i class="fas fa-calendar-alt group-hover:animate-pulse"></i>
                            <span>{{ __('Book Appointment') }}</span>
                        </a>
                    </div>
                </div>
            </div>
        </section>
    @endif
@endsection
