<!-- Page Header -->
<section class="relative bg-secondary lg:py-16 py-10 overflow-hidden">
    <div class="absolute inset-0 opacity-10">
        <div class="absolute w-64 h-64 rounded-full bg-primary -top-20 -end-20"></div>
        <div class="absolute w-64 h-64 lg:w-80 lg:h-80 rounded-full bg-primary bottom-0 -start-40"></div>
    </div>

    <div class="md:container w-full mx-auto px-4 relative">
        <div class="text-center max-w-4xl mx-auto">
            @if (isset($badge))
                <span class="inline-flex items-center bg-white text-secondary px-4 py-1.5 rounded-full text-xs uppercase tracking-wider font-semibold md:mb-6 mb-4 shadow-sm border border-gray-200">
                    <i class="fas fa-circle text-primary text-xxs me-2"></i>
                    {{ $badge }}
                </span>
            @endif

            <h2 class="text-2xl md:text-3xl lg:text-5xl font-bold mb-4 lg:mb-6 leading-tight text-white">
                <span class="text-primary">{{ $title }}</span>
            </h2>

            @if (isset($breadcrumbs))
                <ul class="flex flex-wrap justify-center items-center capitalize text-white md:text-base text-sm">
                    <li class="capitalize flex items-center">
                        <a href="{{ route('mobileservice.frontend.index', $workspaceSlug) }}">{{ __('Home') }}</a>
                    </li>
                    @foreach ($breadcrumbs as $breadcrumb)
                        <i class="fas fa-chevron-right mx-2 text-xs rtl:scale-x-[-1] flex items-center mt-1"></i>
                        <li class="capitalize flex items-center">{{ $breadcrumb }}</li>
                    @endforeach
                </ul>
            @endif
        </div>
    </div>
</section>
