@extends('layouts.main')

@section('page-title')
    {{ __('Manage SLA Policies') }}
@endsection

@section('page-breadcrumb')
    {{ __('SLA Policies') }}
@endsection

@push('css')
    @include('layouts.includes.datatable-css')
@endpush

@section('page-action')
    @permission('mobileservice_policy create')
        <a href="#" class="btn btn-sm btn-primary" data-url="{{ route('mobileservice-policy.create') }}" data-size="md"
            data-ajax-popup="true" data-title="{{ __('Create SLA Policy') }}" data-toggle="tooltip" title="{{ __('Create') }}">
            <i class="ti ti-plus"></i>
        </a>
    @endpermission
@endsection

@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        {{ $dataTable->table(['width' => '100%']) }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    @include('layouts.includes.datatable-js')
    {{ $dataTable->scripts() }}
@endpush
