@permission('mobileservice_pendingrequest approve-reject')
    @if ($data->is_approve === null)
        <div class="action-btn me-2">
            <a href="{{ route('mobileservice.pending-request.accept', ['serviceId' => $data->service_id]) }}"
                data-toggle="tooltip" title="{{ __('Accept') }}" class="bg-success btn btn-sm">
                <i class="ti ti-check text-white"></i>
            </a>
        </div>
        <div class="action-btn me-2">
            <a href="{{ route('mobileservice.pending-request.reject', ['serviceId' => $data->service_id]) }}"
                data-toggle="tooltip" title="{{ __('Reject') }}" class="bg-warning btn btn-sm">
                <i class="ti ti-x text-white"></i>
            </a>
        </div>
    @endif
@endpermission

@permission('mobileservice_pendingrequest delete')
    <div class="action-btn">
        <form method="POST" action="{{ route('mobileservice.pending-request.destroy', $data->service_id) }}"
            id="delete-form-{{ $data->service_id }}">
            @csrf
            @method('DELETE')
            <a href="#" class="bg-danger btn btn-sm show_confirm" data-bs-toggle="tooltip" title="{{ __('Delete') }}"
                data-original-title="{{ __('Delete') }}" data-confirm="{{ __('Are You Sure?') }}"
                data-text="{{ __('This action can not be undone. Do you want to continue?') }}"
                data-confirm-yes="delete-form-{{ $data->service_id }}">
                <i class="ti ti-trash text-white"></i>
            </a>
        </form>
    </div>
@endpermission
