@if(isset($data->getInvoiceStatus))
    @permission('invoice show')
        <div class="action-btn me-2">
            <a href="{{ route('invoice.show', \Crypt::encrypt($data->getInvoiceStatus->id)) }}"
                class="mx-3 btn btn-sm align-items-center bg-primary" data-bs-toggle="tooltip"
                title="{{ __('View Invoice') }}">
                <i class="ti ti-file-invoice  text-white"></i>
            </a>
        </div>
    @endpermission
@endif

@permission('mobileservice_servicerequest show')
    @if ($data->is_approve == 1)
        <div class="action-btn me-2">
            <a href="{{ route('mobileservice.service-request.show', ['serviceId' => encrypt($data->service_id)]) }}"
                class="bg-warning btn btn-sm" data-toggle="tooltip" title="{{ __('View') }}">
                <i class="ti ti-eye text-white"></i></a>
        </div>
    @endif
@endpermission

@permission('mobileservice_servicerequest delete')
    <div class="action-btn">
        <form method="POST"
            action="{{ route('mobileservice.service-request.destroy', ['serviceId' => encrypt($data->service_id)]) }}"
            id="delete-form-{{ $data->id }}">
            @csrf
            @method('DELETE')
            <a href="#" class="bg-danger btn btn-sm show_confirm" data-bs-toggle="tooltip" title="{{ __('Delete') }}"
                data-original-title="{{ __('Delete') }}" data-confirm="{{ __('Are You Sure?') }}"
                data-text="{{ __('This action can not be undone. Do you want to continue?') }}"
                data-confirm-yes="delete-form-{{ $data->id }}">
                <i class="ti ti-trash text-white"></i>
            </a>
        </form>
    </div>
@endpermission
