@extends('layouts.main')

@section('page-title')
    {{ __('Manage Services') }}
@endsection

@section('page-breadcrumb')
    {{ __('Services') }}
@endsection

@section('page-action')
    <div>
        @permission('mobileservice_service create')
            <a href="{{ route('mobileservice.services.create') }}" class="btn btn-sm btn-primary" data-toggle="tooltip"
                title="{{ __('Create') }}"><i class="ti ti-plus"></i></a>
        @endpermission
    </div>
@endsection

@push('css')
    @include('layouts.includes.datatable-css')
@endpush

@section('content')
    <div class="col-lg-12 col-md-12 mt-3">
        <div class="card">
            <div class="card-header card-body table-border-style">
                <div class="table-responsive">
                    {{ $dataTable->table(['width' => '100%']) }}
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    @include('layouts.includes.datatable-js')
    {{ $dataTable->scripts() }}
@endpush
