{{ Form::open(['route' => 'mobileservice.about-setup.team.store', 'method' => 'post', 'class' => 'needs-validation', 'novalidate']) }}
<div class="row">
    <div class="col-md-12">
        <div class="form-group">
            {{ Form::label('team_title', __('Title'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::text('team_title', $settings['team_title'] ?? '', ['class' => 'form-control', 'placeholder' => __('Enter title'), 'required']) }}
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="form-group">
            {{ Form::label('team_description', __('Description'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::textarea('team_description', $settings['team_description'] ?? '', ['class' => 'form-control', 'rows' => 3, 'placeholder' => __('Enter description'), 'required']) }}
        </div>
    </div>
</div>

<div class="border rounded p-3 mb-4">
    <div class="repeater team-repeater" id="team-repeater">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">{{ __('Team Members') }}</h5>
            <button type="button" data-repeater-create class="btn btn-primary btn-sm">
                <i class="ti ti-plus"></i>
            </button>
        </div>
        <div data-repeater-list="team_members">
            <div data-repeater-item class="card border mb-3">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-3">
                            <div class="form-group">
                                {{ Form::label('user_id', __('Staff'), ['class' => 'form-label']) }}
                                {{ Form::select('user_id', $staffOptions, '', ['class' => 'form-control', 'required']) }}
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label class="form-label">{{ __('Experience') }}</label>
                                <input type="text" name="experience" class="form-control" placeholder="{{ __('Enter experience') }}">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label class="form-label">{{ __('Position') }}</label>
                                <input type="text" name="position" class="form-control" placeholder="{{ __('Enter position') }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">{{ __('Description') }}</label>
                                <textarea name="description" class="form-control" rows="1" placeholder="{{ __('Enter description') }}"></textarea>
                            </div>
                        </div>
                        <div class="col-md-1 text-center">
                            <button type="button" class="btn btn-danger btn-sm" data-repeater-delete>
                                <i class="ti ti-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="text-end">
            <input class="btn btn-primary" type="submit" value="{{ __('Save Changes') }}">
        </div>
    </div>
</div>
{{ Form::close() }}

@push('scripts')
    <script src="{{ asset('js/jquery.repeater.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            var repeater = $('.team-repeater').repeater({
                initEmpty: true,
                defaultValues: {
                    'user_id': '',
                    'experience': '',
                    'position': '',
                    'description': ''
                },
                show: function() {
                    $(this).slideDown();
                },
                hide: function(deleteElement) {
                    $(this).slideUp(deleteElement);
                }
            });

            var teamData = {!! json_encode(json_decode($settings['team_members'] ?? '[]', true) ?: []) !!};

            if (!teamData || teamData.length === 0) {
                repeater.setList([{
                    user_id: '',
                    position: '',
                    experience: '',
                    description: ''
                }]);
            } else {
                repeater.setList(teamData);
            }
        });
    </script>
@endpush
