<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5>{{ __('Our Repair Center') }}</h5>
        <div class="d-flex align-items-center">
            <span class="me-2">{{ __('On/Off') }}:</span>
            <div class="form-check form-switch custom-switch-v1">
                <input type="hidden" name="is_map_section_active" value="off">
                <input type="checkbox" class="form-check-input input-primary section-toggle" name="is_map_section_active" id="is_map_section_active"
                    {{ !empty($settings['is_map_section_active']) && $settings['is_map_section_active'] == 'on' ? 'checked' : '' }}>
            </div>
        </div>
    </div>
    <div class="card-body">
        {{ Form::open(['route' => 'mobileservice.contact-setup.map.store', 'method' => 'post', 'class' => 'needs-validation', 'novalidate']) }}
        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    {{ Form::label('map_title', __('Title'), ['class' => 'form-label']) }}<x-required></x-required>
                    {{ Form::text('map_title', $settings['map_title'] ?? '', ['class' => 'form-control', 'placeholder' => __('Enter title'), 'required']) }}
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    {{ Form::label('map_description', __('Description'), ['class' => 'form-label']) }}<x-required></x-required>
                    {{ Form::textarea('map_description', $settings['map_description'] ?? '', ['class' => 'form-control', 'rows' => 3, 'placeholder' => __('Enter description'), 'required']) }}
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    {{ Form::label('map_iframe', __('Google Maps Embed Code'), ['class' => 'form-label']) }}<x-required></x-required>
                    {{ Form::textarea('map_iframe', $settings['map_iframe'] ?? '', ['class' => 'form-control', 'rows' => 4, 'placeholder' => __('Enter google maps embed iframe code here'), 'required']) }}
                    <small class="form-text text-muted">{{ __('Go to Google Maps, search your location, click Share > Embed a map, and copy the iframe code.') }}</small>
                </div>
            </div>
        </div>
        @if (!empty($settings['map_iframe']))
            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label class="form-label">{{ __('Map Preview') }}</label>
                        <div class="border rounded p-2" style="height: 300px; overflow: hidden;">
                            <div style="width: 100%; height: 100%; pointer-events: none;">
                                {!! $settings['map_iframe'] !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        <div class="row">
            <div class="col-12">
                <div class="text-end">
                    <input class="btn btn-primary" type="submit" value="{{ __('Save Changes') }}">
                </div>
            </div>
        </div>
        {{ Form::close() }}
    </div>
</div>
