@push('css')
    <link href="{{ asset('assets/js/plugins/summernote-0.8.18-dist/summernote-lite.min.css') }}" rel="stylesheet">
@endpush

<div class="card mt-4">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5>{{ __('Custom Pages') }}</h5>
        @permission('mobileservice theme setup manage')
            <a class="btn btn-sm btn-primary" data-ajax-popup="true" data-size="lg" data-title="{{ __('Create Custom Page') }}"
                data-url="{{ route('mobileservice.faq-custom-setup.custom-pages.create') }}" data-toggle="tooltip" title="{{ __('Create') }}">
                <i class="ti ti-plus"></i>
            </a>
        @endpermission
    </div>
    <div class="card-body table-border-style">
        <div class="table-responsive">
            <table class="table mb-0 ">
                <thead>
                    <tr>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Title') }}</th>
                        <th>{{ __('Show in Footer') }}</th>
                        <th>{{ __('URL') }}</th>
                        @permission('mobileservice theme setup manage')
                            <th width="10%">{{ __('Action') }}</th>
                        @endpermission
                    </tr>
                </thead>
                <tbody>
                    @forelse($pages as $page)
                        <tr>
                            <td>{{ $page->name }}</td>
                            <td>{{ $page->title }}</td>
                            <td class="text-primary">
                                @if ($page->show_in_footer == 1)
                                    <badge class="badge bg-success p-2 px-3">{{ __('Yes') }}</badge>
                                @else
                                    <badge class="badge bg-danger p-2 px-3">{{ __('No') }}</badge>
                                @endif
                            </td>
                            <td>
                                <button class="btn btn-sm btn-primary copy-link-btn"
                                    data-link="{{ route('mobileservice.frontend.custom-page', [$slug, $page->slug]) }}"
                                    data-toggle="tooltip" title="{{ __('Copy Link') }}">
                                    <i class="ti ti-copy"></i> {{ __('Copy Link') }}
                                </button>
                            </td>
                            @permission('mobileservice theme setup manage')
                                <td width="10%">
                                    <div class="action-btn me-2">
                                        <a class="bg-info btn btn-sm"
                                            data-url="{{ route('mobileservice.faq-custom-setup.custom-pages.edit', $page->id) }}"
                                            data-ajax-popup="true" data-size="lg" data-title="{{ __('Edit Custom Page') }}"
                                            data-toggle="tooltip" title="{{ __('Edit') }}">
                                            <i class="ti ti-pencil text-white"></i>
                                        </a>
                                    </div>
                                    @if($page->slug != 'privacy-policy' && $page->slug != 'terms-and-condition')
                                        <div class="action-btn">
                                            <form method="POST"
                                                action="{{ route('mobileservice.faq-custom-setup.custom-pages.destroy', $page->id) }}"
                                                id="delete-form-{{ $page->id }}">
                                                @csrf
                                                @method('DELETE')
                                                <a href="#" class="bg-danger btn btn-sm show_confirm"
                                                    data-bs-toggle="tooltip" title="{{ __('Delete') }}"
                                                    data-original-title="{{ __('Delete') }}"
                                                    data-confirm="{{ __('Are You Sure?') }}"
                                                    data-text="{{ __('This action can not be undone. Do you want to continue?') }}"
                                                    data-confirm-yes="delete-form-{{ $page->id }}">
                                                    <i class="ti ti-trash text-white"></i>
                                                </a>
                                            </form>
                                        </div>
                                    @endif
                                </td>
                            @endpermission
                        </tr>
                    @empty
                        @include('layouts.nodatafound')
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

@push('scripts')
    <script src="{{ asset('assets/js/plugins/summernote-0.8.18-dist/summernote-lite.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('.copy-link-btn').on('click', function() {
                var link = $(this).data('link');
                navigator.clipboard.writeText(link).then(function() {
                    toastrs('success', 'Link copied to clipboard!', 'success');
                }).catch(function() {
                    // Fallback for older browsers
                    var textArea = document.createElement('textarea');
                    textArea.value = link;
                    document.body.appendChild(textArea);
                    textArea.select();
                    document.execCommand('copy');
                    document.body.removeChild(textArea);
                    toastrs('success', 'Link copied to clipboard!', 'success');
                });
            });
        });
    </script>
@endpush
