@extends('layouts.main')

@section('page-title')
    {{ __('Theme Setup') }}
@endsection

@section('page-breadcrumb')
    {{ __('System Setup') }}, {{ __('Theme Setup') }}
@endsection

@section('content')
    <div class="row">
        <div class="col-sm-12">
            @include('mobile-service-management::theme-setup.sections')
            @include('mobile-service-management::theme-setup.faq-custom-setup.faq')
            @include('mobile-service-management::theme-setup.faq-custom-setup.custom-pages.index')
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        // Section toggle functionality
        $(document).ready(function() {
            $('.section-toggle').on('change', function() {
                var checkbox = $(this);
                var checkboxName = checkbox.attr('name');
                var checkboxStatus = checkbox.is(':checked') ? 'on' : 'off';

                $.ajax({
                    url: '{{ route('mobileservice.theme-setup.toggle') }}',
                    method: 'POST',
                    data: {
                        [checkboxName]: checkboxStatus,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        toastrs('success', response.success, 'success');
                    },
                    error: function(xhr) {
                        let message = xhr.responseJSON?.error || __('Something went wrong!');
                        toastrs('Error', message, 'error');
                    }
                });
            });
        });
    </script>
@endpush
